/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.io.oracle;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.oracle.OraGeom;
import com.vividsolutions.jts.io.oracle.OraUtil;
import com.vividsolutions.jts.util.Assert;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import oracle.jdbc.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;

public class OraWriter {
    private OracleConnection connection;
    private int outputDimension = -1;
    private int srid = -1;
    private boolean isOptimizeRectangle = false;
    private boolean isOptimizePoint = true;

    public OraWriter() {
    }

    public OraWriter(int outputDimension) {
        this.outputDimension = outputDimension;
    }

    public OraWriter(OracleConnection con) {
        this.connection = con;
    }

    public OraWriter(OracleConnection con, int outputDimension) {
        this.connection = con;
        this.outputDimension = outputDimension;
    }

    public void setDimension(int outputDimension) {
        if (outputDimension < 2) {
            throw new IllegalArgumentException("Output dimension must be >= 2");
        }
        this.outputDimension = outputDimension;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public void setOptimizeRectangle(boolean isOptimizeRectangle) {
        this.isOptimizeRectangle = isOptimizeRectangle;
    }

    public void setOptimizePoint(boolean isOptimizePoint) {
        this.isOptimizePoint = isOptimizePoint;
    }

    public STRUCT write(Geometry geom) throws SQLException {
        return this.write(geom, this.connection);
    }

    public STRUCT write(Geometry geom, OracleConnection connection) throws SQLException {
        if (geom == null || geom.isEmpty() || geom.getCoordinate() == null) {
            return this.createEmptySDOGeometry(connection);
        }
        OraGeom oraGeom = this.createOraGeom(geom);
        STRUCT SDO_POINT = null;
        ARRAY SDO_ELEM_INFO = null;
        ARRAY SDO_ORDINATES = null;
        if (oraGeom.point == null) {
            SDO_ELEM_INFO = OraUtil.toARRAY(oraGeom.elemInfo, "MDSYS.SDO_ELEM_INFO_ARRAY", connection);
            SDO_ORDINATES = OraUtil.toARRAY(oraGeom.ordinates, "MDSYS.SDO_ORDINATE_ARRAY", connection);
        } else {
            Datum[] data = new Datum[]{OraUtil.toNUMBER(oraGeom.point[0]), OraUtil.toNUMBER(oraGeom.point[1]), OraUtil.toNUMBER(oraGeom.point[2])};
            SDO_POINT = OraUtil.toSTRUCT(data, "MDSYS.SDO_POINT_TYPE", connection);
        }
        NUMBER SDO_GTYPE = new NUMBER(oraGeom.gType);
        NUMBER SDO_SRID = oraGeom.srid == -1 ? null : new NUMBER(oraGeom.srid);
        Datum[] sdoGeometryComponents = new Datum[]{SDO_GTYPE, SDO_SRID, SDO_POINT, SDO_ELEM_INFO, SDO_ORDINATES};
        return OraUtil.toSTRUCT(sdoGeometryComponents, "MDSYS.SDO_GEOMETRY", connection);
    }

    public String writeSQL(Geometry geom) {
        if (geom == null) {
            return "NULL";
        }
        OraGeom oraGeom = this.createOraGeom(geom);
        return oraGeom.toString();
    }

    private STRUCT createEmptySDOGeometry(OracleConnection connection) throws SQLException {
        return OraUtil.toSTRUCT(new Datum[5], "MDSYS.SDO_GEOMETRY", connection);
    }

    OraGeom createOraGeom(Geometry geom) {
        int gtype = this.gType(geom);
        int srid = this.srid == -1 ? geom.getSRID() : this.srid;
        double[] point = null;
        int[] elemInfo = null;
        double[] ordinates = null;
        if (this.isEncodeAsPointType(geom)) {
            point = this.pointOrdinates(geom);
        } else {
            int dim = this.dimension(geom);
            ArrayList elemTriplets = new ArrayList();
            ArrayList ordGeoms = new ArrayList();
            int lastOrdOffset = this.writeElement(geom, dim, 1, elemTriplets, ordGeoms);
            elemInfo = this.flattenTriplets(elemTriplets);
            ordinates = this.writeGeometryOrdinates(elemTriplets, ordGeoms, lastOrdOffset - 1, dim);
        }
        OraGeom oraGeom = new OraGeom(gtype, srid, point, elemInfo, ordinates);
        return oraGeom;
    }

    private double[] pointOrdinates(Geometry geom) {
        Point point = (Point)geom;
        Coordinate coord = point.getCoordinate();
        return new double[]{coord.x, coord.y, coord.z};
    }

    private int writeElement(Geometry geom, int dim, int offset, List elemTriplets, List ordGeoms) {
        int geomType = OraGeom.geomType(geom);
        switch (geomType) {
            case 1: {
                Point point = (Point)geom;
                elemTriplets.add(OraWriter.triplet(offset, 1, 1));
                ordGeoms.add(point);
                return offset + dim;
            }
            case 5: {
                MultiPoint points = (MultiPoint)geom;
                int nPts = points.getNumGeometries();
                elemTriplets.add(OraWriter.triplet(offset, 1, nPts));
                ordGeoms.add(points);
                return offset + dim * nPts;
            }
            case 2: {
                LineString line = (LineString)geom;
                elemTriplets.add(OraWriter.triplet(offset, 2, 1));
                ordGeoms.add(line);
                return offset + dim * line.getNumPoints();
            }
            case 6: {
                MultiLineString lines = (MultiLineString)geom;
                int i = 0;
                while (i < lines.getNumGeometries()) {
                    LineString lineElem = (LineString)lines.getGeometryN(i);
                    offset = this.writeElement((Geometry)lineElem, dim, offset, elemTriplets, ordGeoms);
                    ++i;
                }
                return offset;
            }
            case 3: {
                Polygon polygon = (Polygon)geom;
                LineString ring = polygon.getExteriorRing();
                int interp = this.isWriteAsRectangle(polygon) ? 3 : 1;
                elemTriplets.add(OraWriter.triplet(offset, 1003, interp));
                ordGeoms.add(ring);
                offset = interp == 3 ? (offset += 4) : (offset += dim * ring.getNumPoints());
                int holes = polygon.getNumInteriorRing();
                int i = 0;
                while (i < holes) {
                    ring = polygon.getInteriorRingN(i);
                    elemTriplets.add(OraWriter.triplet(offset, 2003, 1));
                    ordGeoms.add(ring);
                    offset += dim * ring.getNumPoints();
                    ++i;
                }
                return offset;
            }
            case 7: {
                MultiPolygon polys = (MultiPolygon)geom;
                int i = 0;
                while (i < polys.getNumGeometries()) {
                    Polygon poly = (Polygon)polys.getGeometryN(i);
                    offset = this.writeElement((Geometry)poly, dim, offset, elemTriplets, ordGeoms);
                    ++i;
                }
                return offset;
            }
            case 4: {
                GeometryCollection geoms = (GeometryCollection)geom;
                int i = 0;
                while (i < geoms.getNumGeometries()) {
                    geom = geoms.getGeometryN(i);
                    offset = this.writeElement(geom, dim, offset, elemTriplets, ordGeoms);
                    ++i;
                }
                return offset;
            }
        }
        throw new IllegalArgumentException("Cannot encode JTS " + geom.getGeometryType() + " as SDO_ELEM_INFO " + "(Limited to Point, Line, Polygon, GeometryCollection, MultiPoint," + " MultiLineString and MultiPolygon)");
    }

    private static int[] triplet(int sOffset, int etype, int interp) {
        return new int[]{sOffset, etype, interp};
    }

    private int[] flattenTriplets(List elemTriplets) {
        int[] elemInfo = new int[3 * elemTriplets.size()];
        int eiIndex = 0;
        int i = 0;
        while (i < elemTriplets.size()) {
            int[] triplet = (int[])elemTriplets.get(i);
            int ii = 0;
            while (ii < 3) {
                elemInfo[eiIndex++] = triplet[ii];
                ++ii;
            }
            ++i;
        }
        return elemInfo;
    }

    private double[] writeGeometryOrdinates(List elemTriplets, List ordGeoms, int ordSize, int dim) {
        double[] ords = new double[ordSize];
        int ordIndex = 0;
        int ielem = 0;
        while (ielem < elemTriplets.size()) {
            int[] triplet = (int[])elemTriplets.get(ielem);
            int startOffset = triplet[0];
            Assert.isTrue((startOffset == ordIndex + 1 ? 1 : 0) != 0, (String)"ElemInfo computed startingOffset does not match actual ordinates position");
            int elemType = triplet[1];
            int interp = triplet[2];
            Geometry geom = (Geometry)ordGeoms.get(ielem);
            switch (elemType) {
                case 1: {
                    if (interp == 1) {
                        ordIndex = this.writeOrds(((Point)geom).getCoordinateSequence(), dim, ords, ordIndex);
                        break;
                    }
                    ordIndex = this.writeOrds((MultiPoint)geom, dim, ords, ordIndex);
                    break;
                }
                case 2: {
                    ordIndex = this.writeOrds(((LineString)geom).getCoordinateSequence(), dim, ords, ordIndex);
                    break;
                }
                case 1003: {
                    if (interp == 3) {
                        ordIndex = this.writeRectangleOrds(geom, dim, ords, ordIndex);
                        break;
                    }
                    ordIndex = this.writeOrdsOriented(((LineString)geom).getCoordinateSequence(), dim, ords, ordIndex, true);
                    break;
                }
                case 2003: {
                    ordIndex = this.writeOrdsOriented(((LineString)geom).getCoordinateSequence(), dim, ords, ordIndex, false);
                }
            }
            ++ielem;
        }
        return ords;
    }

    private int writeOrdsOriented(CoordinateSequence seq, int dim, double[] ordData, int ordIndex, boolean isWriteCCW) {
        Coordinate[] coords = seq.toCoordinateArray();
        boolean isCCW = CGAlgorithms.isCCW((Coordinate[])coords);
        if (isCCW != isWriteCCW) {
            return this.writeOrdsReverse(seq, dim, ordData, ordIndex);
        }
        return this.writeOrds(seq, dim, ordData, ordIndex);
    }

    private int writeOrdsReverse(CoordinateSequence seq, int dim, double[] ordData, int ordIndex) {
        int nCoord = seq.size();
        int i = nCoord - 1;
        while (i >= 0) {
            int id = 0;
            while (id < dim) {
                ordData[ordIndex++] = seq.getOrdinate(i, id);
                ++id;
            }
            --i;
        }
        return ordIndex;
    }

    private int writeOrds(CoordinateSequence seq, int dim, double[] ordData, int ordIndex) {
        int nCoord = seq.size();
        int i = 0;
        while (i < nCoord) {
            int id = 0;
            while (id < dim) {
                ordData[ordIndex++] = seq.getOrdinate(i, id);
                ++id;
            }
            ++i;
        }
        return ordIndex;
    }

    private int writeOrds(MultiPoint geom, int dim, double[] ordData, int ordIndex) {
        int nGeom = geom.getNumGeometries();
        int i = 0;
        while (i < nGeom) {
            CoordinateSequence seq = ((Point)geom.getGeometryN(i)).getCoordinateSequence();
            int id = 0;
            while (id < dim) {
                ordData[ordIndex++] = seq.getOrdinate(0, id);
                ++id;
            }
            ++i;
        }
        return ordIndex;
    }

    private int writeRectangleOrds(Geometry ring, int dim, double[] ordData, int ordIndex) {
        Envelope e = ring.getEnvelopeInternal();
        ordData[ordIndex++] = e.getMinX();
        ordData[ordIndex++] = e.getMinY();
        ordData[ordIndex++] = e.getMaxX();
        ordData[ordIndex++] = e.getMaxY();
        return ordIndex;
    }

    private boolean isWriteAsRectangle(Polygon polygon) {
        if (!this.isOptimizeRectangle) {
            return false;
        }
        if (this.lrsDim((Geometry)polygon) != 0) {
            return false;
        }
        return polygon.isRectangle();
    }

    private boolean isEncodeAsPointType(Geometry geom) {
        if (!this.isOptimizePoint) {
            return false;
        }
        return geom instanceof Point && this.lrsDim(geom) == 0 && this.outputDimension <= 3;
    }

    private int gType(Geometry geom) {
        return OraGeom.gType(this.dimension(geom), this.lrsDim(geom), OraGeom.geomType(geom));
    }

    private int dimension(Geometry geom) {
        if (this.outputDimension != -1) {
            return this.outputDimension;
        }
        int d = Double.isNaN(geom.getCoordinate().z) ? 2 : 3;
        return d;
    }

    private int lrsDim(Geometry geom) {
        return 0;
    }
}

