/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.vk.api.sdk.R;
import com.vk.api.sdk.VK;
import com.vk.api.sdk.VKKeyValueStorage;
import com.vk.api.sdk.auth.VKAccessToken;
import com.vk.api.sdk.auth.VKAuthCallback;
import com.vk.api.sdk.auth.VKAuthParams;
import com.vk.api.sdk.auth.VKAuthResult;
import com.vk.api.sdk.auth.VKScope;
import com.vk.api.sdk.exceptions.VKAuthException;
import com.vk.api.sdk.extensions.ContextExtKt;
import com.vk.api.sdk.ui.VKWebViewAuthActivity;
import com.vk.api.sdk.utils.VKUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ8\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\nJ\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager;", "", "keyValueStorage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "(Lcom/vk/api/sdk/VKKeyValueStorage;)V", "clearAccessToken", "", "getCurrentToken", "Lcom/vk/api/sdk/auth/VKAccessToken;", "isLoggedIn", "", "login", "activity", "Landroid/app/Activity;", "scopes", "", "Lcom/vk/api/sdk/auth/VKScope;", "onActivityResult", "context", "Landroid/content/Context;", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "callback", "Lcom/vk/api/sdk/auth/VKAuthCallback;", "showErrorToast", "prepareScopes", "processResult", "Lcom/vk/api/sdk/auth/VKAuthResult;", "result", "startAuthActivity", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "startInternalAuthActivity", "Companion", "core_release"})
public final class VKAuthManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VKKeyValueStorage keyValueStorage;
    @NotNull
    public static final String VK_APP_PACKAGE_ID = "com.vkontakte.android";
    @NotNull
    private static final String VK_APP_AUTH_ACTION = "com.vkontakte.android.action.SDK_AUTH";
    @NotNull
    public static final String VK_EXTRA_TOKEN_DATA = "extra-token-data";
    @NotNull
    public static final String VK_AUTH_ERROR = "error";
    private static final int VK_APP_AUTH_CODE = 282;

    public VKAuthManager(@NotNull VKKeyValueStorage keyValueStorage) {
        Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
        this.keyValueStorage = keyValueStorage;
    }

    public final void login(@NotNull Activity activity, @NotNull Collection<? extends VKScope> scopes) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        VKAuthParams params = new VKAuthParams(VK.getAppId((Context)activity), null, this.prepareScopes(scopes), 2, null);
        if (VKUtils.isIntentAvailable((Context)activity, VK_APP_AUTH_ACTION, null, VK_APP_PACKAGE_ID)) {
            this.startAuthActivity(activity, params);
        } else {
            this.startInternalAuthActivity(activity, params);
        }
    }

    private final void startAuthActivity(Activity activity, VKAuthParams params) {
        Intent intent = new Intent(VK_APP_AUTH_ACTION, null);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$startAuthActivity_u24lambda_u2d0 = intent;
        boolean bl3 = false;
        $this$startAuthActivity_u24lambda_u2d0.setPackage(VK_APP_PACKAGE_ID);
        $this$startAuthActivity_u24lambda_u2d0.putExtras(params.toExtraBundle());
        Intent intent2 = intent;
        activity.startActivityForResult(intent2, 282);
    }

    private final void startInternalAuthActivity(Activity activity, VKAuthParams params) {
        VKWebViewAuthActivity.Companion.startForAuth(activity, params, 282);
    }

    public final boolean onActivityResult(@NotNull Context context, int requestCode, int resultCode, @Nullable Intent data, @NotNull VKAuthCallback callback, boolean showErrorToast) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (requestCode != 282) {
            return false;
        }
        if (data == null) {
            callback.onLoginFailed(new VKAuthException(0, null, 3, null));
            return true;
        }
        VKAuthResult result = this.processResult(data);
        if (resultCode != -1 || result == null || result.isError()) {
            int n;
            Bundle bundle = data.getExtras();
            int webViewError = bundle == null ? 0 : (n = bundle.getInt("vw_login_error"));
            Bundle bundle2 = data.getExtras();
            String authError = bundle2 == null ? null : bundle2.getString(VK_AUTH_ERROR);
            VKAuthException loginError = new VKAuthException(webViewError, authError);
            callback.onLoginFailed(loginError);
            if (showErrorToast && !loginError.isCanceled()) {
                ContextExtKt.showToast(context, R.string.vk_message_login_error);
            }
        } else {
            VKAccessToken vKAccessToken = result.getAccessToken();
            Intrinsics.checkNotNull((Object)vKAccessToken);
            vKAccessToken.save(this.keyValueStorage);
            VK.INSTANCE.getApiManager$core_release().setCredentials(result.getAccessToken().getAccessToken(), result.getAccessToken().getSecret());
            callback.onLogin(result.getAccessToken());
        }
        return true;
    }

    private final VKAuthResult processResult(Intent result) {
        Object object;
        Map tokenParams = null;
        if (result.hasExtra(VK_EXTRA_TOKEN_DATA)) {
            String tokenInfo = result.getStringExtra(VK_EXTRA_TOKEN_DATA);
            tokenParams = VKUtils.explodeQueryString(tokenInfo);
        } else if (result.getExtras() != null) {
            tokenParams = new HashMap();
            Bundle bundle = result.getExtras();
            Intrinsics.checkNotNull((Object)bundle);
            for (String key : bundle.keySet()) {
                Map map = tokenParams;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string2 = key;
                Bundle bundle2 = result.getExtras();
                Intrinsics.checkNotNull((Object)bundle2);
                String string3 = String.valueOf(bundle2.get(key));
                boolean bl = false;
                map.put(string2, string3);
            }
        } else {
            return null;
        }
        if (tokenParams != null && tokenParams.get(VK_AUTH_ERROR) == null) {
            Object object2;
            try {
                object2 = new VKAuthResult(new VKAccessToken(tokenParams), 0, 2, null);
            }
            catch (Exception e) {
                Log.e((String)VKAuthManager.class.getSimpleName(), (String)"Failed to get VK token", (Throwable)e);
                object2 = null;
            }
            object = object2;
        } else {
            object = null;
        }
        return object;
    }

    private final Collection<VKScope> prepareScopes(Collection<? extends VKScope> scopes) {
        if (!scopes.contains((Object)VKScope.OFFLINE)) {
            return CollectionsKt.plus(scopes, (Object)((Object)VKScope.OFFLINE));
        }
        return scopes;
    }

    public final boolean isLoggedIn() {
        VKAccessToken token = this.getCurrentToken();
        return token != null && token.isValid();
    }

    @Nullable
    public final VKAccessToken getCurrentToken() {
        return VKAccessToken.Companion.restore(this.keyValueStorage);
    }

    public final void clearAccessToken() {
        VKAccessToken.Companion.remove(this.keyValueStorage);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager$Companion;", "", "()V", "VK_APP_AUTH_ACTION", "", "VK_APP_AUTH_CODE", "", "VK_APP_PACKAGE_ID", "VK_AUTH_ERROR", "VK_EXTRA_TOKEN_DATA", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

