/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.os.Bundle;
import com.vk.api.sdk.auth.VKScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vk/api/sdk/auth/VKAuthParams;", "", "appId", "", "redirectUrl", "", "scope", "", "Lcom/vk/api/sdk/auth/VKScope;", "(ILjava/lang/String;Ljava/util/Collection;)V", "getAppId", "()I", "getRedirectUrl", "()Ljava/lang/String;", "", "getScopeString", "toBundle", "Landroid/os/Bundle;", "toExtraBundle", "Companion", "core_release"})
public final class VKAuthParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int appId;
    @NotNull
    private final String redirectUrl;
    @NotNull
    private final Set<VKScope> scope;
    @NotNull
    private static final String VK_APP_ID_KEY = "vk_app_id";
    @NotNull
    private static final String VK_APP_SCOPE_KEY = "vk_app_scope";
    @NotNull
    private static final String VK_APP_REDIRECT_URL_KEY = "vk_app_redirect_url";
    @NotNull
    private static final String VK_EXTRA_CLIENT_ID = "client_id";
    @NotNull
    private static final String VK_EXTRA_REVOKE = "revoke";
    @NotNull
    private static final String VK_EXTRA_SCOPE = "scope";
    @NotNull
    private static final String VK_EXTRA_REDIRECT_URL = "redirect_url";
    @NotNull
    public static final String DEFAULT_REDIRECT_URL = "https://oauth.vk.com/blank.html";

    @JvmOverloads
    public VKAuthParams(int appId, @NotNull String redirectUrl, @NotNull Collection<? extends VKScope> scope) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        Intrinsics.checkNotNullParameter(scope, (String)VK_EXTRA_SCOPE);
        this.appId = appId;
        this.redirectUrl = redirectUrl;
        if (this.appId == 0) {
            throw new IllegalStateException("AppId is empty! Find out how to get your appId at https://vk.com/dev/access_token");
        }
        this.scope = new HashSet<VKScope>(scope);
    }

    public /* synthetic */ VKAuthParams(int n, String string2, Collection collection, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = DEFAULT_REDIRECT_URL;
        }
        if ((n2 & 4) != 0) {
            collection = SetsKt.emptySet();
        }
        this(n, string2, collection);
    }

    public final int getAppId() {
        return this.appId;
    }

    @NotNull
    public final String getRedirectUrl() {
        return this.redirectUrl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Bundle toBundle() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Bundle bundle = new Bundle();
        bundle.putInt(VK_APP_ID_KEY, this.appId);
        Iterable iterable = this.scope;
        String string2 = VK_APP_SCOPE_KEY;
        Bundle bundle2 = bundle;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VKScope vKScope = (VKScope)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            String string3 = it.name();
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        bundle2.putStringArrayList(string2, new ArrayList(collection2));
        bundle.putString(VK_APP_REDIRECT_URL_KEY, this.redirectUrl);
        return bundle;
    }

    @NotNull
    public final Bundle toExtraBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(VK_EXTRA_CLIENT_ID, this.appId);
        bundle.putBoolean(VK_EXTRA_REVOKE, true);
        bundle.putString(VK_EXTRA_SCOPE, CollectionsKt.joinToString$default((Iterable)this.scope, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        bundle.putString(VK_EXTRA_REDIRECT_URL, this.redirectUrl);
        return bundle;
    }

    @NotNull
    public final String getScopeString() {
        return CollectionsKt.joinToString$default((Iterable)this.scope, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public VKAuthParams(int appId, @NotNull String redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        this(appId, redirectUrl, null, 4, null);
    }

    @JvmOverloads
    public VKAuthParams(int appId) {
        this(appId, null, null, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vk/api/sdk/auth/VKAuthParams$Companion;", "", "()V", "DEFAULT_REDIRECT_URL", "", "VK_APP_ID_KEY", "VK_APP_REDIRECT_URL_KEY", "VK_APP_SCOPE_KEY", "VK_EXTRA_CLIENT_ID", "VK_EXTRA_REDIRECT_URL", "VK_EXTRA_REVOKE", "VK_EXTRA_SCOPE", "fromBundle", "Lcom/vk/api/sdk/auth/VKAuthParams;", "bundle", "Landroid/os/Bundle;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final VKAuthParams fromBundle(@Nullable Bundle bundle) {
            List list;
            if (bundle == null) {
                return null;
            }
            int appId = bundle.getInt(VKAuthParams.VK_APP_ID_KEY);
            ArrayList arrayList = bundle.getStringArrayList(VKAuthParams.VK_APP_SCOPE_KEY);
            if (arrayList == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = arrayList;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    VKScope vKScope = VKScope.valueOf((String)it);
                    collection.add(vKScope);
                }
                list = (List)destination$iv$iv;
            }
            List list2 = list;
            Collection scope = list2 == null ? (Collection)SetsKt.emptySet() : (Collection)list2;
            String redirectUrl = bundle.getString(VKAuthParams.VK_APP_REDIRECT_URL_KEY, VKAuthParams.DEFAULT_REDIRECT_URL);
            Intrinsics.checkNotNullExpressionValue((Object)redirectUrl, (String)"redirectUrl");
            return new VKAuthParams(appId, redirectUrl, scope);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

