/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiIllegalCredentialsListener;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vk/api/sdk/chain/InvalidCredentialsObserverChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "chain", "checkAuthCount", "", "(Lcom/vk/api/sdk/VKApiManager;Lcom/vk/api/sdk/chain/ChainCall;I)V", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "callWithAuthCheck", "iteration", "(Lcom/vk/api/sdk/chain/ChainArgs;I)Ljava/lang/Object;", "core_release"})
public final class InvalidCredentialsObserverChainCall<T>
extends ChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;
    private final int checkAuthCount;

    public InvalidCredentialsObserverChainCall(@NotNull VKApiManager manager, @NotNull ChainCall<? extends T> chain, int checkAuthCount) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        super(manager);
        this.chain = chain;
        this.checkAuthCount = checkAuthCount;
    }

    public /* synthetic */ InvalidCredentialsObserverChainCall(VKApiManager vKApiManager, ChainCall chainCall, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(vKApiManager, chainCall, n);
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        return this.callWithAuthCheck(args, 0);
    }

    private final T callWithAuthCheck(ChainArgs args, int iteration) {
        try {
            return this.chain.call(args);
        }
        catch (VKApiExecutionException ex) {
            if (ex.isInvalidCredentialsError()) {
                VKApiIllegalCredentialsListener vKApiIllegalCredentialsListener;
                if (this.checkAuthCount > 0 && iteration < this.checkAuthCount) {
                    boolean isIgnoredAccessToken;
                    String failedAccessToken = ex.getAccessToken();
                    String executorAccessToken = this.getManager().getExecutor().getAccessToken();
                    String ignoredAccessToken = this.getManager().getExecutor().getIgnoredAccessToken();
                    boolean isDifferentAccessToken = !Intrinsics.areEqual((Object)failedAccessToken, (Object)executorAccessToken);
                    boolean bl = isIgnoredAccessToken = ignoredAccessToken != null && Intrinsics.areEqual((Object)failedAccessToken, (Object)ignoredAccessToken);
                    if (failedAccessToken != null && (isDifferentAccessToken || isIgnoredAccessToken)) {
                        return this.callWithAuthCheck(args, iteration + 1);
                    }
                }
                if (ex.getCode() == 3610) {
                    vKApiIllegalCredentialsListener = this.getManager().getIllegalCredentialsListener();
                    if (vKApiIllegalCredentialsListener != null) {
                        vKApiIllegalCredentialsListener.onUserDeactivated(ex.getApiMethod());
                    }
                } else {
                    vKApiIllegalCredentialsListener = this.getManager().getIllegalCredentialsListener();
                    if (vKApiIllegalCredentialsListener != null) {
                        vKApiIllegalCredentialsListener.onInvalidCredentials(ex.getApiMethod(), ex.getUserBanInfo());
                    }
                }
            }
            throw ex;
        }
    }
}

