/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import com.vk.api.sdk.VKHttpPostCall;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpPostCall;", "", "b", "Lcom/vk/api/sdk/okhttp/OkHttpPostCall$Builder;", "(Lcom/vk/api/sdk/okhttp/OkHttpPostCall$Builder;)V", "call", "Lcom/vk/api/sdk/VKHttpPostCall;", "(Lcom/vk/api/sdk/VKHttpPostCall;)V", "isMultipart", "", "()Z", "parts", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "getParts", "()Ljava/util/Map;", "timeoutMs", "", "getTimeoutMs", "()J", "url", "getUrl", "()Ljava/lang/String;", "Builder", "core_release"})
public class OkHttpPostCall {
    @NotNull
    private final String url;
    private final boolean isMultipart;
    @NotNull
    private final Map<String, HttpMultipartEntry> parts;
    private final long timeoutMs;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final boolean isMultipart() {
        return this.isMultipart;
    }

    @NotNull
    public final Map<String, HttpMultipartEntry> getParts() {
        return this.parts;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    protected OkHttpPostCall(@NotNull Builder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (StringsKt.isBlank((CharSequence)b.getUrl())) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal url value: ", (Object)b.getUrl()));
        }
        if (b.getTimeoutMs() < 0L) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal timeout value: ", (Object)b.getTimeoutMs()));
        }
        if (!b.isMultipart()) {
            boolean bl;
            block7: {
                Map<String, HttpMultipartEntry> $this$any$iv = b.getParts();
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Map<String, HttpMultipartEntry> map = $this$any$iv;
                    boolean bl2 = false;
                    Iterator<Map.Entry<String, HttpMultipartEntry>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, HttpMultipartEntry> element$iv;
                        Map.Entry<String, HttpMultipartEntry> it = element$iv = iterator.next();
                        boolean bl3 = false;
                        if (!(!(it.getValue() instanceof HttpMultipartEntry.Text))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException("Non multipart calls should consist of text arguments only");
            }
        }
        this.url = b.getUrl();
        this.isMultipart = b.isMultipart();
        this.parts = b.getParts();
        this.timeoutMs = b.getTimeoutMs();
    }

    public OkHttpPostCall(@NotNull VKHttpPostCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        this.url = call.getUrl();
        this.isMultipart = call.isMultipart();
        this.parts = call.getParts();
        this.timeoutMs = call.getTimeoutMs();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0004J\u001a\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R6\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpPostCall$Builder;", "", "()V", "<set-?>", "", "isMultipart", "()Z", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "parts", "getParts", "()Ljava/util/Map;", "timeoutMs", "", "getTimeoutMs", "()J", "setTimeoutMs", "(J)V", "url", "getUrl", "()Ljava/lang/String;", "build", "Lcom/vk/api/sdk/okhttp/OkHttpPostCall;", "multipart", "", "timeout", "core_release"})
    public static class Builder {
        @NotNull
        private String url = "";
        private boolean isMultipart = true;
        @NotNull
        private Map<String, HttpMultipartEntry> parts = new HashMap();
        private long timeoutMs;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isMultipart() {
            return this.isMultipart;
        }

        @NotNull
        public final Map<String, HttpMultipartEntry> getParts() {
            return this.parts;
        }

        public final long getTimeoutMs() {
            return this.timeoutMs;
        }

        public final void setTimeoutMs(long l) {
            this.timeoutMs = l;
        }

        @NotNull
        public final Builder url(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$url_u24lambda_u2d0 = builder;
            boolean bl3 = false;
            $this$url_u24lambda_u2d0.url = url;
            return builder;
        }

        @NotNull
        public final Builder multipart(boolean multipart) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$multipart_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            $this$multipart_u24lambda_u2d1.isMultipart = multipart;
            return builder;
        }

        @NotNull
        public final Builder parts(@NotNull Map<String, ? extends HttpMultipartEntry> parts) {
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$parts_u24lambda_u2d2 = builder;
            boolean bl3 = false;
            $this$parts_u24lambda_u2d2.getParts().clear();
            $this$parts_u24lambda_u2d2.getParts().putAll(parts);
            return builder;
        }

        @NotNull
        public final Builder timeout(long timeout) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$timeout_u24lambda_u2d3 = builder;
            boolean bl3 = false;
            $this$timeout_u24lambda_u2d3.setTimeoutMs(timeout);
            return builder;
        }

        @NotNull
        public OkHttpPostCall build() {
            return new OkHttpPostCall(this);
        }
    }
}

