/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.annotation.RequiresApi;
import com.vk.api.sdk.R;
import com.vk.api.sdk.VK;
import com.vk.api.sdk.VKApiValidationHandler;
import com.vk.api.sdk.auth.VKAuthParams;
import com.vk.api.sdk.extensions.ContextExtKt;
import com.vk.api.sdk.utils.VKUtils;
import com.vk.api.sdk.utils.VKValidationLocker;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0003J\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u000fH\u0002J\u0012\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u000fH\u0014J\b\u0010\u001d\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity;", "Landroid/app/Activity;", "()V", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "progress", "Landroid/widget/ProgressBar;", "redirectUrl", "", "kotlin.jvm.PlatformType", "getRedirectUrl", "()Ljava/lang/String;", "webView", "Landroid/webkit/WebView;", "configureWebView", "", "getUrlParams", "", "handleSuccess", "uri", "Landroid/net/Uri;", "loadUrl", "needValidationResult", "", "notifyLockerAndFinish", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "showWebView", "Companion", "OAuthWebViewClient", "core_release"})
public class VKWebViewAuthActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private WebView webView;
    private ProgressBar progress;
    private VKAuthParams params;
    @NotNull
    public static final String VK_EXTRA_AUTH_PARAMS = "vk_auth_params";
    @NotNull
    public static final String VK_RESULT_INTENT_NAME = "com.vk.auth-token";
    @NotNull
    private static final String VK_EXTRA_VALIDATION_URL = "vk_validation_url";
    @Nullable
    private static VKApiValidationHandler.Credentials validationResult;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.vk_webview_auth_dialog);
        View view = this.findViewById(R.id.webView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.webView)");
        this.webView = (WebView)view;
        view = this.findViewById(R.id.progress);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.progress)");
        this.progress = (ProgressBar)view;
        VKAuthParams authParams = VKAuthParams.Companion.fromBundle(this.getIntent().getBundleExtra(VK_EXTRA_AUTH_PARAMS));
        if (authParams == null) {
            if (!this.needValidationResult()) {
                this.finish();
            }
        } else {
            this.params = authParams;
        }
        this.configureWebView();
        this.loadUrl();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void configureWebView() {
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            throw null;
        }
        boolean bl = false;
        boolean bl2 = false;
        WebView $this$configureWebView_u24lambda_u2d0 = webView;
        boolean bl3 = false;
        $this$configureWebView_u24lambda_u2d0.setWebViewClient((WebViewClient)new OAuthWebViewClient());
        $this$configureWebView_u24lambda_u2d0.setVerticalScrollBarEnabled(false);
        $this$configureWebView_u24lambda_u2d0.setVisibility(4);
        $this$configureWebView_u24lambda_u2d0.setOverScrollMode(2);
        webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            throw null;
        }
        webView = webView.getSettings();
        bl = false;
        bl2 = false;
        WebView $this$configureWebView_u24lambda_u2d1 = webView;
        boolean bl4 = false;
        $this$configureWebView_u24lambda_u2d1.setJavaScriptEnabled(true);
    }

    @NotNull
    protected Map<String, String> getUrlParams() {
        Pair[] pairArray = new Pair[7];
        VKAuthParams vKAuthParams = this.params;
        if (vKAuthParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            throw null;
        }
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)String.valueOf(vKAuthParams.getAppId()));
        vKAuthParams = this.params;
        if (vKAuthParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            throw null;
        }
        pairArray[1] = TuplesKt.to((Object)"scope", (Object)vKAuthParams.getScopeString());
        vKAuthParams = this.params;
        if (vKAuthParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            throw null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirect_uri", (Object)vKAuthParams.getRedirectUrl());
        pairArray[3] = TuplesKt.to((Object)"response_type", (Object)"token");
        pairArray[4] = TuplesKt.to((Object)"display", (Object)"mobile");
        pairArray[5] = TuplesKt.to((Object)"v", (Object)VK.getApiVersion());
        pairArray[6] = TuplesKt.to((Object)"revoke", (Object)"1");
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final void loadUrl() {
        try {
            String string2;
            if (this.needValidationResult()) {
                string2 = this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL);
            } else {
                Uri.Builder uri = Uri.parse((String)"https://oauth.vk.com/authorize").buildUpon();
                Map<String, String> params = this.getUrlParams();
                Object object = params;
                boolean bl = false;
                Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Object object2 = object = iterator.next();
                    boolean bl2 = false;
                    String key = (String)object2.getKey();
                    Object object3 = object;
                    boolean bl3 = false;
                    String value2 = (String)object3.getValue();
                    uri.appendQueryParameter(key, value2);
                }
                string2 = uri.build().toString();
            }
            String urlToLoad = string2;
            WebView webView = this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                throw null;
            }
            webView.loadUrl(urlToLoad);
        }
        catch (Exception e) {
            this.setResult(0);
            this.finish();
        }
    }

    private final boolean needValidationResult() {
        return this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL) != null;
    }

    private final String getRedirectUrl() {
        String string2;
        if (this.needValidationResult()) {
            string2 = this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL);
        } else {
            VKAuthParams vKAuthParams = this.params;
            if (vKAuthParams == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                throw null;
            }
            string2 = vKAuthParams.getRedirectUrl();
        }
        return string2;
    }

    private final void showWebView() {
        ProgressBar progressBar = this.progress;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            throw null;
        }
        progressBar.setVisibility(8);
        progressBar = this.webView;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            throw null;
        }
        progressBar.setVisibility(0);
    }

    protected void onDestroy() {
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            throw null;
        }
        webView.destroy();
        VKValidationLocker.INSTANCE.signal();
        super.onDestroy();
    }

    private final void notifyLockerAndFinish() {
        VKValidationLocker.INSTANCE.signal();
        this.finish();
    }

    private final void handleSuccess(Uri uri) {
        VKApiValidationHandler.Credentials credentials2;
        if (uri.getQueryParameter("access_token") != null) {
            Integer n;
            String token = uri.getQueryParameter("access_token");
            String secret = uri.getQueryParameter("secret");
            String string2 = uri.getQueryParameter("user_id");
            if (string2 == null) {
                n = null;
            } else {
                String string3 = string2;
                boolean bl = false;
                n = Integer.parseInt(string3);
            }
            Integer userId = n;
            credentials2 = new VKApiValidationHandler.Credentials(secret, token, userId);
        } else {
            credentials2 = VKApiValidationHandler.Credentials.Companion.getEMPTY();
        }
        validationResult = credentials2;
        this.notifyLockerAndFinish();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J&\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J&\u0010\u0012\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0017J.\u0010\u0012\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J\u001c\u0010\u0019\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\u001c\u0010\u0019\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity$OAuthWebViewClient;", "Landroid/webkit/WebViewClient;", "(Lcom/vk/api/sdk/ui/VKWebViewAuthActivity;)V", "hasError", "", "handleUrl", "url", "", "onError", "", "errorCode", "", "onPageFinished", "view", "Landroid/webkit/WebView;", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "description", "failingUrl", "shouldOverrideUrlLoading", "core_release"})
    public final class OAuthWebViewClient
    extends WebViewClient {
        private boolean hasError;

        public OAuthWebViewClient() {
            Intrinsics.checkNotNullParameter((Object)((Object)VKWebViewAuthActivity.this), (String)"this$0");
        }

        @RequiresApi(value=21)
        public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
            WebResourceRequest webResourceRequest = request;
            return this.handleUrl(String.valueOf(webResourceRequest == null ? null : webResourceRequest.getUrl()));
        }

        public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
            return this.handleUrl(url);
        }

        private final boolean handleUrl(String url) {
            if (url == null) {
                return false;
            }
            if (VKWebViewAuthActivity.this.needValidationResult()) {
                Uri uri = Uri.parse((String)StringsKt.replace$default((String)url, (String)"#", (String)"?", (boolean)false, (int)4, null));
                if (uri.getQueryParameter("success") != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                    VKWebViewAuthActivity.this.handleSuccess(uri);
                } else if (uri.getQueryParameter("cancel") != null) {
                    VKWebViewAuthActivity.this.notifyLockerAndFinish();
                }
                return false;
            }
            String uri = VKWebViewAuthActivity.this.getRedirectUrl();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"redirectUrl");
            if (!StringsKt.startsWith$default((String)url, (String)uri, (boolean)false, (int)2, null)) {
                return false;
            }
            Intent intent = new Intent(VKWebViewAuthActivity.VK_RESULT_INTENT_NAME);
            String string2 = url;
            int n = StringsKt.indexOf$default((CharSequence)url, (String)"#", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String extraData = string3;
            intent.putExtra("extra-token-data", extraData);
            Map<String, String> resultParams = VKUtils.explodeQueryString(extraData);
            int resultCode = resultParams != null && (resultParams.containsKey("error") || resultParams.containsKey("cancel")) ? 0 : -1;
            VKWebViewAuthActivity.this.setResult(resultCode, intent);
            VKWebViewAuthActivity.this.notifyLockerAndFinish();
            return true;
        }

        public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            this.handleUrl(url);
        }

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            super.onPageFinished(view, url);
            if (!this.hasError) {
                VKWebViewAuthActivity.this.showWebView();
            }
        }

        @RequiresApi(value=21)
        public void onReceivedError(@Nullable WebView view, @Nullable WebResourceRequest request, @Nullable WebResourceError error) {
            int n;
            WebResourceError webResourceError;
            super.onReceivedError(view, request, error);
            int errorCode = Build.VERSION.SDK_INT >= 23 ? ((webResourceError = error) == null ? -1 : (n = webResourceError.getErrorCode())) : -1;
            this.onError(errorCode);
        }

        public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            this.onError(errorCode);
        }

        private final void onError(int errorCode) {
            this.hasError = true;
            Intent intent = new Intent();
            boolean bl = false;
            boolean bl2 = false;
            Intent $this$onError_u24lambda_u2d0 = intent;
            boolean bl3 = false;
            $this$onError_u24lambda_u2d0.putExtra("vw_login_error", errorCode);
            Intent intent2 = intent;
            VKWebViewAuthActivity.this.setResult(0, intent2);
            VKWebViewAuthActivity.this.finish();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity$Companion;", "", "()V", "VK_EXTRA_AUTH_PARAMS", "", "VK_EXTRA_VALIDATION_URL", "VK_RESULT_INTENT_NAME", "validationResult", "Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "getValidationResult", "()Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "setValidationResult", "(Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;)V", "startForAuth", "", "activity", "Landroid/app/Activity;", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "code", "", "startForValidation", "context", "Landroid/content/Context;", "validationUrl", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VKApiValidationHandler.Credentials getValidationResult() {
            return validationResult;
        }

        public final void setValidationResult(@Nullable VKApiValidationHandler.Credentials credentials2) {
            validationResult = credentials2;
        }

        public final void startForAuth(@NotNull Activity activity, @NotNull VKAuthParams params, int code) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intent intent = new Intent((Context)activity, VKWebViewAuthActivity.class).putExtra(VKWebViewAuthActivity.VK_EXTRA_AUTH_PARAMS, params.toBundle());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(activity, VKWebViewAuthActivity::class.java)\n                .putExtra(VK_EXTRA_AUTH_PARAMS, params.toBundle())");
            Intent intent2 = intent;
            activity.startActivityForResult(intent2, code);
        }

        public final void startForValidation(@NotNull Context context, @NotNull String validationUrl) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)validationUrl, (String)"validationUrl");
            Intent intent = new Intent(context, VKWebViewAuthActivity.class).putExtra(VKWebViewAuthActivity.VK_EXTRA_VALIDATION_URL, validationUrl);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, VKWebViewAuthActivity::class.java)\n                .putExtra(VK_EXTRA_VALIDATION_URL, validationUrl)");
            Intent intent2 = intent;
            if (ContextExtKt.toActivitySafe(context) == null) {
                intent2.addFlags(0x10000000);
            }
            context.startActivity(intent2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

