/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.os.Bundle;
import com.vk.api.sdk.VKKeyValueStorage;
import com.vk.dto.common.id.UserId;
import com.vk.dto.common.id.UserIdKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0001&B!\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\tH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006'"}, d2={"Lcom/vk/api/sdk/auth/VKAccessToken;", "", "userId", "Lcom/vk/dto/common/id/UserId;", "accessToken", "", "secret", "(Lcom/vk/dto/common/id/UserId;Ljava/lang/String;Ljava/lang/String;)V", "params", "", "(Ljava/util/Map;)V", "getAccessToken", "()Ljava/lang/String;", "created", "", "getCreated", "()J", "email", "getEmail", "expirationDate", "httpsRequired", "", "isValid", "()Z", "phone", "getPhone", "phoneAccessKey", "getPhoneAccessKey", "getSecret", "getUserId", "()Lcom/vk/dto/common/id/UserId;", "save", "", "bundle", "Landroid/os/Bundle;", "storage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "toMap", "Companion", "core_release"})
public final class VKAccessToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserId userId;
    @NotNull
    private final String accessToken;
    @Nullable
    private final String secret;
    private final long created;
    @Nullable
    private final String email;
    @Nullable
    private final String phone;
    @Nullable
    private final String phoneAccessKey;
    private final boolean httpsRequired;
    private final long expirationDate;
    @NotNull
    private static final String ACCESS_TOKEN = "access_token";
    @NotNull
    private static final String EXPIRES_IN = "expires_in";
    @NotNull
    private static final String USER_ID = "user_id";
    @NotNull
    private static final String SECRET = "secret";
    @NotNull
    private static final String HTTPS_REQUIRED = "https_required";
    @NotNull
    private static final String CREATED = "created";
    @NotNull
    private static final String VK_ACCESS_TOKEN_KEY = "vk_access_token";
    @NotNull
    private static final String EMAIL = "email";
    @NotNull
    private static final String PHONE = "phone";
    @NotNull
    private static final String PHONE_ACCESS_KEY = "phone_access_key";
    @NotNull
    private static final List<String> KEYS;

    public VKAccessToken(@NotNull Map<String, String> params) {
        long l;
        long l2;
        UserId userId;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        String string = params.get(USER_ID);
        if (string == null) {
            userId = null;
        } else {
            String string2 = string;
            boolean bl = false;
            long l3 = Long.parseLong(string2);
            userId = UserIdKt.toUserId((long)l3);
        }
        Intrinsics.checkNotNull(userId);
        this.userId = userId;
        String string3 = params.get(ACCESS_TOKEN);
        Intrinsics.checkNotNull((Object)string3);
        this.accessToken = string3;
        this.secret = params.get(SECRET);
        this.httpsRequired = Intrinsics.areEqual((Object)"1", (Object)params.get(HTTPS_REQUIRED));
        if (params.containsKey(CREATED)) {
            String string4 = params.get(CREATED);
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
            boolean bl = false;
            l2 = Long.parseLong(string);
        } else {
            l2 = this.created = System.currentTimeMillis();
        }
        if (params.containsKey(EXPIRES_IN)) {
            String string5 = params.get(EXPIRES_IN);
            Intrinsics.checkNotNull((Object)string5);
            string = string5;
            boolean bl = false;
            l = Long.parseLong(string);
        } else {
            l = -1L;
        }
        this.expirationDate = l;
        this.email = params.containsKey(EMAIL) ? params.get(EMAIL) : null;
        this.phone = params.containsKey(PHONE) ? params.get(PHONE) : null;
        this.phoneAccessKey = params.containsKey(PHONE_ACCESS_KEY) ? params.get(PHONE_ACCESS_KEY) : null;
    }

    public VKAccessToken(@NotNull UserId userId, @NotNull String accessToken, @Nullable String secret) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)USER_ID, (Object)userId.toString()), TuplesKt.to((Object)ACCESS_TOKEN, (Object)accessToken), TuplesKt.to((Object)SECRET, (Object)secret), TuplesKt.to((Object)HTTPS_REQUIRED, (Object)"1")};
        this(MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final UserId getUserId() {
        return this.userId;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public final String getSecret() {
        return this.secret;
    }

    public final long getCreated() {
        return this.created;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @Nullable
    public final String getPhone() {
        return this.phone;
    }

    @Nullable
    public final String getPhoneAccessKey() {
        return this.phoneAccessKey;
    }

    public final boolean isValid() {
        return this.expirationDate <= 0L || this.created + this.expirationDate * (long)1000 > System.currentTimeMillis();
    }

    public final void save(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Bundle vkTokenBundle = new Bundle();
        Map<String, String> tokenParams = this.toMap();
        Object object = tokenParams;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String value2 = (String)object3.getValue();
            vkTokenBundle.putString(key, value2);
        }
        bundle.putBundle(VK_ACCESS_TOKEN_KEY, vkTokenBundle);
    }

    public final void save(@NotNull VKKeyValueStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Map<String, String> tokenParams = this.toMap();
        Object object = tokenParams;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            String value2 = (String)object3.getValue();
            storage.putOrRemove(key, value2);
        }
    }

    private final Map<String, String> toMap() {
        HashMap result = new HashMap();
        Map map = result;
        String string = ACCESS_TOKEN;
        String string2 = this.accessToken;
        boolean bl = false;
        map.put(string, string2);
        map = result;
        string = SECRET;
        string2 = this.secret;
        bl = false;
        map.put(string, string2);
        map = result;
        string = HTTPS_REQUIRED;
        string2 = this.httpsRequired ? "1" : "0";
        bl = false;
        map.put(string, string2);
        map = result;
        string = CREATED;
        string2 = String.valueOf(this.created);
        bl = false;
        map.put(string, string2);
        map = result;
        string = EXPIRES_IN;
        string2 = String.valueOf(this.expirationDate);
        bl = false;
        map.put(string, string2);
        map = result;
        string = USER_ID;
        string2 = this.userId.toString();
        bl = false;
        map.put(string, string2);
        map = result;
        string = EMAIL;
        string2 = this.email;
        bl = false;
        map.put(string, string2);
        map = result;
        string = PHONE;
        string2 = this.phone;
        bl = false;
        map.put(string, string2);
        map = result;
        string = PHONE_ACCESS_KEY;
        string2 = this.phoneAccessKey;
        bl = false;
        map.put(string, string2);
        return result;
    }

    static {
        Object[] objectArray = new String[]{ACCESS_TOKEN, EXPIRES_IN, USER_ID, SECRET, HTTPS_REQUIRED, CREATED, VK_ACCESS_TOKEN_KEY, EMAIL, PHONE, PHONE_ACCESS_KEY};
        KEYS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vk/api/sdk/auth/VKAccessToken$Companion;", "", "()V", "ACCESS_TOKEN", "", "CREATED", "EMAIL", "EXPIRES_IN", "HTTPS_REQUIRED", "KEYS", "", "getKEYS", "()Ljava/util/List;", "PHONE", "PHONE_ACCESS_KEY", "SECRET", "USER_ID", "VK_ACCESS_TOKEN_KEY", "remove", "", "keyValueStorage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "restore", "Lcom/vk/api/sdk/auth/VKAccessToken;", "bundle", "Landroid/os/Bundle;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getKEYS() {
            return KEYS;
        }

        @Nullable
        public final VKAccessToken restore(@Nullable Bundle bundle) {
            Bundle bundle2;
            if (bundle == null) {
                return null;
            }
            Bundle bundle3 = bundle.getBundle(VKAccessToken.VK_ACCESS_TOKEN_KEY);
            if (bundle3 == null) {
                return null;
            }
            Bundle vkTokenBundle = bundle2 = bundle3;
            HashMap tokenParams = new HashMap();
            for (String key : vkTokenBundle.keySet()) {
                Map map = tokenParams;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                String string = key;
                String string2 = vkTokenBundle.getString(key);
                boolean bl = false;
                map.put(string, string2);
            }
            return new VKAccessToken(tokenParams);
        }

        public final void remove(@NotNull VKKeyValueStorage keyValueStorage) {
            Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
            Iterable $this$forEach$iv = this.getKEYS();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                keyValueStorage.remove(it);
            }
        }

        @Nullable
        public final VKAccessToken restore(@NotNull VKKeyValueStorage keyValueStorage) {
            Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
            HashMap tokenParams = new HashMap(this.getKEYS().size());
            for (String key : this.getKEYS()) {
                String string = keyValueStorage.get(key);
                if (string == null) continue;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                Map map = tokenParams;
                boolean bl4 = false;
                map.put(key, it);
            }
            return tokenParams.containsKey(VKAccessToken.ACCESS_TOKEN) && tokenParams.containsKey(VKAccessToken.USER_ID) ? new VKAccessToken(tokenParams) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

