/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.chain.RetryChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.utils.ExponentialBackoff;
import com.vk.api.sdk.utils.tmr.TooManyRequestLimitBackoff;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0014B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/vk/api/sdk/chain/TooManyRequestRetryChainCall;", "T", "Lcom/vk/api/sdk/chain/RetryChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "retryLimit", "", "backoff", "Lcom/vk/api/sdk/utils/tmr/TooManyRequestLimitBackoff;", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "(Lcom/vk/api/sdk/VKApiManager;ILcom/vk/api/sdk/utils/tmr/TooManyRequestLimitBackoff;Lcom/vk/api/sdk/chain/ChainCall;)V", "getBackoff", "()Lcom/vk/api/sdk/utils/tmr/TooManyRequestLimitBackoff;", "getChain", "()Lcom/vk/api/sdk/chain/ChainCall;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "Companion", "core_release"})
public final class TooManyRequestRetryChainCall<T>
extends RetryChainCall<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TooManyRequestLimitBackoff backoff;
    @NotNull
    private final ChainCall<T> chain;
    private static final long TIMEOUT = 1000L;
    private static final int MAX_CALLS_PER_SECOND = 3;
    private static final long MAX_LIMIT = 1000L;
    @NotNull
    private static final ExponentialBackoff errorBackoff = new ExponentialBackoff(1000L, 8000L, 1.2f, 0.0f, 0.0f, 24, null);

    public TooManyRequestRetryChainCall(@NotNull VKApiManager manager, int retryLimit, @NotNull TooManyRequestLimitBackoff backoff, @NotNull ChainCall<? extends T> chain) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        super(manager, retryLimit);
        this.backoff = backoff;
        this.chain = chain;
    }

    @NotNull
    public final TooManyRequestLimitBackoff getBackoff() {
        return this.backoff;
    }

    @NotNull
    public final ChainCall<T> getChain() {
        return this.chain;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int n = 0;
        int n2 = this.getRetryLimit();
        if (n <= n2) {
            while (true) {
                int i = n++;
                errorBackoff.waitIfNeeded();
                this.backoff.waitBeforeCall(3, 1000L);
                try {
                    T result = this.chain.call(args);
                    errorBackoff.reset();
                    return result;
                }
                catch (VKApiExecutionException ex) {
                    if (!ex.isTooManyRequestsError()) {
                        throw ex;
                    }
                    this.logDebug("Too many requests", ex);
                    errorBackoff.onError();
                    if (i != n2) continue;
                }
                break;
            }
        }
        throw new VKApiException("Can't handle too many requests due to retry limit! (retryLimit=" + this.getRetryLimit() + ')');
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vk/api/sdk/chain/TooManyRequestRetryChainCall$Companion;", "", "()V", "MAX_CALLS_PER_SECOND", "", "MAX_LIMIT", "", "TIMEOUT", "errorBackoff", "Lcom/vk/api/sdk/utils/ExponentialBackoff;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

