/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.VKApiValidationHandler;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.chain.RetryChainCall;
import com.vk.api.sdk.chain.ValidationHandlerChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJX\u0010\f\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001\"\u0004\b\u0002\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u0001H\r2)\u0010\u0011\u001a%\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\u0002\b\u0015H\u0004\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010!\u001a\u00020\u00142\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/vk/api/sdk/chain/ValidationHandlerChainCall;", "T", "Lcom/vk/api/sdk/chain/RetryChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "retryLimit", "", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "(Lcom/vk/api/sdk/VKApiManager;ILcom/vk/api/sdk/chain/ChainCall;)V", "getChain", "()Lcom/vk/api/sdk/chain/ChainCall;", "awaitValidation", "H", "extra", "", "handler", "handlerMethod", "Lkotlin/Function3;", "Lcom/vk/api/sdk/VKApiValidationHandler$Callback;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "handleCaptcha", "ex", "Lcom/vk/api/sdk/exceptions/VKApiExecutionException;", "handleException", "handleUserConfirmation", "handleValidation", "persistToken", "credentials", "Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "core_release"})
public final class ValidationHandlerChainCall<T>
extends RetryChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;

    public ValidationHandlerChainCall(@NotNull VKApiManager manager, int retryLimit, @NotNull ChainCall<? extends T> chain) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        super(manager, retryLimit);
        this.chain = chain;
    }

    @NotNull
    public final ChainCall<T> getChain() {
        return this.chain;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int n = 0;
        int n2 = this.getRetryLimit();
        if (n <= n2) {
            while (true) {
                int i = n++;
                try {
                    return this.chain.call(args);
                }
                catch (VKApiExecutionException ex) {
                    this.handleException(ex, args);
                    if (i != n2) continue;
                }
                break;
            }
        }
        throw new VKApiException("Can't confirm validation due to retry limit!");
    }

    private final void handleException(VKApiExecutionException ex, ChainArgs args) throws Exception {
        if (ex.isCaptchaError()) {
            this.handleCaptcha(ex, args);
        } else if (ex.isValidationRequired()) {
            this.handleValidation(ex);
        } else if (ex.isUserConfirmRequired()) {
            this.handleUserConfirmation(ex, args);
        } else {
            Unit unit;
            Unit unit2;
            VKApiValidationHandler vKApiValidationHandler = this.getManager().getValidationHandler$core_release();
            if (vKApiValidationHandler == null) {
                unit2 = null;
            } else {
                vKApiValidationHandler.tryToHandleException(ex, this.getManager());
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit == null) {
                throw ex;
            }
        }
    }

    private final void handleUserConfirmation(VKApiExecutionException ex, ChainArgs args) {
        Boolean confirmation2 = (Boolean)this.awaitValidation(ex.getUserConfirmText(), this.getManager().getValidationHandler$core_release(), handleUserConfirmation.confirmation.1.INSTANCE);
        Boolean bl = confirmation2;
        if (bl == null) {
            throw ex;
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            throw ex;
        }
        args.setUserConfirmed(confirmation2);
    }

    private final void handleValidation(VKApiExecutionException ex) {
        VKApiValidationHandler.Credentials credentials2 = (VKApiValidationHandler.Credentials)this.awaitValidation(ex.getValidationUrl(), this.getManager().getValidationHandler$core_release(), handleValidation.credentials.1.INSTANCE);
        this.persistToken(credentials2, ex);
    }

    protected final void persistToken(@Nullable VKApiValidationHandler.Credentials credentials2, @NotNull VKApiExecutionException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (!Intrinsics.areEqual((Object)credentials2, (Object)VKApiValidationHandler.Credentials.Companion.getEMPTY())) {
            VKApiValidationHandler.Credentials credentials3 = credentials2;
            if (credentials3 == null ? false : credentials3.isValid()) {
                VKApiManager vKApiManager = this.getManager();
                String string2 = credentials2.getToken();
                Intrinsics.checkNotNull((Object)string2);
                vKApiManager.setCredentials(string2, credentials2.getSecret());
            } else {
                throw ex;
            }
        }
    }

    private final void handleCaptcha(VKApiExecutionException ex, ChainArgs args) {
        String captcha2 = (String)this.awaitValidation(ex.getCaptchaImg(), this.getManager().getValidationHandler$core_release(), handleCaptcha.captcha.1.INSTANCE);
        String string2 = captcha2;
        if (string2 == null) {
            throw ex;
        }
        args.setCaptchaSid(ex.getCaptchaSid());
        args.setCaptchaKey(captcha2);
    }

    @Nullable
    protected final <T, H> T awaitValidation(@NotNull String extra, @Nullable H handler2, @NotNull Function3<? super H, ? super String, ? super VKApiValidationHandler.Callback<T>, Unit> handlerMethod) {
        Intrinsics.checkNotNullParameter((Object)extra, (String)"extra");
        Intrinsics.checkNotNullParameter(handlerMethod, (String)"handlerMethod");
        H h = handler2;
        if (h == null) {
            return null;
        }
        CountDownLatch latch = new CountDownLatch(1);
        VKApiValidationHandler.Callback callback = new VKApiValidationHandler.Callback(latch);
        handlerMethod.invoke(handler2, (Object)extra, callback);
        latch.await();
        return callback.getValue();
    }
}

