/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0016\u001a\u00020\u0005H\u0002J\u000e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/vk/api/sdk/utils/RateLimitTokenBackoff;", "", "store", "Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenStore;", "minBackoffTime", "", "maxBackoffTime", "factor", "", "timeProvider", "Lkotlin/Function0;", "(Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenStore;JJFLkotlin/jvm/functions/Function0;)V", "backoff", "", "operationKey", "", "calculate", "retry", "", "reset", "shouldWait", "", "time", "waitTime", "TokenMemStore", "TokenPrefStore", "TokenStore", "core_release"})
public final class RateLimitTokenBackoff {
    @NotNull
    private final TokenStore store;
    private final long minBackoffTime;
    private final long maxBackoffTime;
    private final float factor;
    @NotNull
    private final Function0<Long> timeProvider;

    public RateLimitTokenBackoff(@NotNull TokenStore store, long minBackoffTime, long maxBackoffTime, float factor, @NotNull Function0<Long> timeProvider) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        Intrinsics.checkNotNullParameter(timeProvider, (String)"timeProvider");
        this.store = store;
        this.minBackoffTime = minBackoffTime;
        this.maxBackoffTime = maxBackoffTime;
        this.factor = factor;
        this.timeProvider = timeProvider;
    }

    public /* synthetic */ RateLimitTokenBackoff(TokenStore tokenStore, long l, long l2, float f, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            l2 = l;
        }
        if ((n & 8) != 0) {
            f = 1.5f;
        }
        if ((n & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        this(tokenStore, l, l2, f, (Function0<Long>)function0);
    }

    public final boolean shouldWait(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        return this.waitTime(operationKey) > 0L;
    }

    public final long waitTime(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        if (!this.store.has(operationKey)) {
            return 0L;
        }
        Pair<Long, Integer> pair = this.store.restore(operationKey, Long.MAX_VALUE);
        long value2 = ((Number)pair.component1()).longValue();
        int count = ((Number)pair.component2()).intValue();
        long currTime = this.time();
        long elapsedTime = currTime - value2;
        long backoffTimeMs = this.calculate(count);
        if (elapsedTime < 0L) {
            return 0L;
        }
        if (elapsedTime >= backoffTimeMs) {
            return 0L;
        }
        return backoffTimeMs - elapsedTime;
    }

    public final void reset(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        if (!this.store.has(operationKey)) {
            return;
        }
        this.store.reset(operationKey);
    }

    public final void backoff(@NotNull String operationKey) {
        Intrinsics.checkNotNullParameter((Object)operationKey, (String)"operationKey");
        this.store.store(operationKey, this.time());
    }

    private final long time() {
        return ((Number)this.timeProvider.invoke()).longValue();
    }

    private final long calculate(int retry) {
        long acum = 0L;
        acum = this.minBackoffTime;
        boolean bl = false;
        int n = 0;
        n = 0;
        int n2 = retry;
        while (n < n2) {
            int it = n++;
            boolean bl2 = false;
            acum = (long)((float)acum * this.factor);
        }
        long l = acum;
        long l2 = this.maxBackoffTime;
        boolean bl3 = false;
        return Math.min(l, l2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nH&J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\nH&\u00a8\u0006\u000f"}, d2={"Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenStore;", "", "has", "", "token", "", "reset", "", "restore", "Lkotlin/Pair;", "", "", "default", "store", "value", "core_release"})
    public static interface TokenStore {
        public boolean has(@NotNull String var1);

        public void reset(@NotNull String var1);

        @NotNull
        public Pair<Long, Integer> restore(@NotNull String var1, long var2);

        public void store(@NotNull String var1, long var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016R#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenPrefStore;", "Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenStore;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "prefStorage", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "getPrefStorage", "()Landroid/content/SharedPreferences;", "prefStorage$delegate", "Lkotlin/Lazy;", "has", "", "token", "", "reset", "", "restore", "Lkotlin/Pair;", "", "", "default", "store", "value", "Companion", "core_release"})
    public static final class TokenPrefStore
    implements TokenStore {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Lazy prefStorage$delegate;
        @NotNull
        private static final String PREF_NAME = "rate_limit_backoff_storage";

        public TokenPrefStore(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.prefStorage$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SharedPreferences>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(0);
                }

                public final SharedPreferences invoke() {
                    return this.$context.getSharedPreferences("rate_limit_backoff_storage", 0);
                }
            }));
        }

        private final SharedPreferences getPrefStorage() {
            Lazy lazy = this.prefStorage$delegate;
            Object var2_2 = null;
            boolean bl = false;
            return (SharedPreferences)lazy.getValue();
        }

        @Override
        public boolean has(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return this.getPrefStorage().contains(token);
        }

        @Override
        public void reset(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.getPrefStorage().edit().remove(token).apply();
        }

        @Override
        @NotNull
        public Pair<Long, Integer> restore(@NotNull String token, long l) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return TuplesKt.to((Object)this.getPrefStorage().getLong(token, l), (Object)0);
        }

        @Override
        public void store(@NotNull String token, long value2) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.getPrefStorage().edit().putLong(token, value2).apply();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenPrefStore$Companion;", "", "()V", "PREF_NAME", "", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0007H\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenMemStore;", "Lcom/vk/api/sdk/utils/RateLimitTokenBackoff$TokenStore;", "()V", "obj", "", "storage", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "", "", "has", "", "token", "reset", "", "restore", "default", "store", "value", "core_release"})
    public static final class TokenMemStore
    implements TokenStore {
        @NotNull
        private final ConcurrentHashMap<String, Pair<Long, Integer>> storage = new ConcurrentHashMap();
        @NotNull
        private final Object obj = new Object();

        @Override
        public boolean has(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return this.storage.containsKey(token);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(@NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Object object = this.obj;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                boolean bl3 = false;
                Pair<Long, Integer> pair = this.storage.remove(token);
            }
        }

        @Override
        @NotNull
        public Pair<Long, Integer> restore(@NotNull String token, long l) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Pair pair = this.storage.get(token);
            return pair == null ? TuplesKt.to((Object)l, (Object)0) : pair;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void store(@NotNull String token, long value2) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Object object = this.obj;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (object) {
                int n;
                Integer n2;
                boolean bl3 = false;
                Object object2 = this.storage.get(token);
                int count = object2 == null ? 0 : ((n2 = (Integer)object2.getSecond()) == null ? 0 : (n = n2 + 1));
                object2 = this.storage;
                n2 = TuplesKt.to((Object)value2, (Object)count);
                n = 0;
                object2.put((String)token, (Integer)n2);
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

