/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import androidx.annotation.RequiresApi;
import com.vk.api.sdk.utils.ThreadLocalDelegate;
import com.vk.api.sdk.utils.ThreadLocalDelegateKt;
import com.vk.api.sdk.utils.VKUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007J)\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0007\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0007J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\rH\u0007J*\u0010 \u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\r2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\rH\u0007J\u0010\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020\r2\b\u0010)\u001a\u0004\u0018\u00010\rH\u0007J\u000e\u0010*\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006,"}, d2={"Lcom/vk/api/sdk/utils/VKUtils;", "", "()V", "clearAllCookies", "", "context", "Landroid/content/Context;", "density", "", "dp", "", "explodeQueryString", "", "", "queryString", "getCertificateFingerprint", "", "packageName", "(Landroid/content/Context;Ljava/lang/String;)[Ljava/lang/String;", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getDisplaySizePreV23", "display", "Landroid/view/Display;", "size", "Landroid/graphics/Point;", "getDisplaySizeV23", "getPhysicalDisplaySize", "height", "isAppEnabled", "", "isAppInstalled", "isIntentAvailable", "action", "data", "Landroid/net/Uri;", "allowedPackage", "toHex", "bytes", "", "toHumanReadableAscii", "string", "width", "MD5", "core_release"})
public final class VKUtils {
    @NotNull
    public static final VKUtils INSTANCE = new VKUtils();

    private VKUtils() {
    }

    @JvmStatic
    public static final boolean isAppInstalled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            context.getPackageManager().getPackageInfo(packageName, 1);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isAppEnabled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            bl = context.getPackageManager().getApplicationInfo((String)packageName, (int)0).enabled;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isIntentAvailable(@NotNull Context context, @NotNull String action, @Nullable Uri data, @NotNull String allowedPackage) {
        boolean bl;
        block4: {
            List list;
            List list2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)allowedPackage, (String)"allowedPackage");
            PackageManager packageManager = context.getPackageManager();
            List list3 = list2 = packageManager == null ? null : packageManager.queryIntentActivities(new Intent(action, data), 65536);
            if (list2 == null) {
                return false;
            }
            List resolveInfos = list = list2;
            Iterable $this$any$iv = resolveInfos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResolveInfo it = (ResolveInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.activityInfo.packageName, (Object)allowedPackage)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> explodeQueryString(@Nullable String queryString) {
        if (queryString == null) {
            return null;
        }
        String[] stringArray = new String[]{"&"};
        List keyValuePairs = StringsKt.split$default((CharSequence)queryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        HashMap parameters = new HashMap(keyValuePairs.size());
        for (String keyValueString : keyValuePairs) {
            Object object = new String[]{"="};
            List keyValueArray = StringsKt.split$default((CharSequence)keyValueString, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (keyValueArray.size() <= 1) continue;
            object = parameters;
            Object e = keyValueArray.get(0);
            Object e2 = keyValueArray.get(1);
            boolean bl = false;
            object.put(e, e2);
        }
        return parameters;
    }

    @JvmStatic
    @SuppressLint(value={"Assert"})
    @Nullable
    public static final String[] getCertificateFingerprint(@Nullable Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            if (context == null || context.getPackageManager() == null) {
                return null;
            }
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 64);
            if (info.signatures == null) {
                return null;
            }
            String[] result = new String[info.signatures.length];
            int i = 0;
            Signature[] signatureArray = info.signatures;
            Intrinsics.checkNotNullExpressionValue((Object)signatureArray, (String)"info.signatures");
            Object[] $this$forEach$iv = signatureArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Signature it = (Signature)element$iv;
                boolean bl = false;
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(it.toByteArray());
                int n = i;
                i = n + 1;
                byte[] byArray = md.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest()");
                result[n] = INSTANCE.toHex(byArray);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void clearAllCookies(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CookieManager cookieManager = CookieManager.getInstance();
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.removeAllCookies(null);
        } else {
            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)context);
            cookieSyncManager.startSync();
            cookieManager.removeAllCookie();
            cookieSyncManager.stopSync();
        }
    }

    private final String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%0" + (bytes.length << 1) + 'X';
        Object[] objectArray = new Object[]{bi};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    public final int dp(int dp) {
        return (int)Math.ceil((float)dp * this.density());
    }

    public final float density() {
        return this.getDisplayMetrics().density;
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getSystem().displayMetrics");
        return displayMetrics;
    }

    public final int height(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public final int width(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @NotNull
    public final Point getPhysicalDisplaySize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point size = new Point();
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 23) {
            this.getDisplaySizeV23(display, size);
        } else {
            this.getDisplaySizePreV23(display, size);
        }
        return size;
    }

    private final void getDisplaySizePreV23(Display display, Point size) {
        Display display2 = display;
        if (display2 != null) {
            display2.getRealSize(size);
        }
    }

    @RequiresApi(value=23)
    private final void getDisplaySizeV23(Display display, Point size) {
        int n;
        Display display2 = display;
        Display.Mode mode = display2 == null ? null : display2.getMode();
        display2 = mode;
        size.x = display2 == null ? 0 : (n = display2.getPhysicalWidth());
        display2 = mode;
        size.y = display2 == null ? 0 : (n = display2.getPhysicalHeight());
    }

    @JvmStatic
    @NotNull
    public static final String toHumanReadableAscii(@Nullable String string2) {
        int c;
        if (string2 == null) {
            return "";
        }
        for (int i = 0; i < string2.length(); i += Character.charCount(c)) {
            String string3 = string2;
            boolean bl = false;
            c = string3.codePointAt(i);
            boolean bl2 = 32 <= c ? c <= 126 : false;
            if (bl2) {
                continue;
            }
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, 0, i);
            while (i < string2.length()) {
                String string4 = string2;
                boolean bl3 = false;
                c = string4.codePointAt(i);
                buffer.writeUtf8CodePoint((32 <= c ? c <= 126 : false) ? c : 63);
                i += Character.charCount(c);
            }
            return buffer.readUtf8();
        }
        return string2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/vk/api/sdk/utils/VKUtils$MD5;", "", "()V", "hex", "", "tmpBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTmpBuilder", "()Ljava/lang/StringBuilder;", "tmpBuilder$delegate", "Lcom/vk/api/sdk/utils/ThreadLocalDelegate;", "convert", "", "h", "", "b", "", "core_release"})
    public static final class MD5 {
        @NotNull
        public static final MD5 INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final char[] hex;
        @NotNull
        private static final ThreadLocalDelegate tmpBuilder$delegate;

        private MD5() {
        }

        private final StringBuilder getTmpBuilder() {
            return (StringBuilder)tmpBuilder$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @JvmStatic
        @NotNull
        public static final String convert(@NotNull String h) {
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                String string2 = h;
                Object object = "UTF-8";
                boolean bl = false;
                Charset charset = Charset.forName((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
                object = charset;
                bl = false;
                byte[] byArray = string2.getBytes((Charset)object);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] md5 = md.digest(byArray);
                INSTANCE.getTmpBuilder().setLength(0);
                Intrinsics.checkNotNullExpressionValue((Object)md5, (String)"md5");
                MD5.hex(md5);
                string2 = INSTANCE.getTmpBuilder().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tmpBuilder.toString()");
                return string2;
            }
            catch (Exception exception) {
                return "";
            }
        }

        @JvmStatic
        private static final void hex(byte[] b) {
            for (byte aB : b) {
                INSTANCE.getTmpBuilder().append(hex[(aB & 0xF0) >> 4]);
                INSTANCE.getTmpBuilder().append(hex[aB & 0xF]);
            }
        }

        static {
            Object[] objectArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MD5.class, "tmpBuilder", "getTmpBuilder()Ljava/lang/StringBuilder;", 0)))};
            $$delegatedProperties = objectArray;
            INSTANCE = new MD5();
            objectArray = new char[16];
            objectArray[0] = (KProperty)48;
            objectArray[1] = (KProperty)49;
            objectArray[2] = (KProperty)50;
            objectArray[3] = (KProperty)51;
            objectArray[4] = (KProperty)52;
            objectArray[5] = (KProperty)53;
            objectArray[6] = (KProperty)54;
            objectArray[7] = (KProperty)55;
            objectArray[8] = (KProperty)56;
            objectArray[9] = (KProperty)57;
            objectArray[10] = (KProperty)97;
            objectArray[11] = (KProperty)98;
            objectArray[12] = (KProperty)99;
            objectArray[13] = (KProperty)100;
            objectArray[14] = (KProperty)101;
            objectArray[15] = (KProperty)102;
            hex = (char[])objectArray;
            tmpBuilder$delegate = ThreadLocalDelegateKt.threadLocal(tmpBuilder.2.INSTANCE);
        }
    }
}

