/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk;

import android.net.Uri;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001aB\u000f\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/vk/api/sdk/VKHttpPostCall;", "", "b", "Lcom/vk/api/sdk/VKHttpPostCall$Builder;", "(Lcom/vk/api/sdk/VKHttpPostCall$Builder;)V", "isAwaitNetwork", "", "()Z", "isMultipart", "parts", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "getParts", "()Ljava/util/Map;", "retryCount", "", "getRetryCount", "()I", "timeoutMs", "", "getTimeoutMs", "()J", "url", "getUrl", "()Ljava/lang/String;", "Builder", "core_release"})
public class VKHttpPostCall {
    @NotNull
    private final String url;
    private final boolean isMultipart;
    @NotNull
    private final Map<String, HttpMultipartEntry> parts;
    private final int retryCount;
    private final long timeoutMs;
    private final boolean isAwaitNetwork;

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final boolean isMultipart() {
        return this.isMultipart;
    }

    @NotNull
    public final Map<String, HttpMultipartEntry> getParts() {
        return this.parts;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final long getTimeoutMs() {
        return this.timeoutMs;
    }

    public final boolean isAwaitNetwork() {
        return this.isAwaitNetwork;
    }

    protected VKHttpPostCall(@NotNull Builder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (StringsKt.isBlank((CharSequence)b.getUrl())) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal url value: ", (Object)b.getUrl()));
        }
        if (b.getTimeoutMs() < 0L) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Illegal timeout value: ", (Object)b.getTimeoutMs()));
        }
        if (!b.isMultipart()) {
            boolean bl;
            block7: {
                Map<String, HttpMultipartEntry> $this$any$iv = b.getParts();
                boolean $i$f$any = false;
                if ($this$any$iv.isEmpty()) {
                    bl = false;
                } else {
                    Iterator<Map.Entry<String, HttpMultipartEntry>> iterator = $this$any$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, HttpMultipartEntry> element$iv;
                        Map.Entry<String, HttpMultipartEntry> it = element$iv = iterator.next();
                        boolean bl2 = false;
                        if (!(!(it.getValue() instanceof HttpMultipartEntry.Text))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new IllegalStateException("Non multipart calls should consist of text arguments only");
            }
        }
        this.url = b.getUrl();
        this.isMultipart = b.isMultipart();
        this.parts = b.getParts();
        this.retryCount = b.getRetryCount();
        this.timeoutMs = b.getTimeoutMs();
        this.isAwaitNetwork = b.isAwaitNetwork();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u0018\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0004H\u0016J\u001c\u0010\u000b\u001a\u00020\u00002\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0#H\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\u000eH\u0016J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\tH\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0006R6\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0003\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lcom/vk/api/sdk/VKHttpPostCall$Builder;", "", "()V", "<set-?>", "", "isAwaitNetwork", "()Z", "isMultipart", "", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "parts", "getParts", "()Ljava/util/Map;", "", "retryCount", "getRetryCount", "()I", "", "timeoutMs", "getTimeoutMs", "()J", "url", "getUrl", "()Ljava/lang/String;", "args", "key", "fileUri", "Landroid/net/Uri;", "fileName", "value", "awaitNetwork", "build", "Lcom/vk/api/sdk/VKHttpPostCall;", "multipart", "", "count", "timeout", "core_release"})
    public static class Builder {
        @NotNull
        private String url = "";
        private boolean isMultipart = true;
        @NotNull
        private Map<String, HttpMultipartEntry> parts = new HashMap();
        private int retryCount = Integer.MAX_VALUE;
        private long timeoutMs;
        private boolean isAwaitNetwork;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final boolean isMultipart() {
            return this.isMultipart;
        }

        @NotNull
        public final Map<String, HttpMultipartEntry> getParts() {
            return this.parts;
        }

        public final int getRetryCount() {
            return this.retryCount;
        }

        public final long getTimeoutMs() {
            return this.timeoutMs;
        }

        public final boolean isAwaitNetwork() {
            return this.isAwaitNetwork;
        }

        @NotNull
        public Builder url(@NotNull String url) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Builder $this$url_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$url_u24lambda_u2d0.url = url;
            return builder;
        }

        @NotNull
        public Builder multipart(boolean multipart) {
            Builder builder;
            Builder $this$multipart_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$multipart_u24lambda_u2d1.isMultipart = multipart;
            return builder;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull String value2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Builder $this$args_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            Map<String, HttpMultipartEntry> map = $this$args_u24lambda_u2d2.getParts();
            HttpMultipartEntry.Text text = new HttpMultipartEntry.Text(value2);
            map.put(key, text);
            return builder;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull Uri fileUri) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
            Builder $this$args_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            Map<String, HttpMultipartEntry> map = $this$args_u24lambda_u2d3.getParts();
            HttpMultipartEntry.File file = new HttpMultipartEntry.File(fileUri);
            map.put(key, file);
            return builder;
        }

        @NotNull
        public Builder args(@NotNull String key, @NotNull Uri fileUri, @NotNull String fileName) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Builder $this$args_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            Map<String, HttpMultipartEntry> map = $this$args_u24lambda_u2d4.getParts();
            HttpMultipartEntry.File file = new HttpMultipartEntry.File(fileUri, fileName);
            map.put(key, file);
            return builder;
        }

        @NotNull
        public Builder parts(@NotNull Map<String, ? extends HttpMultipartEntry> parts) {
            Builder builder;
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            Builder $this$parts_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$parts_u24lambda_u2d5.getParts().putAll(parts);
            return builder;
        }

        @NotNull
        public Builder retryCount(int count) {
            Builder builder;
            Builder $this$retryCount_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            $this$retryCount_u24lambda_u2d6.retryCount = count;
            return builder;
        }

        @NotNull
        public Builder timeout(long timeout) {
            Builder builder;
            Builder $this$timeout_u24lambda_u2d7 = builder = this;
            boolean bl = false;
            $this$timeout_u24lambda_u2d7.timeoutMs = timeout;
            return builder;
        }

        @NotNull
        public Builder awaitNetwork(boolean isAwaitNetwork) {
            Builder builder;
            Builder $this$awaitNetwork_u24lambda_u2d8 = builder = this;
            boolean bl = false;
            $this$awaitNetwork_u24lambda_u2d8.isAwaitNetwork = isAwaitNetwork;
            return builder;
        }

        @NotNull
        public VKHttpPostCall build() {
            return new VKHttpPostCall(this);
        }
    }
}

