/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.internal;

import android.os.Bundle;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKApiIllegalResponseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\fJ&\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00132\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0013J&\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0013\u00a8\u0006\u0019"}, d2={"Lcom/vk/api/sdk/internal/VKErrorUtils;", "", "()V", "executeErrorsSet", "", "", "json", "Lorg/json/JSONObject;", "hasExecuteError", "", "response", "ignoreErrors", "", "hasSimpleError", "parseExecuteError", "Lcom/vk/api/sdk/exceptions/VKApiException;", "errorsJson", "Lorg/json/JSONArray;", "method", "", "ignoredErrors", "parseSimpleError", "errorStr", "accessToken", "errorJson", "core_release"})
public final class VKErrorUtils {
    @NotNull
    public static final VKErrorUtils INSTANCE = new VKErrorUtils();

    private VKErrorUtils() {
    }

    public final boolean hasSimpleError(@NotNull JSONObject response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return response.has("error");
    }

    public final boolean hasExecuteError(@NotNull JSONObject response, @Nullable int[] ignoreErrors) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!response.has("execute_errors")) {
            bl = false;
        } else if (ignoreErrors == null) {
            bl = true;
        } else {
            Set<Integer> errors = this.executeErrorsSet(response);
            int[] $this$forEach$iv = ignoreErrors;
            boolean $i$f$forEach = false;
            for (int element$iv : $this$forEach$iv) {
                int it = element$iv;
                boolean bl2 = false;
                errors.remove(it);
            }
            bl = !((Collection)errors).isEmpty();
        }
        return bl;
    }

    private final Set<Integer> executeErrorsSet(JSONObject json) {
        HashSet<Integer> set = new HashSet<Integer>();
        JSONArray jaErrors = json.getJSONArray("execute_errors");
        int n = 0;
        int n2 = jaErrors.length();
        while (n < n2) {
            int i = n++;
            set.add(jaErrors.getJSONObject(i).getInt("error_code"));
        }
        return set;
    }

    @NotNull
    public final VKApiException parseSimpleError(@NotNull String errorStr, @Nullable String method, @Nullable String accessToken) {
        Intrinsics.checkNotNullParameter((Object)errorStr, (String)"errorStr");
        JSONObject jSONObject = new JSONObject(errorStr).optJSONObject("error");
        if (jSONObject == null) {
            jSONObject = new JSONObject(errorStr);
        }
        JSONObject errorJson = jSONObject;
        return this.parseSimpleError(errorJson, method, accessToken);
    }

    public static /* synthetic */ VKApiException parseSimpleError$default(VKErrorUtils vKErrorUtils, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = null;
        }
        if ((n & 4) != 0) {
            string4 = null;
        }
        return vKErrorUtils.parseSimpleError(string2, string3, string4);
    }

    @NotNull
    public final VKApiException parseSimpleError(@NotNull JSONObject errorJson, @Nullable String method, @Nullable String accessToken) {
        Intrinsics.checkNotNullParameter((Object)errorJson, (String)"errorJson");
        try {
            Bundle bundle;
            switch (errorJson.optInt("error_code")) {
                case 14: {
                    Bundle extra = new Bundle();
                    extra.putString("captcha_sid", errorJson.getString("captcha_sid"));
                    extra.putString("captcha_img", errorJson.getString("captcha_img"));
                    bundle = extra;
                    break;
                }
                case 17: {
                    Bundle extra = new Bundle();
                    extra.putString("validation_url", errorJson.getString("redirect_uri"));
                    bundle = extra;
                    break;
                }
                case 24: {
                    Bundle extra = new Bundle();
                    extra.putString("confirmation_text", errorJson.getString("confirmation_text"));
                    bundle = extra;
                    break;
                }
                case 5: {
                    JSONObject banInfo = errorJson.optJSONObject("ban_info");
                    if (banInfo != null) {
                        Bundle extra = new Bundle();
                        extra.putString("user_ban_info", banInfo.toString());
                        bundle = extra;
                        break;
                    }
                    bundle = null;
                    break;
                }
                case 3609: {
                    Bundle extra = new Bundle();
                    extra.putString("extend_hash", errorJson.optString("extend_hash", null));
                    bundle = extra;
                    break;
                }
                default: {
                    bundle = null;
                }
            }
            Bundle bundle2 = bundle;
            Bundle actualBundle = null;
            if (accessToken != null) {
                Bundle bundle3 = bundle2;
                if (bundle3 == null) {
                    bundle3 = new Bundle(1);
                }
                actualBundle = bundle3;
                actualBundle.putString("access_token", accessToken);
            } else {
                actualBundle = bundle2;
            }
            return VKApiExecutionException.Companion.parse(errorJson, method, actualBundle);
        }
        catch (Exception e) {
            String string2 = errorJson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"errorJson.toString()");
            return new VKApiIllegalResponseException(string2, e);
        }
    }

    public static /* synthetic */ VKApiException parseSimpleError$default(VKErrorUtils vKErrorUtils, JSONObject jSONObject, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        return vKErrorUtils.parseSimpleError(jSONObject, string2, string3);
    }

    @NotNull
    public final VKApiException parseExecuteError(@NotNull JSONObject response, @NotNull String method, @Nullable int[] ignoredErrors) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        JSONArray jSONArray = response.getJSONArray("execute_errors");
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"response.getJSONArray(VK\u2026des.PARAM_EXECUTE_ERRORS)");
        return this.parseExecuteError(jSONArray, method, ignoredErrors);
    }

    private final VKApiException parseExecuteError(JSONArray errorsJson, String method, int[] ignoredErrors) {
        try {
            ArrayList<VKApiException> nonCriticalErrors = new ArrayList<VKApiException>();
            int n = 0;
            int n2 = errorsJson.length();
            while (n < n2) {
                int i = n++;
                JSONObject jSONObject = errorsJson.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"errorsJson.getJSONObject(i)");
                VKApiException parsedError = VKErrorUtils.parseSimpleError$default(this, jSONObject, null, null, 6, null);
                if (!(parsedError instanceof VKApiExecutionException)) {
                    return parsedError;
                }
                switch (((VKApiExecutionException)parsedError).getCode()) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 9: 
                    case 10: 
                    case 14: 
                    case 17: 
                    case 24: 
                    case 25: {
                        return parsedError;
                    }
                }
                if (ignoredErrors != null && ArraysKt.contains((int[])ignoredErrors, (int)((VKApiExecutionException)parsedError).getCode())) continue;
                nonCriticalErrors.add(parsedError);
            }
            return new VKApiExecutionException(Integer.MIN_VALUE, method, false, "", null, nonCriticalErrors, null, null, 0, 448, null);
        }
        catch (JSONException e) {
            return new VKApiIllegalResponseException(e);
        }
    }
}

