/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import com.vk.api.sdk.exceptions.VKLocalIOException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody;", "Lokhttp3/RequestBody;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "lastPathSegment", "", "scheme", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "core_release"})
public final class FileFullRequestBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Uri uri;
    @NotNull
    private final String scheme;
    @NotNull
    private final String lastPathSegment;
    private static final int CHUNK = 8192;

    public FileFullRequestBody(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.context = context;
        this.uri = uri;
        CharSequence charSequence = this.uri.getScheme();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)this.uri.getLastPathSegment()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalArgumentException("Illegal fileUri value: '" + this.uri + '\'');
        }
        String string2 = this.uri.getScheme();
        Intrinsics.checkNotNull((Object)string2);
        charSequence = string2;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"uri.scheme!!");
        this.scheme = charSequence;
        String string3 = this.uri.getLastPathSegment();
        Intrinsics.checkNotNull((Object)string3);
        charSequence = string3;
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"uri.lastPathSegment!!");
        this.lastPathSegment = charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MediaType contentType() {
        String mimeType;
        block11: {
            mimeType = null;
            try {
                mimeType = URLConnection.guessContentTypeFromName(this.lastPathSegment);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mimeType == null) {
                try {
                    Cursor cursor;
                    String[] stringArray = new String[]{"mime_type"};
                    String[] projection = stringArray;
                    Cursor cursor2 = cursor = this.context.getContentResolver().query(this.uri, projection, null, null, null);
                    if (cursor2 == null) break block11;
                    Closeable closeable = (Closeable)cursor2;
                    Throwable throwable = null;
                    try {
                        Cursor it = (Cursor)closeable;
                        boolean bl = false;
                        mimeType = it.isNull(0) ? null : it.getString(0);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        String string2 = mimeType;
        MediaType mediaType = string2 == null ? null : MediaType.Companion.parse(string2);
        if (mediaType == null) {
            mediaType = MediaType.Companion.get("application/octet-stream");
        }
        return mediaType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long contentLength() throws IOException {
        AssetFileDescriptor fd = null;
        try {
            AssetFileDescriptor assetFileDescriptor = fd = this.context.getContentResolver().openAssetFileDescriptor(this.uri, "r");
            Long l = assetFileDescriptor == null ? null : Long.valueOf(assetFileDescriptor.getLength());
            if (l == null) {
                throw new FileNotFoundException(Intrinsics.stringPlus((String)"Cannot open uri: ", (Object)this.uri));
            }
            long l2 = l;
            return l2;
        }
        catch (FileNotFoundException ex) {
            throw new VKLocalIOException(ex);
        }
        finally {
            try {
                AssetFileDescriptor assetFileDescriptor;
                AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor = fd;
                if (assetFileDescriptor2 != null) {
                    assetFileDescriptor2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        AssetFileDescriptor fileDescriptor = null;
        OutputStream os = sink.outputStream();
        try {
            FileInputStream inputStream = null;
            try {
                fileDescriptor = this.context.getContentResolver().openAssetFileDescriptor(this.uri, "r");
                if (fileDescriptor == null) {
                    throw new FileNotFoundException(Intrinsics.stringPlus((String)"Cannot open uri: ", (Object)this.uri));
                }
                FileInputStream fileInputStream = fileDescriptor.createInputStream();
                Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"fileDescriptor.createInputStream()");
                inputStream = fileInputStream;
            }
            catch (IOException ex) {
                throw new VKLocalIOException(ex);
            }
            byte[] buffer = new byte[8192];
            int readCount = 0;
            while (inputStream.available() > 0) {
                try {
                    readCount = inputStream.read(buffer);
                }
                catch (IOException ex) {
                    throw new VKLocalIOException(ex);
                }
                if (readCount != -1) {
                    os.write(buffer, 0, readCount);
                    os.flush();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            try {
                AssetFileDescriptor assetFileDescriptor;
                AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor = fileDescriptor;
                if (assetFileDescriptor2 == null) {
                    throw throwable;
                }
                assetFileDescriptor2.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            AssetFileDescriptor assetFileDescriptor = fileDescriptor;
            assetFileDescriptor.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody$Companion;", "", "()V", "CHUNK", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

