/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import com.vk.api.sdk.VKApiConfig;
import com.vk.api.sdk.VKApiCredentials;
import com.vk.api.sdk.VKApiProgressListener;
import com.vk.api.sdk.VKHost;
import com.vk.api.sdk.VKOkHttpProvider;
import com.vk.api.sdk.exceptions.IgnoredAccessTokenException;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKInternalServerErrorException;
import com.vk.api.sdk.exceptions.VKLargeEntityException;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import com.vk.api.sdk.internal.QueryStringGenerator;
import com.vk.api.sdk.okhttp.FileFullRequestBody;
import com.vk.api.sdk.okhttp.LoggingInterceptor;
import com.vk.api.sdk.okhttp.LoggingPrefixer;
import com.vk.api.sdk.okhttp.OkHttpExecutorConfig;
import com.vk.api.sdk.okhttp.OkHttpMethodCall;
import com.vk.api.sdk.okhttp.OkHttpPostCall;
import com.vk.api.sdk.okhttp.ProgressRequestBody;
import com.vk.api.sdk.okhttp.RequestTag;
import com.vk.api.sdk.utils.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0002QRB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00062\b\u0010$\u001a\u0004\u0018\u00010\u0006H\u0004J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0010\u00102\u001a\u0002032\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u00102\u001a\u0002032\u0006\u0010&\u001a\u0002042\b\u00105\u001a\u0004\u0018\u000106J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0012\u0010;\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020'H\u0014J\u0012\u0010<\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020'H\u0014J\u0010\u0010=\u001a\u00020\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0018\u0010>\u001a\u00020?2\u0006\u0010&\u001a\u0002042\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u000208J\u0010\u0010E\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001b\u0010F\u001a\u00020\"2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0000\u00a2\u0006\u0002\bGJ\u0018\u0010F\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0006J\u0010\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\u001aH\u0002J\u0018\u0010J\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\u0006\u0010K\u001a\u00020\u0006H\u0004J \u0010L\u001a\u00020M*\u00020M2\u0012\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020P0OH\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\"\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\b\u00a8\u0006S"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "", "config", "Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "(Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;)V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "getConfig", "()Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "credentialsProvider", "Lkotlin/Lazy;", "Lcom/vk/api/sdk/VKApiCredentials;", "customEndpoint", "host", "getHost", "<set-?>", "ignoredAccessToken", "getIgnoredAccessToken", "lock", "okHttpProvider", "Lcom/vk/api/sdk/VKOkHttpProvider;", "getOkHttpProvider", "()Lcom/vk/api/sdk/VKOkHttpProvider;", "okHttpProvider$delegate", "Lkotlin/Lazy;", "secret", "getSecret", "checkAccessTokenIsIgnored", "", "method", "requestAccessToken", "checkNonSecretMethodCall", "call", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;", "convertFileNameToSafeValue", "fileName", "createLoggingInterceptor", "Lcom/vk/api/sdk/okhttp/LoggingInterceptor;", "filterCredentials", "", "logger", "Lcom/vk/api/sdk/utils/log/Logger;", "loggingPrefixer", "Lcom/vk/api/sdk/okhttp/LoggingPrefixer;", "execute", "Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;", "Lcom/vk/api/sdk/okhttp/OkHttpPostCall;", "progressListener", "Lcom/vk/api/sdk/VKApiProgressListener;", "executeRequest", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "getActualAccessToken", "getActualSecret", "ignoreAccessToken", "makePostCallRequestBuilder", "Lokhttp3/Request$Builder;", "requestBody", "Lokhttp3/RequestBody;", "readResponse", "Lorg/json/JSONObject;", "response", "resolveEndpoint", "setCredentials", "setCredentials$core_release", "updateClient", "provider", "validateQueryString", "paramsString", "updateWith", "Lokhttp3/MultipartBody$Builder;", "parts", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "Companion", "ExecutorResponse", "core_release"})
public class OkHttpExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpExecutorConfig config;
    @NotNull
    private final Context context;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy okHttpProvider$delegate;
    @NotNull
    private volatile Lazy<VKApiCredentials> credentialsProvider;
    @NotNull
    private final String customEndpoint;
    @Nullable
    private volatile String ignoredAccessToken;
    @NotNull
    public static final String MIME_APPLICATION = "application/x-www-form-urlencoded; charset=utf-8";
    @NotNull
    private static final String UTF_8 = "UTF-8";

    public OkHttpExecutor(@NotNull OkHttpExecutorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.context = this.config.getContext();
        this.lock = new Object();
        this.okHttpProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VKOkHttpProvider>(this){
            final /* synthetic */ OkHttpExecutor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VKOkHttpProvider invoke() {
                if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
                    throw new IllegalStateException("UI thread");
                }
                OkHttpExecutor.access$updateClient(this.this$0, this.this$0.getConfig().getOkHttpProvider());
                return this.this$0.getConfig().getOkHttpProvider();
            }
        }));
        this.credentialsProvider = VKApiCredentials.Companion.lazyFrom(this.config.getAccessToken(), this.config.getSecret());
        this.customEndpoint = this.config.getCustomEndpoint();
    }

    @NotNull
    protected final OkHttpExecutorConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    private final VKOkHttpProvider getOkHttpProvider() {
        Lazy lazy = this.okHttpProvider$delegate;
        return (VKOkHttpProvider)lazy.getValue();
    }

    @NotNull
    public final String getHost() {
        return (String)this.config.getHostProvider().invoke();
    }

    @NotNull
    public final String getAccessToken() {
        return ((VKApiCredentials)this.credentialsProvider.getValue()).getAccessToken();
    }

    @Nullable
    public final String getSecret() {
        return ((VKApiCredentials)this.credentialsProvider.getValue()).getSecret();
    }

    @Nullable
    public final String getIgnoredAccessToken() {
        return this.ignoredAccessToken;
    }

    public final void setCredentials(@NotNull String accessToken, @Nullable String secret) {
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        this.credentialsProvider = VKApiCredentials.Companion.lazyFrom(accessToken, secret);
    }

    public final void setCredentials$core_release(@NotNull Lazy<VKApiCredentials> credentialsProvider) {
        Intrinsics.checkNotNullParameter(credentialsProvider, (String)"credentialsProvider");
        this.credentialsProvider = credentialsProvider;
    }

    public final void ignoreAccessToken(@Nullable String accessToken) {
        this.ignoredAccessToken = accessToken;
    }

    @NotNull
    public ExecutorResponse execute(@NotNull OkHttpMethodCall call) throws InterruptedException, IOException, VKApiException {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String actualAccessToken = this.getActualAccessToken(call);
        this.checkAccessTokenIsIgnored(call.getMethod(), actualAccessToken);
        String actualSecret = this.getActualSecret(call);
        this.checkNonSecretMethodCall(call);
        String queryString = QueryStringGenerator.INSTANCE.buildSignedQueryStringForMethod(call.getMethod(), call.getArgs(), call.getVersion(), actualAccessToken, actualSecret, this.config.getAppId());
        RequestBody requestBody = RequestBody.Companion.create(this.validateQueryString(call, queryString), MediaType.Companion.parse(MIME_APPLICATION));
        String string2 = call.getRequestUrl();
        if (string2 == null) {
            string2 = this.getHost();
        }
        String reqHost = string2;
        RequestTag requestTag = call.getTag();
        Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(this.resolveEndpoint(reqHost) + '/' + call.getMethod()).cacheControl(CacheControl.FORCE_NETWORK).tag(Map.class, requestTag == null ? null : requestTag.toMap());
        Object object = call.getCustomTag();
        if (object != null) {
            Object customTag = object;
            boolean bl = false;
            requestBuilder.tag(customTag.getClass(), customTag);
        }
        Request request = requestBuilder.build();
        String executorAccessToken = this.getAccessToken();
        Response okHttpResponse = this.executeRequest(request);
        return new ExecutorResponse(this.readResponse(okHttpResponse), okHttpResponse.headers(), executorAccessToken);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutorResponse execute(@NotNull OkHttpPostCall call, @Nullable VKApiProgressListener progressListener) throws InterruptedException, IOException, VKApiException {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.isMultipart()) {
            requestBody = (RequestBody)this.updateWith(new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM), call.getParts()).build();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map $this$filterValues$iv;
            Map<String, HttpMultipartEntry> map = call.getParts();
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                HttpMultipartEntry it = (HttpMultipartEntry)entry$iv.getValue();
                boolean bl = false;
                if (!(it instanceof HttpMultipartEntry.Text)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)it.getKey();
                String value2 = ((HttpMultipartEntry.Text)it.getValue()).getTextValue();
                collection.add(key + '=' + URLEncoder.encode(value2, UTF_8));
            }
            String queryString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            requestBody = RequestBody.Companion.create(queryString, MediaType.Companion.get(MIME_APPLICATION));
        }
        RequestBody body = requestBody;
        ProgressRequestBody requestBody2 = new ProgressRequestBody(body, progressListener);
        Request request = this.makePostCallRequestBuilder(call, requestBody2).build();
        Response response = this.executeRequest(request);
        return new ExecutorResponse(this.readResponse(response), response.headers(), null, 4, null);
    }

    @NotNull
    protected Request.Builder makePostCallRequestBuilder(@NotNull OkHttpPostCall call, @NotNull RequestBody requestBody) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        return new Request.Builder().post(requestBody).url(call.getUrl()).cacheControl(CacheControl.FORCE_NETWORK);
    }

    @NotNull
    protected final String validateQueryString(@NotNull OkHttpMethodCall call, @NotNull String paramsString) throws VKApiException {
        Collection collection;
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)paramsString, (String)"paramsString");
        if (StringsKt.startsWith$default((String)call.getMethod(), (String)"execute.", (boolean)false, (int)2, null) && (uri = Uri.parse((String)("https://" + VKHost.getHost() + "/?" + paramsString))).getQueryParameters("method").contains("execute") && !((collection = (Collection)uri.getQueryParameters("code")) == null || collection.isEmpty())) {
            throw new VKApiExecutionException(15, call.getMethod(), false, "Hey dude don't execute your hacky code ;)", null, null, null, null, 0, 496, null);
        }
        return paramsString;
    }

    @NotNull
    public final Response executeRequest(@NotNull Request request) throws InterruptedException, IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getOkHttpProvider().getClient().newCall(request).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JSONObject readResponse(@NotNull Response response) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.code() == 413) {
            throw new VKLargeEntityException(response.message());
        }
        int n = response.code();
        boolean bl = 500 <= n ? n < 600 : false;
        if (bl) {
            String string2;
            int n2 = response.code();
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                string2 = "null";
            } else {
                Closeable closeable = (Closeable)responseBody;
                int n3 = n2;
                Throwable throwable = null;
                try {
                    Object it = (ResponseBody)closeable;
                    boolean bl2 = false;
                    it = it.string();
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Object object = it;
                n2 = n3;
                string2 = object;
                if (string2 == null) {
                    string2 = "null";
                }
            }
            String string3 = string2;
            int n4 = n2;
            throw new VKInternalServerErrorException(n4, string3);
        }
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            jSONObject = null;
        } else {
            InputStream inputStream = responseBody.byteStream();
            if (inputStream == null) {
                jSONObject = null;
            } else {
                InputStream inputStream2 = inputStream;
                boolean bl3 = false;
                jSONObject = this.getConfig().getResponseBodyJsonConverter().convertResponse(inputStream2, response.headers().get("content-type"), response.request().url().encodedPath());
            }
        }
        return jSONObject;
    }

    @Nullable
    protected String getActualAccessToken(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return this.getAccessToken();
    }

    @Nullable
    protected String getActualSecret(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return this.getSecret();
    }

    protected final void checkAccessTokenIsIgnored(@NotNull String method, @Nullable String requestAccessToken) throws IgnoredAccessTokenException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.ignoredAccessToken != null && requestAccessToken != null && Intrinsics.areEqual((Object)requestAccessToken, (Object)this.ignoredAccessToken)) {
            throw new IgnoredAccessTokenException(method);
        }
    }

    protected void checkNonSecretMethodCall(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    private final MultipartBody.Builder updateWith(MultipartBody.Builder $this$updateWith, Map<String, ? extends HttpMultipartEntry> parts) {
        for (Map.Entry<String, ? extends HttpMultipartEntry> entry : parts.entrySet()) {
            String key = entry.getKey();
            HttpMultipartEntry entry2 = entry.getValue();
            if (entry2 instanceof HttpMultipartEntry.Text) {
                $this$updateWith.addFormDataPart(key, ((HttpMultipartEntry.Text)entry2).getTextValue());
                continue;
            }
            if (!(entry2 instanceof HttpMultipartEntry.File)) continue;
            FileFullRequestBody partBody = new FileFullRequestBody(this.context, ((HttpMultipartEntry.File)entry2).getFileUri());
            String string2 = ((HttpMultipartEntry.File)entry2).getFileName();
            if (string2 == null) {
                string2 = "";
            }
            $this$updateWith.addFormDataPart(key, this.convertFileNameToSafeValue(string2), (RequestBody)partBody);
        }
        return $this$updateWith;
    }

    private final String resolveEndpoint(String host) {
        if (((CharSequence)this.customEndpoint).length() == 0 || Intrinsics.areEqual((Object)this.customEndpoint, (Object)VKApiConfig.Companion.getDEFAULT_API_ENDPOINT())) {
            return OkHttpExecutor.Companion.defaultApiEndpoint(host);
        }
        return this.customEndpoint;
    }

    private final void updateClient(VKOkHttpProvider provider) {
        provider.updateClient(new VKOkHttpProvider.BuilderUpdateFunction(this){
            final /* synthetic */ OkHttpExecutor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public OkHttpClient.Builder update(@NotNull OkHttpClient.Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (Logger.LogLevel.NONE != this.this$0.getConfig().getLogger().getLogLevel().getValue()) {
                    builder.addInterceptor((Interceptor)this.this$0.createLoggingInterceptor(this.this$0.getConfig().getLogFilterCredentials(), this.this$0.getConfig().getLogger(), this.this$0.getConfig().getLoggingPrefixer()));
                }
                return builder;
            }
        });
    }

    @NotNull
    protected LoggingInterceptor createLoggingInterceptor(boolean filterCredentials, @NotNull Logger logger, @NotNull LoggingPrefixer loggingPrefixer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)loggingPrefixer, (String)"loggingPrefixer");
        return new LoggingInterceptor(filterCredentials, logger, loggingPrefixer);
    }

    private final String convertFileNameToSafeValue(String fileName) {
        String string2 = URLEncoder.encode(StringsKt.replace$default((String)fileName, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(fileName.replace(\"\\\"\", \"\\\\\\\"\"), UTF_8)");
        return string2;
    }

    public static final /* synthetic */ void access$updateClient(OkHttpExecutor $this, VKOkHttpProvider provider) {
        $this.updateClient(provider);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;", "", "responseBodyJson", "Lorg/json/JSONObject;", "headers", "Lokhttp3/Headers;", "executorRequestAccessToken", "", "(Lorg/json/JSONObject;Lokhttp3/Headers;Ljava/lang/String;)V", "getExecutorRequestAccessToken", "()Ljava/lang/String;", "getHeaders", "()Lokhttp3/Headers;", "getResponseBodyJson", "()Lorg/json/JSONObject;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core_release"})
    public static final class ExecutorResponse {
        @Nullable
        private final JSONObject responseBodyJson;
        @NotNull
        private final Headers headers;
        @Nullable
        private final String executorRequestAccessToken;

        public ExecutorResponse(@Nullable JSONObject responseBodyJson, @NotNull Headers headers, @Nullable String executorRequestAccessToken) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            this.responseBodyJson = responseBodyJson;
            this.headers = headers;
            this.executorRequestAccessToken = executorRequestAccessToken;
        }

        public /* synthetic */ ExecutorResponse(JSONObject jSONObject, Headers headers, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(jSONObject, headers, string2);
        }

        @Nullable
        public final JSONObject getResponseBodyJson() {
            return this.responseBodyJson;
        }

        @NotNull
        public final Headers getHeaders() {
            return this.headers;
        }

        @Nullable
        public final String getExecutorRequestAccessToken() {
            return this.executorRequestAccessToken;
        }

        @Nullable
        public final JSONObject component1() {
            return this.responseBodyJson;
        }

        @NotNull
        public final Headers component2() {
            return this.headers;
        }

        @Nullable
        public final String component3() {
            return this.executorRequestAccessToken;
        }

        @NotNull
        public final ExecutorResponse copy(@Nullable JSONObject responseBodyJson, @NotNull Headers headers, @Nullable String executorRequestAccessToken) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            return new ExecutorResponse(responseBodyJson, headers, executorRequestAccessToken);
        }

        public static /* synthetic */ ExecutorResponse copy$default(ExecutorResponse executorResponse, JSONObject jSONObject, Headers headers, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                jSONObject = executorResponse.responseBodyJson;
            }
            if ((n & 2) != 0) {
                headers = executorResponse.headers;
            }
            if ((n & 4) != 0) {
                string2 = executorResponse.executorRequestAccessToken;
            }
            return executorResponse.copy(jSONObject, headers, string2);
        }

        @NotNull
        public String toString() {
            return "ExecutorResponse(responseBodyJson=" + this.responseBodyJson + ", headers=" + this.headers + ", executorRequestAccessToken=" + this.executorRequestAccessToken + ')';
        }

        public int hashCode() {
            int result = this.responseBodyJson == null ? 0 : this.responseBodyJson.hashCode();
            result = result * 31 + this.headers.hashCode();
            result = result * 31 + (this.executorRequestAccessToken == null ? 0 : this.executorRequestAccessToken.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutorResponse)) {
                return false;
            }
            ExecutorResponse executorResponse = (ExecutorResponse)other;
            if (!Intrinsics.areEqual((Object)this.responseBodyJson, (Object)executorResponse.responseBodyJson)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headers, (Object)executorResponse.headers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.executorRequestAccessToken, (Object)executorResponse.executorRequestAccessToken);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor$Companion;", "", "()V", "MIME_APPLICATION", "", "UTF_8", "defaultApiEndpoint", "host", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String defaultApiEndpoint(String host) {
            return "https://" + host + "/method";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

