/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import com.vk.api.sdk.utils.ApiMethodPriorityBackoff;
import com.vk.api.sdk.utils.log.Logger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\b\u0010\u0018\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0004H\u0016J\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0004H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/vk/api/sdk/utils/StartUpMethodPriorityBackoffBaseImpl;", "Lcom/vk/api/sdk/utils/ApiMethodPriorityBackoff;", "startUpPriorityMethods", "", "", "exceptionMethods", "logger", "Lcom/vk/api/sdk/utils/log/Logger;", "(Ljava/util/Collection;Ljava/util/Collection;Lcom/vk/api/sdk/utils/log/Logger;)V", "locks", "", "", "Ljava/util/concurrent/locks/Condition;", "operationsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "startUpMethodsQueue", "Ljava/util/concurrent/CopyOnWriteArrayList;", "clear", "", "isActive", "", "newId", "notifyAwaiters", "methodName", "notifyLocks", "processMethod", "clientId", "shouldWait", "debug", "msg", "Companion", "core_release"})
public final class StartUpMethodPriorityBackoffBaseImpl
implements ApiMethodPriorityBackoff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<String> exceptionMethods;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, Condition> locks;
    @NotNull
    private final ReentrantLock operationsLock;
    @NotNull
    private final CopyOnWriteArrayList<String> startUpMethodsQueue;
    public static final long METHOD_WAIT_TIMEOUT = 500L;
    @NotNull
    private static final AtomicInteger idGenerator = new AtomicInteger();

    /*
     * WARNING - void declaration
     */
    public StartUpMethodPriorityBackoffBaseImpl(@NotNull Collection<String> startUpPriorityMethods, @NotNull Collection<String> exceptionMethods, @NotNull Logger logger) {
        void $this$startUpMethodsQueue_u24lambda_u2d0;
        CopyOnWriteArrayList copyOnWriteArrayList;
        Intrinsics.checkNotNullParameter(startUpPriorityMethods, (String)"startUpPriorityMethods");
        Intrinsics.checkNotNullParameter(exceptionMethods, (String)"exceptionMethods");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.exceptionMethods = exceptionMethods;
        this.logger = logger;
        this.locks = new LinkedHashMap();
        this.operationsLock = new ReentrantLock();
        CopyOnWriteArrayList copyOnWriteArrayList2 = copyOnWriteArrayList = new CopyOnWriteArrayList();
        StartUpMethodPriorityBackoffBaseImpl startUpMethodPriorityBackoffBaseImpl = this;
        boolean bl = false;
        $this$startUpMethodsQueue_u24lambda_u2d0.addAll(startUpPriorityMethods);
        startUpMethodPriorityBackoffBaseImpl.startUpMethodsQueue = copyOnWriteArrayList;
    }

    @Override
    public boolean isActive() {
        return !((Collection)this.startUpMethodsQueue).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newId() {
        int newId = idGenerator.incrementAndGet();
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean bl = false;
            Map<Integer, Condition> map = this.locks;
            Integer n = newId;
            Condition condition = this.operationsLock.newCondition();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"operationsLock.newCondition()");
            map.put(n, condition);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldWait(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean wait;
            boolean bl = false;
            if (this.exceptionMethods.contains(methodName)) {
                this.notifyAwaiters(methodName);
                boolean bl2 = false;
                return bl2;
            }
            boolean bl3 = wait = !((Collection)this.startUpMethodsQueue).isEmpty() && !this.startUpMethodsQueue.contains(methodName);
            if (!wait) {
                this.notifyAwaiters(methodName);
            }
            boolean bl4 = wait;
            return bl4;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMethod(int clientId, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            Condition condition;
            boolean bl = false;
            if (this.locks.get(clientId) == null) {
                return;
            }
            Condition condition2 = condition;
            if (this.shouldWait(methodName)) {
                this.debug(this.logger, "should wait for " + methodName + " queue.size:" + this.startUpMethodsQueue.size());
                condition2.await(500L, TimeUnit.MILLISECONDS);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean bl = false;
            this.debug(this.logger, "clear startup method queue");
            this.startUpMethodsQueue.clear();
            this.notifyLocks();
            this.locks.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void notifyLocks() {
        Iterable $this$forEach$iv = this.locks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Condition lock = (Condition)element$iv;
            boolean bl = false;
            lock.signalAll();
        }
    }

    private final void notifyAwaiters(String methodName) {
        this.debug(this.logger, Intrinsics.stringPlus((String)"notifyMethodCall:", (Object)methodName));
        if (this.startUpMethodsQueue.isEmpty()) {
            this.notifyLocks();
            return;
        }
        if (this.startUpMethodsQueue.contains(methodName)) {
            this.startUpMethodsQueue.remove(methodName);
            this.debug(this.logger, Intrinsics.stringPlus((String)"remove method from name ", (Object)methodName));
            this.notifyLocks();
        }
    }

    private final void debug(Logger $this$debug, String msg) {
        Logger.DefaultImpls.log$default(this.logger, Logger.LogLevel.DEBUG, Intrinsics.stringPlus((String)"StartUpMethodPriorityBackoffBaseImpl:", (Object)msg), null, 4, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vk/api/sdk/utils/StartUpMethodPriorityBackoffBaseImpl$Companion;", "", "()V", "METHOD_WAIT_TIMEOUT", "", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

