/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils.tmr;

import android.os.SystemClock;
import com.vk.api.sdk.utils.tmr.TooManyRequestLimitBackoff;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vk/api/sdk/utils/tmr/TooManyRequestBackoffGlobal;", "Lcom/vk/api/sdk/utils/tmr/TooManyRequestLimitBackoff;", "()V", "lastTimestamps", "Ljava/util/ArrayDeque;", "", "fillIfNeeded", "", "maxRequest", "", "waitBeforeCall", "maxRetryCount", "maxRetryTime", "core_release"})
public final class TooManyRequestBackoffGlobal
implements TooManyRequestLimitBackoff {
    @NotNull
    public static final TooManyRequestBackoffGlobal INSTANCE = new TooManyRequestBackoffGlobal();
    @NotNull
    private static final ArrayDeque<Long> lastTimestamps = new ArrayDeque();

    private TooManyRequestBackoffGlobal() {
    }

    @Override
    public synchronized void waitBeforeCall(int maxRetryCount, long maxRetryTime) {
        this.fillIfNeeded(maxRetryCount);
        long currentTimestamp = SystemClock.elapsedRealtime();
        lastTimestamps.addLast(currentTimestamp);
        Long firstTimestamp = lastTimestamps.removeFirst();
        Intrinsics.checkNotNullExpressionValue((Object)firstTimestamp, (String)"firstTimestamp");
        long waitFor = maxRetryTime - (currentTimestamp - firstTimestamp);
        if (waitFor > 0L) {
            Thread.sleep(waitFor);
        }
    }

    private final synchronized void fillIfNeeded(int maxRequest) {
        if (maxRequest == lastTimestamps.size()) {
            return;
        }
        if (maxRequest > lastTimestamps.size()) {
            int diff = maxRequest - lastTimestamps.size();
            int n = 0;
            while (n < diff) {
                int n2;
                int it = n2 = n++;
                boolean bl = false;
                lastTimestamps.addFirst(0L);
            }
        } else {
            int diff = lastTimestamps.size() - maxRequest;
            int n = 0;
            while (n < diff) {
                int n3;
                int it = n3 = n++;
                boolean bl = false;
                lastTimestamps.removeFirst();
            }
        }
    }
}

