/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk;

import android.content.Context;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.VKApiValidationHandler;
import com.vk.api.sdk.VKCaptchaHandlerDefaultImp;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.ui.VKConfirmationActivity;
import com.vk.api.sdk.ui.VKWebViewAuthActivity;
import com.vk.api.sdk.utils.VKValidationLocker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00130\fH\u0016J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00160\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lcom/vk/api/sdk/VKDefaultValidationHandler;", "Lcom/vk/api/sdk/VKApiValidationHandler;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "captchaHandler", "Lcom/vk/api/sdk/VKCaptchaHandlerDefaultImp;", "getContext", "()Landroid/content/Context;", "checkCaptchaActivity", "", "cb", "Lcom/vk/api/sdk/VKApiValidationHandler$Callback;", "", "handleCaptcha", "captcha", "Lcom/vk/api/sdk/VKApiValidationHandler$Captcha;", "handleConfirm", "confirmationText", "", "handleValidation", "validationUrl", "Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "core_release"})
public class VKDefaultValidationHandler
implements VKApiValidationHandler {
    @NotNull
    private final Context context;
    @NotNull
    private final VKCaptchaHandlerDefaultImp captchaHandler;

    public VKDefaultValidationHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.captchaHandler = new VKCaptchaHandlerDefaultImp();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void handleCaptcha(@NotNull VKApiValidationHandler.Captcha captcha, @NotNull VKApiValidationHandler.Callback<String> cb) {
        Intrinsics.checkNotNullParameter((Object)captcha, (String)"captcha");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        this.captchaHandler.showCaptcha(this.context, captcha);
        VKValidationLocker.INSTANCE.await();
        this.checkCaptchaActivity(cb);
    }

    private final void checkCaptchaActivity(VKApiValidationHandler.Callback<String> cb) {
        if (this.captchaHandler.getLastKey() != null) {
            String string2 = this.captchaHandler.getLastKey();
            Intrinsics.checkNotNull((Object)string2);
            cb.submit(string2);
        } else {
            cb.cancel();
        }
    }

    @Override
    public void handleConfirm(@NotNull String confirmationText, @NotNull VKApiValidationHandler.Callback<Boolean> cb) {
        Intrinsics.checkNotNullParameter((Object)confirmationText, (String)"confirmationText");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        VKConfirmationActivity.Companion.setResult(false);
        VKConfirmationActivity.Companion.start(this.context, confirmationText);
        VKValidationLocker.INSTANCE.await();
        cb.submit(VKConfirmationActivity.Companion.getResult());
        VKConfirmationActivity.Companion.setResult(false);
    }

    @Override
    public void handleValidation(@NotNull String validationUrl, @NotNull VKApiValidationHandler.Callback<VKApiValidationHandler.Credentials> cb) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)validationUrl, (String)"validationUrl");
        Intrinsics.checkNotNullParameter(cb, (String)"cb");
        VKWebViewAuthActivity.Companion.setValidationResult(null);
        VKWebViewAuthActivity.Companion.startForValidation(this.context, validationUrl);
        VKValidationLocker.INSTANCE.await();
        VKApiValidationHandler.Credentials credentials2 = VKWebViewAuthActivity.Companion.getValidationResult();
        if (credentials2 != null) {
            VKApiValidationHandler.Credentials it = credentials2;
            boolean bl = false;
            cb.submit(it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            VKDefaultValidationHandler $this$handleValidation_u24lambda_u241 = this;
            boolean bl = false;
            cb.cancel();
        }
        VKWebViewAuthActivity.Companion.setValidationResult(null);
    }

    @Override
    public void tryToHandleException(@NotNull VKApiExecutionException ex, @NotNull VKApiManager apiManager) throws VKApiExecutionException {
        VKApiValidationHandler.DefaultImpls.tryToHandleException(this, ex, apiManager);
    }

    @Override
    public void handleCaptchaSolved() {
        VKApiValidationHandler.DefaultImpls.handleCaptchaSolved(this);
    }
}

