/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.os.Bundle;
import com.vk.api.sdk.VKKeyValueStorage;
import com.vk.dto.common.id.UserId;
import com.vk.dto.common.id.UserIdKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'J\u0016\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\rH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u001b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Lcom/vk/api/sdk/auth/VKAccessToken;", "", "userId", "Lcom/vk/dto/common/id/UserId;", "accessToken", "", "secret", "expiresInSec", "", "createdMs", "", "(Lcom/vk/dto/common/id/UserId;Ljava/lang/String;Ljava/lang/String;IJ)V", "params", "", "(Ljava/util/Map;)V", "getAccessToken", "()Ljava/lang/String;", "getCreatedMs", "()J", "email", "getEmail", "getExpiresInSec", "()I", "httpsRequired", "", "isValid", "()Z", "phone", "getPhone", "phoneAccessKey", "getPhoneAccessKey", "getSecret", "getUserId", "()Lcom/vk/dto/common/id/UserId;", "save", "", "bundle", "Landroid/os/Bundle;", "storage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "toMap", "Companion", "core_release"})
public final class VKAccessToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserId userId;
    @NotNull
    private final String accessToken;
    @Nullable
    private final String secret;
    private final long createdMs;
    @Nullable
    private final String email;
    @Nullable
    private final String phone;
    @Nullable
    private final String phoneAccessKey;
    private final int expiresInSec;
    private final boolean httpsRequired;
    @NotNull
    private static final String ACCESS_TOKEN = "access_token";
    @NotNull
    private static final String EXPIRES_IN = "expires_in";
    @NotNull
    private static final String USER_ID = "user_id";
    @NotNull
    private static final String SECRET = "secret";
    @NotNull
    private static final String HTTPS_REQUIRED = "https_required";
    @NotNull
    private static final String CREATED = "created";
    @NotNull
    private static final String VK_ACCESS_TOKEN_KEY = "vk_access_token";
    @NotNull
    private static final String EMAIL = "email";
    @NotNull
    private static final String PHONE = "phone";
    @NotNull
    private static final String PHONE_ACCESS_KEY = "phone_access_key";
    @NotNull
    private static final List<String> KEYS;

    public VKAccessToken(@NotNull Map<String, String> params) {
        int n;
        long l;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        String string2 = params.get(USER_ID);
        Object object = string2 != null ? UserIdKt.toUserId((long)Long.parseLong(string2)) : null;
        Intrinsics.checkNotNull((Object)object);
        this.userId = object;
        String string3 = params.get(ACCESS_TOKEN);
        Intrinsics.checkNotNull((Object)string3);
        this.accessToken = string3;
        this.secret = params.get(SECRET);
        this.httpsRequired = Intrinsics.areEqual((Object)"1", (Object)params.get(HTTPS_REQUIRED));
        if (params.containsKey(CREATED)) {
            String string4 = params.get(CREATED);
            Intrinsics.checkNotNull((Object)string4);
            l = Long.parseLong(string4);
        } else {
            l = this.createdMs = System.currentTimeMillis();
        }
        if (params.containsKey(EXPIRES_IN)) {
            String string5 = params.get(EXPIRES_IN);
            Intrinsics.checkNotNull((Object)string5);
            n = Integer.parseInt(string5);
        } else {
            n = -1;
        }
        this.expiresInSec = n;
        this.email = params.containsKey(EMAIL) ? params.get(EMAIL) : null;
        this.phone = params.containsKey(PHONE) ? params.get(PHONE) : null;
        this.phoneAccessKey = params.containsKey(PHONE_ACCESS_KEY) ? params.get(PHONE_ACCESS_KEY) : null;
    }

    public VKAccessToken(@NotNull UserId userId, @NotNull String accessToken, @Nullable String secret, int expiresInSec, long createdMs) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)USER_ID, (Object)userId.toString()), TuplesKt.to((Object)ACCESS_TOKEN, (Object)accessToken), TuplesKt.to((Object)SECRET, (Object)secret), TuplesKt.to((Object)EXPIRES_IN, (Object)String.valueOf(expiresInSec)), TuplesKt.to((Object)CREATED, (Object)String.valueOf(createdMs)), TuplesKt.to((Object)HTTPS_REQUIRED, (Object)"1")};
        this(MapsKt.mapOf((Pair[])pairArray));
    }

    @NotNull
    public final UserId getUserId() {
        return this.userId;
    }

    @NotNull
    public final String getAccessToken() {
        return this.accessToken;
    }

    @Nullable
    public final String getSecret() {
        return this.secret;
    }

    public final long getCreatedMs() {
        return this.createdMs;
    }

    @Nullable
    public final String getEmail() {
        return this.email;
    }

    @Nullable
    public final String getPhone() {
        return this.phone;
    }

    @Nullable
    public final String getPhoneAccessKey() {
        return this.phoneAccessKey;
    }

    public final int getExpiresInSec() {
        return this.expiresInSec;
    }

    public final boolean isValid() {
        return this.expiresInSec <= 0 || this.createdMs + (long)(this.expiresInSec * 1000) > System.currentTimeMillis();
    }

    public final void save(@NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Bundle vkTokenBundle = new Bundle();
        Map<String, String> tokenParams = this.toMap();
        for (Map.Entry<String, String> entry : tokenParams.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            vkTokenBundle.putString(key, value2);
        }
        bundle.putBundle(VK_ACCESS_TOKEN_KEY, vkTokenBundle);
    }

    public final void save(@NotNull VKKeyValueStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Map<String, String> tokenParams = this.toMap();
        for (Map.Entry<String, String> entry : tokenParams.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            storage.putOrRemove(key, value2);
        }
    }

    private final Map<String, String> toMap() {
        HashMap result = new HashMap();
        ((Map)result).put(ACCESS_TOKEN, this.accessToken);
        ((Map)result).put(SECRET, this.secret);
        ((Map)result).put(HTTPS_REQUIRED, this.httpsRequired ? "1" : "0");
        ((Map)result).put(CREATED, String.valueOf(this.createdMs));
        ((Map)result).put(EXPIRES_IN, String.valueOf(this.expiresInSec));
        ((Map)result).put(USER_ID, this.userId.toString());
        ((Map)result).put(EMAIL, this.email);
        ((Map)result).put(PHONE, this.phone);
        ((Map)result).put(PHONE_ACCESS_KEY, this.phoneAccessKey);
        return result;
    }

    static {
        Object[] objectArray = new String[]{ACCESS_TOKEN, EXPIRES_IN, USER_ID, SECRET, HTTPS_REQUIRED, CREATED, VK_ACCESS_TOKEN_KEY, EMAIL, PHONE, PHONE_ACCESS_KEY};
        KEYS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vk/api/sdk/auth/VKAccessToken$Companion;", "", "()V", "ACCESS_TOKEN", "", "CREATED", "EMAIL", "EXPIRES_IN", "HTTPS_REQUIRED", "KEYS", "", "getKEYS", "()Ljava/util/List;", "PHONE", "PHONE_ACCESS_KEY", "SECRET", "USER_ID", "VK_ACCESS_TOKEN_KEY", "remove", "", "keyValueStorage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "restore", "Lcom/vk/api/sdk/auth/VKAccessToken;", "bundle", "Landroid/os/Bundle;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nVKAccessToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VKAccessToken.kt\ncom/vk/api/sdk/auth/VKAccessToken$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,161:1\n1855#2,2:162\n*S KotlinDebug\n*F\n+ 1 VKAccessToken.kt\ncom/vk/api/sdk/auth/VKAccessToken$Companion\n*L\n144#1:162,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getKEYS() {
            return KEYS;
        }

        @Nullable
        public final VKAccessToken restore(@Nullable Bundle bundle) {
            if (bundle == null) {
                return null;
            }
            Bundle bundle2 = bundle.getBundle(VKAccessToken.VK_ACCESS_TOKEN_KEY);
            if (bundle2 == null) {
                return null;
            }
            Bundle vkTokenBundle = bundle2;
            HashMap tokenParams = new HashMap();
            for (String key : vkTokenBundle.keySet()) {
                Map map = tokenParams;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                map.put(key, vkTokenBundle.getString(key));
            }
            return new VKAccessToken(tokenParams);
        }

        public final void remove(@NotNull VKKeyValueStorage keyValueStorage) {
            Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
            Iterable $this$forEach$iv = this.getKEYS();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                keyValueStorage.remove(it);
            }
        }

        @Nullable
        public final VKAccessToken restore(@NotNull VKKeyValueStorage keyValueStorage) {
            Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
            HashMap tokenParams = new HashMap(this.getKEYS().size());
            for (String key : this.getKEYS()) {
                String it;
                if (keyValueStorage.get(key) == null) continue;
                boolean bl = false;
                ((Map)tokenParams).put(key, it);
            }
            return tokenParams.containsKey(VKAccessToken.ACCESS_TOKEN) && tokenParams.containsKey(VKAccessToken.USER_ID) ? new VKAccessToken(tokenParams) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

