/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.vk.api.sdk.R;
import com.vk.api.sdk.VK;
import com.vk.api.sdk.VKApiCredentials;
import com.vk.api.sdk.VKKeyValueStorage;
import com.vk.api.sdk.auth.VKAccessToken;
import com.vk.api.sdk.auth.VKAuthCallback;
import com.vk.api.sdk.auth.VKAuthParams;
import com.vk.api.sdk.auth.VKAuthenticationResult;
import com.vk.api.sdk.exceptions.VKAuthException;
import com.vk.api.sdk.extensions.ContextExtKt;
import com.vk.api.sdk.utils.VKUtils;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J8\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eJ\u0010\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager;", "", "keyValueStorage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "(Lcom/vk/api/sdk/VKKeyValueStorage;)V", "clearAccessToken", "", "createVKClientAuthIntent", "Landroid/content/Intent;", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "getCurrentToken", "Lcom/vk/api/sdk/auth/VKAccessToken;", "isLoggedIn", "", "obtainExceptionFromIntent", "Lcom/vk/api/sdk/exceptions/VKAuthException;", "intent", "onActivityResult", "context", "Landroid/content/Context;", "requestCode", "", "resultCode", "data", "callback", "Lcom/vk/api/sdk/auth/VKAuthCallback;", "showErrorToast", "processResult", "Lcom/vk/api/sdk/auth/VKAuthenticationResult;", "result", "storeLoginResult", "Lcom/vk/api/sdk/auth/VKAuthenticationResult$Success;", "Companion", "core_release"})
public final class VKAuthManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VKKeyValueStorage keyValueStorage;
    @NotNull
    public static final String VK_APP_PACKAGE_ID = "com.vkontakte.android";
    @NotNull
    public static final String VK_APP_AUTH_ACTION = "com.vkontakte.android.action.SDK_AUTH";
    @NotNull
    public static final String VK_EXTRA_TOKEN_DATA = "extra-token-data";
    @NotNull
    public static final String VK_AUTH_ERROR = "error";
    private static final int VK_APP_AUTH_CODE = 282;

    public VKAuthManager(@NotNull VKKeyValueStorage keyValueStorage) {
        Intrinsics.checkNotNullParameter((Object)keyValueStorage, (String)"keyValueStorage");
        this.keyValueStorage = keyValueStorage;
    }

    @NotNull
    public final Intent createVKClientAuthIntent(@NotNull VKAuthParams params) {
        Intent intent;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intent $this$createVKClientAuthIntent_u24lambda_u240 = intent = new Intent(VK_APP_AUTH_ACTION, null);
        boolean bl = false;
        $this$createVKClientAuthIntent_u24lambda_u240.setPackage(VK_APP_PACKAGE_ID);
        $this$createVKClientAuthIntent_u24lambda_u240.putExtras(params.toExtraBundle());
        return intent;
    }

    public final boolean onActivityResult(@NotNull Context context, int requestCode, int resultCode, @Nullable Intent data, @NotNull VKAuthCallback callback, boolean showErrorToast) {
        block4: {
            VKAuthenticationResult result;
            block3: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
                if (requestCode != 282) {
                    return false;
                }
                if (data == null) {
                    callback.onLoginFailed(new VKAuthException(0, null, 3, null));
                    return true;
                }
                result = this.processResult(data);
                if (resultCode == -1 && !(result instanceof VKAuthenticationResult.Failed)) break block3;
                Object object = result instanceof VKAuthenticationResult.Failed ? (VKAuthenticationResult.Failed)result : null;
                if (object == null || (object = ((VKAuthenticationResult.Failed)object).getException()) == null) {
                    object = this.obtainExceptionFromIntent(data);
                }
                Object loginError = object;
                callback.onLoginFailed((VKAuthException)loginError);
                if (!showErrorToast || ((VKAuthException)loginError).isCanceled()) break block4;
                ContextExtKt.showToast(context, R.string.vk_message_login_error);
                break block4;
            }
            VKAuthenticationResult.Success success = result instanceof VKAuthenticationResult.Success ? (VKAuthenticationResult.Success)result : null;
            if (success == null) break block4;
            VKAuthenticationResult.Success it = success;
            boolean bl = false;
            this.storeLoginResult(it);
            callback.onLogin(it.getToken());
        }
        return true;
    }

    @NotNull
    public final VKAuthenticationResult processResult(@Nullable Intent result) {
        Object object;
        if (result == null) {
            return new VKAuthenticationResult.Failed(new VKAuthException(0, "No result from caller provided", 1, null));
        }
        Map tokenParams = null;
        if (result.hasExtra(VK_EXTRA_TOKEN_DATA)) {
            String tokenInfo = result.getStringExtra(VK_EXTRA_TOKEN_DATA);
            tokenParams = VKUtils.explodeQueryString(tokenInfo);
        } else if (result.getExtras() != null) {
            tokenParams = new HashMap();
            Bundle bundle = result.getExtras();
            Intrinsics.checkNotNull((Object)bundle);
            for (String key : bundle.keySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Bundle bundle2 = result.getExtras();
                Intrinsics.checkNotNull((Object)bundle2);
                tokenParams.put(key, String.valueOf(bundle2.get(key)));
            }
        } else {
            tokenParams = null;
        }
        if (tokenParams != null && tokenParams.get(VK_AUTH_ERROR) == null) {
            Object object2;
            try {
                object2 = new VKAuthenticationResult.Success(new VKAccessToken(tokenParams));
            }
            catch (Exception e) {
                Log.e((String)VKAuthManager.class.getSimpleName(), (String)"Failed to get VK token", (Throwable)e);
                object2 = new VKAuthenticationResult.Failed(new VKAuthException(0, "Auth failed due to exception: " + e.getMessage(), 1, null));
            }
            object = object2;
        } else {
            object = new VKAuthenticationResult.Failed(this.obtainExceptionFromIntent(result));
        }
        return object;
    }

    public final void storeLoginResult(@NotNull VKAuthenticationResult.Success result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        result.getToken().save(this.keyValueStorage);
        VK.INSTANCE.getApiManager$core_release().setCredentials(CollectionsKt.listOf((Object)new VKApiCredentials(result.getToken().getAccessToken(), result.getToken().getSecret(), result.getToken().getExpiresInSec(), result.getToken().getCreatedMs(), result.getToken().getUserId())));
    }

    public final boolean isLoggedIn() {
        VKAccessToken token = this.getCurrentToken();
        return token != null && token.isValid();
    }

    @Nullable
    public final VKAccessToken getCurrentToken() {
        return VKAccessToken.Companion.restore(this.keyValueStorage);
    }

    public final void clearAccessToken() {
        VKAccessToken.Companion.remove(this.keyValueStorage);
    }

    private final VKAuthException obtainExceptionFromIntent(Intent intent) {
        Bundle bundle = intent.getExtras();
        int webViewError = bundle != null ? bundle.getInt("vw_login_error") : 0;
        Bundle bundle2 = intent.getExtras();
        String authError = bundle2 != null ? bundle2.getString(VK_AUTH_ERROR) : null;
        return new VKAuthException(webViewError, authError);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager$Companion;", "", "()V", "VK_APP_AUTH_ACTION", "", "VK_APP_AUTH_CODE", "", "VK_APP_PACKAGE_ID", "VK_AUTH_ERROR", "VK_EXTRA_TOKEN_DATA", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

