/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.browser;

import androidx.annotation.NonNull;
import com.vk.api.sdk.browser.BrowserDescriptor;
import com.vk.api.sdk.browser.BrowserMatcher;
import com.vk.api.sdk.browser.Browsers;
import com.vk.api.sdk.browser.VersionRange;
import java.util.Collections;
import java.util.Set;

public class VersionedBrowserMatcher
implements BrowserMatcher {
    public static final VersionedBrowserMatcher CHROME_CUSTOM_TAB = new VersionedBrowserMatcher("com.android.chrome", Browsers.Chrome.SIGNATURE_SET, true, VersionRange.atLeast(Browsers.Chrome.MINIMUM_VERSION_FOR_CUSTOM_TAB));
    public static final VersionedBrowserMatcher CHROME_BROWSER = new VersionedBrowserMatcher("com.android.chrome", Browsers.Chrome.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final VersionedBrowserMatcher FIREFOX_CUSTOM_TAB = new VersionedBrowserMatcher("org.mozilla.firefox", Browsers.Firefox.SIGNATURE_SET, true, VersionRange.atLeast(Browsers.Firefox.MINIMUM_VERSION_FOR_CUSTOM_TAB));
    public static final VersionedBrowserMatcher FIREFOX_BROWSER = new VersionedBrowserMatcher("org.mozilla.firefox", Browsers.Firefox.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final VersionedBrowserMatcher SAMSUNG_BROWSER = new VersionedBrowserMatcher("com.sec.android.app.sbrowser", Browsers.SBrowser.SIGNATURE_SET, false, VersionRange.ANY_VERSION);
    public static final BrowserMatcher ANY_BROWSER = new BrowserMatcher(){

        @Override
        public boolean matches(@NonNull BrowserDescriptor descriptor) {
            return true;
        }
    };
    public static final VersionedBrowserMatcher SAMSUNG_CUSTOM_TAB = new VersionedBrowserMatcher("com.sec.android.app.sbrowser", Browsers.SBrowser.SIGNATURE_SET, true, VersionRange.atLeast(Browsers.SBrowser.MINIMUM_VERSION_FOR_CUSTOM_TAB));
    private String mPackageName;
    private Set<String> mSignatureHashes;
    private VersionRange mVersionRange;
    private boolean mUsingCustomTab;

    public VersionedBrowserMatcher(@NonNull String packageName, @NonNull String signatureHash, boolean usingCustomTab, @NonNull VersionRange versionRange) {
        this(packageName, Collections.singleton(signatureHash), usingCustomTab, versionRange);
    }

    public VersionedBrowserMatcher(@NonNull String packageName, @NonNull Set<String> signatureHashes, boolean usingCustomTab, @NonNull VersionRange versionRange) {
        this.mPackageName = packageName;
        this.mSignatureHashes = signatureHashes;
        this.mUsingCustomTab = usingCustomTab;
        this.mVersionRange = versionRange;
    }

    @Override
    public boolean matches(@NonNull BrowserDescriptor descriptor) {
        return this.mPackageName.equals(descriptor.packageName) && this.mUsingCustomTab == descriptor.useCustomTab && this.mVersionRange.matches(descriptor.version) && this.mSignatureHashes.equals(descriptor.signatureHashes);
    }
}

