/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.browser;

import android.content.Context;
import android.util.Log;
import androidx.annotation.Nullable;
import com.vk.api.sdk.browser.BrowserDescriptor;
import com.vk.api.sdk.browser.BrowserSelector;
import com.vk.api.sdk.browser.VersionedBrowserMatcher;
import java.util.Arrays;
import java.util.List;

public class WhiteListedBrowserHelper {
    private static final List<VersionedBrowserMatcher> WHITE_LIST = Arrays.asList(VersionedBrowserMatcher.CHROME_BROWSER, VersionedBrowserMatcher.CHROME_CUSTOM_TAB, VersionedBrowserMatcher.FIREFOX_CUSTOM_TAB, VersionedBrowserMatcher.FIREFOX_BROWSER, VersionedBrowserMatcher.SAMSUNG_BROWSER, VersionedBrowserMatcher.SAMSUNG_CUSTOM_TAB);

    @Nullable
    public static BrowserDescriptor selectBestBrowser(Context context) {
        try {
            List<BrowserDescriptor> allBrowsers = BrowserSelector.getAllBrowsers(context);
            for (BrowserDescriptor descriptor : allBrowsers) {
                for (VersionedBrowserMatcher versionedBrowserMatcher : WHITE_LIST) {
                    if (!versionedBrowserMatcher.matches(descriptor)) continue;
                    return descriptor;
                }
            }
            return allBrowsers.isEmpty() ? null : allBrowsers.get(0);
        }
        catch (Exception e) {
            Log.e((String)"BrowserSelector", (String)"Exception in select browser", (Throwable)e);
            return null;
        }
    }
}

