/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.VKMethodCall;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.utils.ApiMethodPriorityBackoff;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0006\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vk/api/sdk/chain/ApiMethodPriorityChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "chain", "call", "Lcom/vk/api/sdk/VKMethodCall;", "priorityBackoff", "Lcom/vk/api/sdk/utils/ApiMethodPriorityBackoff;", "(Lcom/vk/api/sdk/VKApiManager;Lcom/vk/api/sdk/chain/ChainCall;Lcom/vk/api/sdk/VKMethodCall;Lcom/vk/api/sdk/utils/ApiMethodPriorityBackoff;)V", "chainId", "", "getChainId", "()I", "chainId$delegate", "Lkotlin/Lazy;", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "core_release"})
public final class ApiMethodPriorityChainCall<T>
extends ChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;
    @NotNull
    private final VKMethodCall call;
    @NotNull
    private final ApiMethodPriorityBackoff priorityBackoff;
    @NotNull
    private final Lazy chainId$delegate;

    public ApiMethodPriorityChainCall(@NotNull VKApiManager manager, @NotNull ChainCall<? extends T> chain, @NotNull VKMethodCall call, @NotNull ApiMethodPriorityBackoff priorityBackoff) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)priorityBackoff, (String)"priorityBackoff");
        super(manager);
        this.chain = chain;
        this.call = call;
        this.priorityBackoff = priorityBackoff;
        this.chainId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ApiMethodPriorityChainCall<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return ApiMethodPriorityChainCall.access$getPriorityBackoff$p(this.this$0).newId();
            }
        }));
    }

    private final int getChainId() {
        Lazy lazy = this.chainId$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (!this.priorityBackoff.isActive()) {
            return this.chain.call(args);
        }
        String method = this.call.getMethod();
        while (this.priorityBackoff.shouldWait(method)) {
            if (Thread.interrupted()) {
                throw new InterruptedException("request interrupted");
            }
            this.priorityBackoff.processMethod(this.getChainId(), method);
        }
        try {
            T result = this.chain.call(args);
            this.priorityBackoff.onMethodCompleted(method);
            return result;
        }
        catch (Exception e) {
            this.priorityBackoff.onMethodCompleted(method);
            throw e;
        }
    }

    public static final /* synthetic */ ApiMethodPriorityBackoff access$getPriorityBackoff$p(ApiMethodPriorityChainCall $this) {
        return $this.priorityBackoff;
    }
}

