/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.chain.RetryChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKApiIllegalResponseException;
import com.vk.api.sdk.exceptions.VKInternalServerErrorException;
import com.vk.api.sdk.utils.ExponentialBackoff;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\u000e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/vk/api/sdk/chain/ErrorRetryChainCall;", "T", "Lcom/vk/api/sdk/chain/RetryChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "retryLimit", "", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "(Lcom/vk/api/sdk/VKApiManager;ILcom/vk/api/sdk/chain/ChainCall;)V", "backoff", "Lcom/vk/api/sdk/utils/ExponentialBackoff;", "getChain", "()Lcom/vk/api/sdk/chain/ChainCall;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "core_release"})
public final class ErrorRetryChainCall<T>
extends RetryChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;
    @NotNull
    private final ExponentialBackoff backoff;

    public ErrorRetryChainCall(@NotNull VKApiManager manager, int retryLimit, @NotNull ChainCall<? extends T> chain) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        super(manager, retryLimit);
        this.chain = chain;
        this.backoff = new ExponentialBackoff(1000L, 60000L, 1.5f, 0.0f, 0.0f, 24, null);
    }

    @NotNull
    public final ChainCall<T> getChain() {
        return this.chain;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Exception latestException = null;
        while (this.getRetryLimit() < 0 || this.backoff.getErrorsCount() <= this.getRetryLimit()) {
            if (this.backoff.shouldWait()) {
                Thread.sleep(this.backoff.getDelayMs());
            }
            try {
                return this.chain.call(args);
            }
            catch (VKApiExecutionException ex) {
                if (ex.isInternalServerError()) {
                    this.logWarning("", ex);
                    latestException = ex;
                    this.backoff.onError();
                    continue;
                }
                throw ex;
            }
            catch (VKApiIllegalResponseException ex) {
                this.logWarning("", ex);
                latestException = ex;
                this.backoff.onError();
            }
            catch (VKInternalServerErrorException ex) {
                this.logWarning("", ex);
                latestException = ex;
                this.backoff.onError();
            }
        }
        throw latestException == null ? (Throwable)new VKApiException("api-call failed due to retry limits, but no exception has tracked") : (Throwable)latestException;
    }
}

