/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiJSONResponseParser;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.auth.VKAccessTokenProvider;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.okhttp.OkHttpExecutor;
import com.vk.api.sdk.okhttp.OkHttpMethodCall;
import com.vk.api.sdk.utils.ApiExtKt;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ'\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\n2\b\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006."}, d2={"Lcom/vk/api/sdk/chain/MethodChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "okHttpExecutor", "Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "callBuilder", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;", "defaultDeviceId", "", "defaultLang", "parser", "Lcom/vk/api/sdk/VKApiJSONResponseParser;", "(Lcom/vk/api/sdk/VKApiManager;Lcom/vk/api/sdk/okhttp/OkHttpExecutor;Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;Ljava/lang/String;Ljava/lang/String;Lcom/vk/api/sdk/VKApiJSONResponseParser;)V", "getCallBuilder", "()Lcom/vk/api/sdk/okhttp/OkHttpMethodCall$Builder;", "getDefaultDeviceId", "()Ljava/lang/String;", "setDefaultDeviceId", "(Ljava/lang/String;)V", "getDefaultLang", "getOkHttpExecutor", "()Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "getParser", "()Lcom/vk/api/sdk/VKApiJSONResponseParser;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "parseResult", "methodResponse", "Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;", "methodName", "ignoredExecuteErrors", "", "(Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;Ljava/lang/String;[I)Ljava/lang/Object;", "runRequest", "mc", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;", "(Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;)Ljava/lang/Object;", "trackClientIdClientSecretMethods", "", "provider", "Lcom/vk/api/sdk/auth/VKAccessTokenProvider;", "methodBuilder", "core_release"})
public class MethodChainCall<T>
extends ChainCall<T> {
    @NotNull
    private final OkHttpExecutor okHttpExecutor;
    @NotNull
    private final OkHttpMethodCall.Builder callBuilder;
    @NotNull
    private String defaultDeviceId;
    @NotNull
    private final String defaultLang;
    @Nullable
    private final VKApiJSONResponseParser<T> parser;

    public MethodChainCall(@NotNull VKApiManager manager, @NotNull OkHttpExecutor okHttpExecutor, @NotNull OkHttpMethodCall.Builder callBuilder, @NotNull String defaultDeviceId, @NotNull String defaultLang, @Nullable VKApiJSONResponseParser<T> parser) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)okHttpExecutor, (String)"okHttpExecutor");
        Intrinsics.checkNotNullParameter((Object)callBuilder, (String)"callBuilder");
        Intrinsics.checkNotNullParameter((Object)defaultDeviceId, (String)"defaultDeviceId");
        Intrinsics.checkNotNullParameter((Object)defaultLang, (String)"defaultLang");
        super(manager);
        this.okHttpExecutor = okHttpExecutor;
        this.callBuilder = callBuilder;
        this.defaultDeviceId = defaultDeviceId;
        this.defaultLang = defaultLang;
        this.parser = parser;
    }

    @NotNull
    public final OkHttpExecutor getOkHttpExecutor() {
        return this.okHttpExecutor;
    }

    @NotNull
    public final OkHttpMethodCall.Builder getCallBuilder() {
        return this.callBuilder;
    }

    @NotNull
    public final String getDefaultDeviceId() {
        return this.defaultDeviceId;
    }

    public final void setDefaultDeviceId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.defaultDeviceId = string2;
    }

    @NotNull
    public final String getDefaultLang() {
        return this.defaultLang;
    }

    @Nullable
    public final VKApiJSONResponseParser<T> getParser() {
        return this.parser;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        String lang;
        String deviceId;
        String string2;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.hasCaptcha()) {
            this.callBuilder.args("captcha_sid", args.getCaptchaSid()).args("captcha_key", args.getCaptchaKey());
            Integer n = args.getCaptchaAttempt();
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                this.callBuilder.args("captcha_attempt", String.valueOf(it));
            }
            Double d = args.getCaptchaTimestamp();
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                this.callBuilder.args("captcha_ts", String.valueOf(it));
            }
        }
        if (args.getUserConfirmed()) {
            this.callBuilder.args("confirm", "1");
        }
        if ((string2 = this.callBuilder.args("device_id")) == null) {
            string2 = "";
        }
        if (StringsKt.isBlank((CharSequence)(deviceId = string2))) {
            deviceId = this.defaultDeviceId;
        }
        String string3 = deviceId;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
        this.callBuilder.args("device_id", string4);
        String string5 = this.callBuilder.args("lang");
        if (string5 == null) {
            string5 = "";
        }
        if (StringsKt.isBlank((CharSequence)(lang = string5))) {
            lang = this.defaultLang;
        }
        String string6 = lang;
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
        String string7 = string6.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).toLowerCase(locale)");
        this.callBuilder.args("lang", string7);
        return this.runRequest(this.callBuilder.build());
    }

    @Nullable
    public T runRequest(@NotNull OkHttpMethodCall mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        return this.parseResult(this.okHttpExecutor.execute(mc), mc.getMethod(), null);
    }

    @Nullable
    public final T parseResult(@NotNull OkHttpExecutor.ExecutorResponse methodResponse, @NotNull String methodName, @Nullable int[] ignoredExecuteErrors) {
        VKApiJSONResponseParser<T> vKApiJSONResponseParser;
        Intrinsics.checkNotNullParameter((Object)methodResponse, (String)"methodResponse");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        JSONObject jSONObject = methodResponse.getResponseBodyJson();
        if (jSONObject == null) {
            throw new VKApiException("Response returned null instead of valid string response");
        }
        JSONObject jsonBody = jSONObject;
        VKApiException executeEx = ApiExtKt.hasSimpleError(jsonBody) ? ApiExtKt.toSimpleError(jsonBody, methodName, methodResponse.getExecutorRequestAccessToken()) : (ApiExtKt.hasExecuteError(jsonBody, ignoredExecuteErrors) ? ApiExtKt.toExecuteError(jsonBody, methodName, ignoredExecuteErrors) : null);
        boolean bl = false;
        if (executeEx == null) {
            vKApiJSONResponseParser = this.parser;
        } else {
            throw executeEx;
        }
        return (T)(vKApiJSONResponseParser != null ? vKApiJSONResponseParser.parse(jsonBody) : null);
    }

    public void trackClientIdClientSecretMethods(@Nullable VKAccessTokenProvider provider, @NotNull OkHttpMethodCall.Builder methodBuilder) {
        Intrinsics.checkNotNullParameter((Object)methodBuilder, (String)"methodBuilder");
    }
}

