/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.RateLimitReachedException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.utils.TokenExponentialBackoff;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000fB+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vk/api/sdk/chain/RateLimitReachedChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "section", "", "backoff", "Lcom/vk/api/sdk/utils/TokenExponentialBackoff;", "chainCall", "(Lcom/vk/api/sdk/VKApiManager;Ljava/lang/String;Lcom/vk/api/sdk/utils/TokenExponentialBackoff;Lcom/vk/api/sdk/chain/ChainCall;)V", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "Companion", "core_release"})
public final class RateLimitReachedChainCall<T>
extends ChainCall<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String section;
    @NotNull
    private final TokenExponentialBackoff backoff;
    @NotNull
    private final ChainCall<T> chainCall;
    @NotNull
    private static final String DETAIL_MESSAGE = "Rate limit reached.";

    public RateLimitReachedChainCall(@NotNull VKApiManager manager, @NotNull String section, @NotNull TokenExponentialBackoff backoff, @NotNull ChainCall<? extends T> chainCall) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
        Intrinsics.checkNotNullParameter(chainCall, (String)"chainCall");
        super(manager);
        this.section = section;
        this.backoff = backoff;
        this.chainCall = chainCall;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.backoff.shouldWait(this.section)) {
            throw new RateLimitReachedException(this.section, DETAIL_MESSAGE);
        }
        try {
            T t;
            T it = t = this.chainCall.call(args);
            boolean bl = false;
            this.backoff.reset(this.section);
            return t;
        }
        catch (VKApiExecutionException ex) {
            if (ex.isRateLimitReachedError()) {
                this.backoff.backoff(this.section);
                this.logDebug(DETAIL_MESSAGE, ex);
            }
            throw ex;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/chain/RateLimitReachedChainCall$Companion;", "", "()V", "DETAIL_MESSAGE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

