/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.SectionAvailabilityListener;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.SectionTemporaryUnavailableException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.utils.TokenExponentialBackoff;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\nJ\u0017\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/vk/api/sdk/chain/SectionTemporaryUnavailableChainCall;", "T", "Lcom/vk/api/sdk/chain/ChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "section", "", "backoff", "Lcom/vk/api/sdk/utils/TokenExponentialBackoff;", "chainCall", "(Lcom/vk/api/sdk/VKApiManager;Ljava/lang/String;Lcom/vk/api/sdk/utils/TokenExponentialBackoff;Lcom/vk/api/sdk/chain/ChainCall;)V", "availabilityListener", "Lcom/vk/api/sdk/SectionAvailabilityListener;", "errorDescription", "getErrorDescription", "()Ljava/lang/String;", "errorDescription$delegate", "Lkotlin/Lazy;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "core_release"})
public final class SectionTemporaryUnavailableChainCall<T>
extends ChainCall<T> {
    @NotNull
    private final String section;
    @NotNull
    private final TokenExponentialBackoff backoff;
    @NotNull
    private final ChainCall<T> chainCall;
    @Nullable
    private final SectionAvailabilityListener availabilityListener;
    @NotNull
    private final Lazy errorDescription$delegate;

    public SectionTemporaryUnavailableChainCall(@NotNull VKApiManager manager, @NotNull String section, @NotNull TokenExponentialBackoff backoff, @NotNull ChainCall<? extends T> chainCall) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Intrinsics.checkNotNullParameter((Object)backoff, (String)"backoff");
        Intrinsics.checkNotNullParameter(chainCall, (String)"chainCall");
        super(manager);
        this.section = section;
        this.backoff = backoff;
        this.chainCall = chainCall;
        this.availabilityListener = manager.getConfig().getSectionAvailabilityListener();
        this.errorDescription$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ SectionTemporaryUnavailableChainCall<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Section temporary unavailable for " + SectionTemporaryUnavailableChainCall.access$getSection$p(this.this$0) + '.';
            }
        }));
    }

    private final String getErrorDescription() {
        Lazy lazy = this.errorDescription$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (this.backoff.shouldWait(this.section)) {
            throw new SectionTemporaryUnavailableException(this.section, this.getErrorDescription());
        }
        try {
            T t;
            T it = t = this.chainCall.call(args);
            boolean bl = false;
            this.backoff.reset(this.section);
            SectionAvailabilityListener sectionAvailabilityListener = this.availabilityListener;
            if (sectionAvailabilityListener != null) {
                sectionAvailabilityListener.onSectionAvailable(this.section);
            }
            return t;
        }
        catch (VKApiExecutionException ex) {
            if (ex.isSectionTemporaryUnavailableError()) {
                this.backoff.backoff(this.section);
                SectionAvailabilityListener sectionAvailabilityListener = this.availabilityListener;
                if (sectionAvailabilityListener != null) {
                    sectionAvailabilityListener.onSectionUnavailable(this.section);
                }
                this.logDebug(this.getErrorDescription(), ex);
            }
            throw ex;
        }
    }

    public static final /* synthetic */ String access$getSection$p(SectionTemporaryUnavailableChainCall $this) {
        return $this.section;
    }
}

