/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiCredentials;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.VKApiValidationHandler;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.chain.RetryChainCall;
import com.vk.api.sdk.chain.ValidationHandlerChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.dto.common.id.UserId;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ^\u0010\u000e\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001\"\u0004\b\u0002\u0010\u000f\"\u0004\b\u0003\u0010\u00102\u0006\u0010\u0011\u001a\u0002H\u00102\b\u0010\u0012\u001a\u0004\u0018\u0001H\u000f2)\u0010\u0013\u001a%\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u00a2\u0006\u0002\b\u0017H\u0004\u00a2\u0006\u0002\u0010\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010 \u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\"\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010$\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/vk/api/sdk/chain/ValidationHandlerChainCall;", "T", "Lcom/vk/api/sdk/chain/RetryChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "retryLimit", "", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "validationLock", "Lcom/vk/api/sdk/VKApiValidationHandler$ValidationLock;", "(Lcom/vk/api/sdk/VKApiManager;ILcom/vk/api/sdk/chain/ChainCall;Lcom/vk/api/sdk/VKApiValidationHandler$ValidationLock;)V", "getChain", "()Lcom/vk/api/sdk/chain/ChainCall;", "awaitValidation", "H", "E", "extra", "handler", "handlerMethod", "Lkotlin/Function3;", "Lcom/vk/api/sdk/VKApiValidationHandler$Callback;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "handleCaptcha", "ex", "Lcom/vk/api/sdk/exceptions/VKApiExecutionException;", "handleCaptchaSolved", "handleException", "handleUserConfirmation", "handleValidation", "persistToken", "credentials", "Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "core_release"})
public final class ValidationHandlerChainCall<T>
extends RetryChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;
    @NotNull
    private final VKApiValidationHandler.ValidationLock validationLock;

    public ValidationHandlerChainCall(@NotNull VKApiManager manager, int retryLimit, @NotNull ChainCall<? extends T> chain, @NotNull VKApiValidationHandler.ValidationLock validationLock) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)validationLock, (String)"validationLock");
        super(manager, retryLimit);
        this.chain = chain;
        this.validationLock = validationLock;
    }

    @NotNull
    public final ChainCall<T> getChain() {
        return this.chain;
    }

    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        int i = 0;
        int n = this.getRetryLimit();
        if (i <= n) {
            while (true) {
                try {
                    this.validationLock.await();
                    T response = this.chain.call(args);
                    ValidationHandlerChainCall.handleCaptchaSolved$default(this, args, null, 2, null);
                    return response;
                }
                catch (VKApiExecutionException ex) {
                    this.handleException(ex, args);
                    if (i == n) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
        throw new VKApiException("Can't confirm validation due to retry limit!");
    }

    private final void handleException(VKApiExecutionException ex, ChainArgs args) throws Exception {
        this.handleCaptchaSolved(args, ex);
        if (ex.isCaptchaError()) {
            this.handleCaptcha(ex, args);
        } else if (ex.isValidationRequired()) {
            this.handleValidation(ex);
        } else if (ex.isUserConfirmRequired()) {
            this.handleUserConfirmation(ex, args);
        } else {
            Unit unit;
            VKApiValidationHandler vKApiValidationHandler = this.getManager().getValidationHandler$core_release();
            if (vKApiValidationHandler != null) {
                vKApiValidationHandler.tryToHandleException(ex, this.getManager());
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw ex;
            }
        }
    }

    private final void handleUserConfirmation(VKApiExecutionException ex, ChainArgs args) {
        Boolean confirmation2 = (Boolean)this.awaitValidation(ex.getUserConfirmText(), this.getManager().getValidationHandler$core_release(), handleUserConfirmation.confirmation.1.INSTANCE);
        Boolean bl = confirmation2;
        if (bl == null) {
            throw ex;
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            throw ex;
        }
        args.setUserConfirmed(confirmation2);
    }

    private final void handleValidation(VKApiExecutionException ex) {
        VKApiValidationHandler.Credentials credentials2 = (VKApiValidationHandler.Credentials)this.awaitValidation(ex.getValidationUrl(), this.getManager().getValidationHandler$core_release(), handleValidation.credentials.1.INSTANCE);
        this.persistToken(credentials2, ex);
    }

    protected final void persistToken(@Nullable VKApiValidationHandler.Credentials credentials2, @NotNull VKApiExecutionException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (!Intrinsics.areEqual((Object)credentials2, (Object)VKApiValidationHandler.Credentials.Companion.getEMPTY())) {
            VKApiValidationHandler.Credentials credentials3 = credentials2;
            boolean bl = credentials3 != null ? credentials3.isValid() : false;
            if (bl) {
                VKApiManager vKApiManager = this.getManager();
                String string2 = credentials2.getToken();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = credentials2.getSecret();
                int n = credentials2.getExpiresInSec();
                long l = credentials2.getCreatedMs();
                UserId userId = credentials2.getUid();
                if (userId == null) {
                    userId = UserId.DEFAULT;
                }
                vKApiManager.setCredentials(CollectionsKt.listOf((Object)new VKApiCredentials(string2, string3, n, l, userId)));
            } else {
                throw ex;
            }
        }
    }

    private final void handleCaptcha(VKApiExecutionException ex, ChainArgs args) {
        ChainArgs chainArgs;
        VKApiValidationHandler.Captcha captcha = new VKApiValidationHandler.Captcha(ex.getCaptchaImg(), ex.getCaptchaHeight(), ex.getCaptchaWidth(), ex.getCaptchaRatio(), ex.getCaptchaIsRefreshEnabled());
        String captchaResult2 = (String)this.awaitValidation(captcha, this.getManager().getValidationHandler$core_release(), handleCaptcha.captchaResult.1.INSTANCE);
        if (captchaResult2 == null) {
            throw ex;
        }
        ChainArgs $this$handleCaptcha_u24lambda_u240 = chainArgs = args;
        boolean bl = false;
        $this$handleCaptcha_u24lambda_u240.setCaptchaSid(ex.getCaptchaSid());
        $this$handleCaptcha_u24lambda_u240.setCaptchaAttempt(ex.getCaptchaAttempt());
        $this$handleCaptcha_u24lambda_u240.setCaptchaTimestamp(ex.getCaptchaTimestamp());
        $this$handleCaptcha_u24lambda_u240.setCaptchaKey(captchaResult2);
    }

    @Nullable
    protected final <T, H, E> T awaitValidation(E extra, @Nullable H handler2, @NotNull Function3<? super H, ? super E, ? super VKApiValidationHandler.Callback<T>, Unit> handlerMethod) {
        Intrinsics.checkNotNullParameter(handlerMethod, (String)"handlerMethod");
        if (handler2 == null || !this.validationLock.acquire()) {
            return null;
        }
        VKApiValidationHandler.Callback callback = new VKApiValidationHandler.Callback(this.validationLock);
        handlerMethod.invoke(handler2, extra, callback);
        this.validationLock.await();
        return callback.getValue();
    }

    private final void handleCaptchaSolved(ChainArgs args, VKApiExecutionException ex) {
        block1: {
            if (!args.hasCaptcha() || ex != null && ex.isCaptchaError()) break block1;
            VKApiValidationHandler vKApiValidationHandler = this.getManager().getValidationHandler$core_release();
            if (vKApiValidationHandler != null) {
                vKApiValidationHandler.handleCaptchaSolved();
            }
        }
    }

    static /* synthetic */ void handleCaptchaSolved$default(ValidationHandlerChainCall validationHandlerChainCall, ChainArgs chainArgs, VKApiExecutionException vKApiExecutionException, int n, Object object) {
        if ((n & 2) != 0) {
            vKApiExecutionException = null;
        }
        validationHandlerChainCall.handleCaptchaSolved(chainArgs, vKApiExecutionException);
    }
}

