/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.exceptions;

import android.util.Log;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lcom/vk/api/sdk/exceptions/ApiErrorViewType;", "", "(Ljava/lang/String;I)V", "INPUT", "FULLSCREEN", "ALERT", "CUSTOM", "SKIP", "Companion", "core_release"})
public final class ApiErrorViewType
extends Enum<ApiErrorViewType> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String TAG = "VkApiErrorViewType";
    @NotNull
    private static final ApiErrorViewType DEFAULT_VIEW_TYPE;
    public static final /* enum */ ApiErrorViewType INPUT;
    public static final /* enum */ ApiErrorViewType FULLSCREEN;
    public static final /* enum */ ApiErrorViewType ALERT;
    public static final /* enum */ ApiErrorViewType CUSTOM;
    public static final /* enum */ ApiErrorViewType SKIP;
    private static final /* synthetic */ ApiErrorViewType[] $VALUES;

    public static ApiErrorViewType[] values() {
        return (ApiErrorViewType[])$VALUES.clone();
    }

    public static ApiErrorViewType valueOf(String value2) {
        return Enum.valueOf(ApiErrorViewType.class, value2);
    }

    static {
        INPUT = new ApiErrorViewType();
        FULLSCREEN = new ApiErrorViewType();
        ALERT = new ApiErrorViewType();
        CUSTOM = new ApiErrorViewType();
        SKIP = new ApiErrorViewType();
        $VALUES = apiErrorViewTypeArray = new ApiErrorViewType[]{ApiErrorViewType.INPUT, ApiErrorViewType.FULLSCREEN, ApiErrorViewType.ALERT, ApiErrorViewType.CUSTOM, ApiErrorViewType.SKIP};
        Companion = new Companion(null);
        DEFAULT_VIEW_TYPE = CUSTOM;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vk/api/sdk/exceptions/ApiErrorViewType$Companion;", "", "()V", "DEFAULT_VIEW_TYPE", "Lcom/vk/api/sdk/exceptions/ApiErrorViewType;", "TAG", "", "fromString", "errorType", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ApiErrorViewType fromString(@NotNull String errorType) {
            ApiErrorViewType apiErrorViewType;
            Intrinsics.checkNotNullParameter((Object)errorType, (String)"errorType");
            if (StringsKt.isBlank((CharSequence)errorType)) {
                Log.d((String)ApiErrorViewType.TAG, (String)"Empty error view type");
                return null;
            }
            try {
                String string2 = errorType.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                apiErrorViewType = ApiErrorViewType.valueOf(string2);
            }
            catch (IllegalArgumentException exception) {
                Log.e((String)ApiErrorViewType.TAG, (String)("Unknown error view type: " + errorType), (Throwable)exception);
                apiErrorViewType = DEFAULT_VIEW_TYPE;
            }
            return apiErrorViewType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

