/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import com.vk.api.sdk.exceptions.VKLocalIOException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.http2.StreamResetException;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody;", "Lokhttp3/RequestBody;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "lastPathSegment", "", "scheme", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "isDuplex", "", "wrapIoException", "T", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nFileFullRequestBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileFullRequestBody.kt\ncom/vk/api/sdk/okhttp/FileFullRequestBody\n*L\n1#1,130:1\n120#1,5:131\n120#1,5:136\n*S KotlinDebug\n*F\n+ 1 FileFullRequestBody.kt\ncom/vk/api/sdk/okhttp/FileFullRequestBody\n*L\n103#1:131,5\n106#1:136,5\n*E\n"})
public final class FileFullRequestBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Uri uri;
    @NotNull
    private final String scheme;
    @NotNull
    private final String lastPathSegment;
    private static final int CHUNK = 8192;

    public FileFullRequestBody(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.context = context;
        this.uri = uri;
        CharSequence charSequence = this.uri.getScheme();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)this.uri.getLastPathSegment()) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new IllegalArgumentException("Illegal fileUri value: '" + this.uri + '\'');
        }
        String string2 = this.uri.getScheme();
        Intrinsics.checkNotNull((Object)string2);
        this.scheme = string2;
        String string3 = this.uri.getLastPathSegment();
        Intrinsics.checkNotNull((Object)string3);
        this.lastPathSegment = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public MediaType contentType() {
        String string2;
        String mimeType;
        block11: {
            mimeType = null;
            try {
                mimeType = URLConnection.guessContentTypeFromName(this.lastPathSegment);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mimeType == null) {
                try {
                    Cursor cursor;
                    String[] stringArray = new String[]{"mime_type"};
                    String[] projection = stringArray;
                    Cursor cursor2 = cursor = this.context.getContentResolver().query(this.uri, projection, null, null, null);
                    if (cursor2 == null) break block11;
                    Closeable closeable = (Closeable)cursor2;
                    Throwable throwable = null;
                    try {
                        Cursor it = (Cursor)closeable;
                        boolean bl = false;
                        mimeType = it.isNull(0) ? null : it.getString(0);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if ((string2 = mimeType) == null || (string2 = MediaType.Companion.parse(string2)) == null) {
            string2 = MediaType.Companion.get("application/octet-stream");
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long contentLength() throws IOException {
        AssetFileDescriptor fd = null;
        try {
            AssetFileDescriptor assetFileDescriptor = fd = this.context.getContentResolver().openAssetFileDescriptor(this.uri, "r");
            if (assetFileDescriptor == null) {
                throw new FileNotFoundException("Cannot open uri: " + this.uri);
            }
            long l = assetFileDescriptor.getLength();
            return l;
        }
        catch (FileNotFoundException ex) {
            throw new VKLocalIOException(ex);
        }
        finally {
            try {
                AssetFileDescriptor assetFileDescriptor;
                AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor = fd;
                if (assetFileDescriptor2 != null) {
                    assetFileDescriptor2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        AssetFileDescriptor assetFileDescriptor = this.context.getContentResolver().openAssetFileDescriptor(this.uri, "r");
        if (assetFileDescriptor != null) {
            Closeable closeable = (Closeable)assetFileDescriptor;
            Throwable throwable = null;
            try {
                Source source;
                AssetFileDescriptor fileDescriptor = (AssetFileDescriptor)closeable;
                boolean bl = false;
                FileFullRequestBody this_$iv = this;
                boolean $i$f$wrapIoException = false;
                try {
                    boolean bl2 = false;
                    FileInputStream fileInputStream = fileDescriptor.createInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)fileInputStream, (String)"fileDescriptor.createInputStream()");
                    source = Okio.source((InputStream)fileInputStream);
                }
                catch (IOException e$iv) {
                    throw !(e$iv instanceof VKLocalIOException) ? (Throwable)new VKLocalIOException(e$iv) : (Throwable)e$iv;
                }
                Source source2 = source;
                long totalBytesRead = 0L;
                while (true) {
                    long l;
                    FileFullRequestBody this_$iv2 = this;
                    boolean $i$f$wrapIoException2 = false;
                    try {
                        boolean bl3 = false;
                        l = source2.read(sink.getBuffer(), 8192L);
                    }
                    catch (IOException e$iv) {
                        throw !(e$iv instanceof VKLocalIOException) ? (Throwable)new VKLocalIOException(e$iv) : (Throwable)e$iv;
                    }
                    long readCount = l;
                    if (readCount == -1L) break;
                    totalBytesRead += readCount;
                    try {
                        sink.emitCompleteSegments();
                    }
                    catch (StreamResetException t) {
                        break;
                    }
                }
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new FileNotFoundException("Cannot open uri: " + this.uri);
        }
    }

    public boolean isDuplex() {
        return true;
    }

    private final <T> T wrapIoException(Function0<? extends T> block) {
        Object object;
        boolean $i$f$wrapIoException = false;
        try {
            object = block.invoke();
        }
        catch (IOException e) {
            throw !(e instanceof VKLocalIOException) ? (Throwable)new VKLocalIOException(e) : (Throwable)e;
        }
        return (T)object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody$Companion;", "", "()V", "CHUNK", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

