/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import com.vk.api.sdk.VKApiConfig;
import com.vk.api.sdk.VKApiCredentials;
import com.vk.api.sdk.VKApiProgressListener;
import com.vk.api.sdk.VKHost;
import com.vk.api.sdk.VKOkHttpProvider;
import com.vk.api.sdk.exceptions.IgnoredAccessTokenException;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKInternalServerErrorException;
import com.vk.api.sdk.exceptions.VKLargeEntityException;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import com.vk.api.sdk.internal.QueryStringGenerator;
import com.vk.api.sdk.okhttp.FileFullRequestBody;
import com.vk.api.sdk.okhttp.LoggingInterceptor;
import com.vk.api.sdk.okhttp.LoggingPrefixer;
import com.vk.api.sdk.okhttp.OkHttpExecutor;
import com.vk.api.sdk.okhttp.OkHttpExecutorConfig;
import com.vk.api.sdk.okhttp.OkHttpMethodCall;
import com.vk.api.sdk.okhttp.OkHttpPostCall;
import com.vk.api.sdk.okhttp.ProgressRequestBody;
import com.vk.api.sdk.okhttp.RequestTag;
import com.vk.api.sdk.utils.SecureInfoStripper;
import com.vk.api.sdk.utils.VKApiCredentialsExtKt;
import com.vk.api.sdk.utils.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 ^2\u00020\u0001:\u0002^_B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u00010\u0014H\u0004J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u0014H\u0002J \u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020>2\u0006\u00102\u001a\u000203H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u00102\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010AJ\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u0012\u0010F\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203H\u0014J\u0012\u0010G\u001a\u0004\u0018\u00010\u00142\u0006\u00102\u001a\u000203H\u0014J\u0010\u0010H\u001a\u00020.2\b\u0010I\u001a\u0004\u0018\u00010\u0014J\u0010\u0010J\u001a\u00020.2\u0006\u0010K\u001a\u00020\u0014H\u0002J\u0018\u0010L\u001a\u00020M2\u0006\u00102\u001a\u00020?2\u0006\u0010N\u001a\u00020OH\u0014J\u0010\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020CJ\u0010\u0010S\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J!\u0010\u0011\u001a\u00020.2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0000\u00a2\u0006\u0002\bTJ\u0014\u0010\u0011\u001a\u00020.2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\rJ\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u000eH\u0002J\u0010\u0010U\u001a\u00020.2\u0006\u0010V\u001a\u00020 H\u0002J\u0018\u0010W\u001a\u00020\u00142\u0006\u00102\u001a\u0002032\u0006\u0010X\u001a\u00020\u0014H\u0004J \u0010Y\u001a\u00020Z*\u00020Z2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020]0\\H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00142\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001d\u00a8\u0006`"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "", "config", "Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "(Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;)V", "getConfig", "()Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "credentials", "Lkotlin/Lazy;", "", "Lcom/vk/api/sdk/VKApiCredentials;", "getCredentials", "()Lkotlin/Lazy;", "setCredentials", "(Lkotlin/Lazy;)V", "customEndpoint", "", "host", "getHost", "()Ljava/lang/String;", "<set-?>", "ignoredAccessToken", "getIgnoredAccessToken", "isLoggedIn", "", "()Z", "lock", "okHttpProvider", "Lcom/vk/api/sdk/VKOkHttpProvider;", "getOkHttpProvider", "()Lcom/vk/api/sdk/VKOkHttpProvider;", "okHttpProvider$delegate", "Lkotlin/Lazy;", "reducedExpiresInSec", "", "getReducedExpiresInSec", "()I", "secureInfoStripper", "Lcom/vk/api/sdk/utils/SecureInfoStripper;", "tokenContainsAndValid", "getTokenContainsAndValid", "checkAccessTokenIsIgnored", "", "method", "requestAccessToken", "checkNonSecretMethodCall", "call", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;", "convertFileNameToSafeValue", "fileName", "createLoggingInterceptor", "Lcom/vk/api/sdk/okhttp/LoggingInterceptor;", "filterCredentials", "logger", "Lcom/vk/api/sdk/utils/log/Logger;", "loggingPrefixer", "Lcom/vk/api/sdk/okhttp/LoggingPrefixer;", "execute", "Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;", "Lcom/vk/api/sdk/okhttp/OkHttpPostCall;", "progressListener", "Lcom/vk/api/sdk/VKApiProgressListener;", "executeRequest", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "getActualAccessToken", "getActualSecret", "ignoreAccessToken", "accessToken", "log", "message", "makePostCallRequestBuilder", "Lokhttp3/Request$Builder;", "requestBody", "Lokhttp3/RequestBody;", "readResponse", "Lorg/json/JSONObject;", "response", "resolveEndpoint", "setCredentials$core_release", "updateClient", "provider", "validateQueryString", "paramsString", "updateWith", "Lokhttp3/MultipartBody$Builder;", "parts", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "Companion", "ExecutorResponse", "core_release"})
@SourceDebugExtension(value={"SMAP\nOkHttpExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpExecutor.kt\ncom/vk/api/sdk/okhttp/OkHttpExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1726#2,3:298\n1549#2:301\n1620#2,3:302\n483#3,7:305\n125#4:312\n152#4,3:313\n1#5:316\n*S KotlinDebug\n*F\n+ 1 OkHttpExecutor.kt\ncom/vk/api/sdk/okhttp/OkHttpExecutor\n*L\n88#1:298,3\n129#1:301\n129#1:302,3\n160#1:305,7\n161#1:312\n161#1:313,3\n*E\n"})
public class OkHttpExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OkHttpExecutorConfig config;
    @NotNull
    private final Context context;
    @NotNull
    private final Object lock;
    @NotNull
    private final Lazy okHttpProvider$delegate;
    @NotNull
    private volatile Lazy<? extends List<VKApiCredentials>> credentials;
    @NotNull
    private final Lazy<SecureInfoStripper> secureInfoStripper;
    @NotNull
    private final String customEndpoint;
    @Nullable
    private volatile String ignoredAccessToken;
    @NotNull
    public static final String MIME_APPLICATION = "application/x-www-form-urlencoded; charset=utf-8";
    @NotNull
    private static final String UTF_8 = "UTF-8";

    public OkHttpExecutor(@NotNull OkHttpExecutorConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.context = this.config.getContext();
        this.lock = new Object();
        this.okHttpProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VKOkHttpProvider>(this){
            final /* synthetic */ OkHttpExecutor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VKOkHttpProvider invoke() {
                if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
                    throw new IllegalStateException("UI thread");
                }
                OkHttpExecutor.access$updateClient(this.this$0, this.this$0.getConfig().getOkHttpProvider());
                return this.this$0.getConfig().getOkHttpProvider();
            }
        }));
        this.credentials = this.config.getCredentials();
        this.secureInfoStripper = LazyKt.lazy((Function0)secureInfoStripper.1.INSTANCE);
        this.customEndpoint = this.config.getCustomEndpoint();
    }

    @NotNull
    protected final OkHttpExecutorConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    private final VKOkHttpProvider getOkHttpProvider() {
        Lazy lazy = this.okHttpProvider$delegate;
        return (VKOkHttpProvider)lazy.getValue();
    }

    @NotNull
    public final String getHost() {
        return (String)this.config.getHostProvider().invoke();
    }

    @NotNull
    public final Lazy<List<VKApiCredentials>> getCredentials() {
        return this.credentials;
    }

    public final void setCredentials(@NotNull Lazy<? extends List<VKApiCredentials>> lazy) {
        Intrinsics.checkNotNullParameter(lazy, (String)"<set-?>");
        this.credentials = lazy;
    }

    private final int getReducedExpiresInSec() {
        return (int)((double)VKApiCredentialsExtKt.activeExpiresInSec((List)this.credentials.getValue()) * this.config.getExpiresInReduceRatio());
    }

    public final boolean isLoggedIn() {
        return !StringsKt.isBlank((CharSequence)VKApiCredentialsExtKt.activeAccessToken((List)this.credentials.getValue()));
    }

    public final boolean getTokenContainsAndValid() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.credentials.getValue();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    VKApiCredentials it = (VKApiCredentials)element$iv;
                    boolean bl2 = false;
                    if (this.tokenContainsAndValid(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean tokenContainsAndValid(VKApiCredentials credentials2) {
        return !StringsKt.isBlank((CharSequence)credentials2.getAccessToken()) && (credentials2.getExpiresInSec() <= 0 || (double)credentials2.getCreatedMs() + (double)credentials2.getExpiresInSec() * this.config.getExpiresInReduceRatio() * (double)1000 > (double)System.currentTimeMillis());
    }

    @Nullable
    public final String getIgnoredAccessToken() {
        return this.ignoredAccessToken;
    }

    public final void setCredentials(@NotNull List<VKApiCredentials> credentials2) {
        Intrinsics.checkNotNullParameter(credentials2, (String)"credentials");
        this.log(credentials2.toString());
        this.credentials = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends VKApiCredentials>>(credentials2){
            final /* synthetic */ List<VKApiCredentials> $credentials;
            {
                this.$credentials = $credentials;
                super(0);
            }

            @NotNull
            public final List<VKApiCredentials> invoke() {
                return this.$credentials;
            }
        }));
    }

    public final void setCredentials$core_release(@NotNull Lazy<? extends List<VKApiCredentials>> credentials2) {
        Intrinsics.checkNotNullParameter(credentials2, (String)"credentials");
        if (credentials2.isInitialized()) {
            this.log(credentials2.getValue().toString());
        }
        this.credentials = credentials2;
    }

    public final void ignoreAccessToken(@Nullable String accessToken) {
        this.ignoredAccessToken = accessToken;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ExecutorResponse execute(@NotNull OkHttpMethodCall call) throws InterruptedException, IOException, VKApiException {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String actualAccessToken = this.getActualAccessToken(call);
        this.checkAccessTokenIsIgnored(call.getMethod(), actualAccessToken);
        String actualSecret = this.getActualSecret(call);
        this.checkNonSecretMethodCall(call);
        Iterable iterable = (Iterable)this.credentials.getValue();
        boolean bl = call.isMultipleTokens();
        int n = this.config.getAppId();
        String string2 = actualSecret;
        String string3 = actualAccessToken;
        String string4 = call.getVersion();
        Map<String, String> map = call.getArgs();
        String string5 = call.getMethod();
        QueryStringGenerator queryStringGenerator = QueryStringGenerator.INSTANCE;
        boolean $i$f$map = false;
        void var7_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VKApiCredentials vKApiCredentials = (VKApiCredentials)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getAccessToken());
        }
        collection = (List)destination$iv$iv;
        String queryString = queryStringGenerator.buildSignedQueryStringForMethod(string5, map, string4, string3, string2, n, bl, collection, call.getForceAnonymous());
        RequestBody requestBody = RequestBody.Companion.create(this.validateQueryString(call, queryString), MediaType.Companion.parse(MIME_APPLICATION));
        String string6 = call.getRequestUrl();
        if (string6 == null) {
            string6 = this.getHost();
        }
        String reqHost = string6;
        RequestTag requestTag = call.getTag();
        Request.Builder requestBuilder = new Request.Builder().post(requestBody).url(this.resolveEndpoint(reqHost) + '/' + call.getMethod()).cacheControl(CacheControl.FORCE_NETWORK).tag(Map.class, requestTag != null ? requestTag.toMap() : null);
        Object object = call.getCustomTag();
        if (object != null) {
            Object customTag = object;
            boolean bl3 = false;
            requestBuilder.tag(customTag.getClass(), customTag);
        }
        Request request = requestBuilder.build();
        String executorAccessToken = VKApiCredentialsExtKt.activeAccessToken((List)this.credentials.getValue());
        Response okHttpResponse = this.executeRequest(request);
        return new ExecutorResponse(this.readResponse(okHttpResponse), okHttpResponse.headers(), executorAccessToken);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExecutorResponse execute(@NotNull OkHttpPostCall call, @Nullable VKApiProgressListener progressListener) throws InterruptedException, IOException, VKApiException {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.isMultipart()) {
            requestBody = (RequestBody)this.updateWith(new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM), call.getParts()).build();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map $this$filterValues$iv;
            Map<String, HttpMultipartEntry> map = call.getParts();
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                HttpMultipartEntry it = (HttpMultipartEntry)entry$iv.getValue();
                boolean bl = false;
                if (!(it instanceof HttpMultipartEntry.Text)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            boolean $i$f$map = false;
            result$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)it.getKey();
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type com.vk.api.sdk.internal.HttpMultipartEntry.Text");
                String value2 = ((HttpMultipartEntry.Text)v).getTextValue();
                collection.add(key + '=' + URLEncoder.encode(value2, UTF_8));
            }
            String queryString = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
            requestBody = RequestBody.Companion.create(queryString, MediaType.Companion.get(MIME_APPLICATION));
        }
        RequestBody body = requestBody;
        ProgressRequestBody requestBody2 = new ProgressRequestBody(body, progressListener);
        Request request = this.makePostCallRequestBuilder(call, requestBody2).build();
        Response response = this.executeRequest(request);
        return new ExecutorResponse(this.readResponse(response), response.headers(), null, 4, null);
    }

    @NotNull
    protected Request.Builder makePostCallRequestBuilder(@NotNull OkHttpPostCall call, @NotNull RequestBody requestBody) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        return new Request.Builder().post(requestBody).url(call.getUrl()).cacheControl(CacheControl.FORCE_NETWORK);
    }

    @NotNull
    protected final String validateQueryString(@NotNull OkHttpMethodCall call, @NotNull String paramsString) throws VKApiException {
        Collection collection;
        Uri uri;
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter((Object)paramsString, (String)"paramsString");
        if (StringsKt.startsWith$default((String)call.getMethod(), (String)"execute.", (boolean)false, (int)2, null) && (uri = Uri.parse((String)("https://" + VKHost.getHost() + "/?" + paramsString))).getQueryParameters("method").contains("execute") && !((collection = (Collection)uri.getQueryParameters("code")) == null || collection.isEmpty())) {
            throw new VKApiExecutionException(15, call.getMethod(), false, "Hey dude don't execute your hacky code ;)", null, null, null, null, 0, null, 1008, null);
        }
        return paramsString;
    }

    @NotNull
    public final Response executeRequest(@NotNull Request request) throws InterruptedException, IOException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.getOkHttpProvider().getClient().newCall(request).execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JSONObject readResponse(@NotNull Response response) {
        JSONObject jSONObject;
        block12: {
            Object object;
            int n;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    if (response.code() == 413) {
                        throw new VKLargeEntityException(response.message());
                    }
                    int n2 = response.code();
                    boolean bl = 500 <= n2 ? n2 < 600 : false;
                    if (!bl) break block12;
                    n = response.code();
                    object = response.body();
                    if (object == null) break block13;
                    Closeable closeable = (Closeable)object;
                    int n3 = n;
                    Throwable throwable = null;
                    try {
                        Object it = (ResponseBody)closeable;
                        boolean bl2 = false;
                        it = it.string();
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Object object2 = it;
                    n = n3;
                    object = object2;
                    if (object != null) break block14;
                }
                object = "null";
            }
            Object object3 = object;
            int n4 = n;
            throw new VKInternalServerErrorException(n4, (String)object3);
        }
        Object object = response.body();
        if (object != null && (object = object.byteStream()) != null) {
            Object inputStream = object;
            boolean bl = false;
            jSONObject = this.config.getResponseBodyJsonConverter().convertResponse((InputStream)inputStream, response.headers().get("content-type"), response.request().url().encodedPath());
        } else {
            jSONObject = null;
        }
        return jSONObject;
    }

    @Nullable
    protected String getActualAccessToken(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return VKApiCredentialsExtKt.activeAccessToken((List)this.credentials.getValue());
    }

    @Nullable
    protected String getActualSecret(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return VKApiCredentialsExtKt.activeSecret((List)this.credentials.getValue());
    }

    protected final void checkAccessTokenIsIgnored(@NotNull String method, @Nullable String requestAccessToken) throws IgnoredAccessTokenException {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (this.ignoredAccessToken != null && requestAccessToken != null && Intrinsics.areEqual((Object)requestAccessToken, (Object)this.ignoredAccessToken)) {
            throw new IgnoredAccessTokenException(method);
        }
    }

    protected void checkNonSecretMethodCall(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
    }

    private final MultipartBody.Builder updateWith(MultipartBody.Builder $this$updateWith, Map<String, ? extends HttpMultipartEntry> parts) {
        for (Map.Entry<String, ? extends HttpMultipartEntry> entry : parts.entrySet()) {
            String key = entry.getKey();
            HttpMultipartEntry entry2 = entry.getValue();
            if (entry2 instanceof HttpMultipartEntry.Text) {
                $this$updateWith.addFormDataPart(key, ((HttpMultipartEntry.Text)entry2).getTextValue());
                continue;
            }
            if (!(entry2 instanceof HttpMultipartEntry.File)) continue;
            FileFullRequestBody partBody = new FileFullRequestBody(this.context, ((HttpMultipartEntry.File)entry2).getFileUri());
            String string2 = ((HttpMultipartEntry.File)entry2).getFileName();
            if (string2 == null) {
                string2 = "";
            }
            $this$updateWith.addFormDataPart(key, this.convertFileNameToSafeValue(string2), (RequestBody)partBody);
        }
        return $this$updateWith;
    }

    private final String resolveEndpoint(String host) {
        if (((CharSequence)this.customEndpoint).length() == 0 || Intrinsics.areEqual((Object)this.customEndpoint, (Object)VKApiConfig.Companion.getDEFAULT_API_ENDPOINT())) {
            return OkHttpExecutor.Companion.defaultApiEndpoint(host);
        }
        return this.customEndpoint;
    }

    private final void updateClient(VKOkHttpProvider provider) {
        provider.updateClient(new VKOkHttpProvider.BuilderUpdateFunction(this){
            final /* synthetic */ OkHttpExecutor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public OkHttpClient.Builder update(@NotNull OkHttpClient.Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                if (Logger.LogLevel.NONE != this.this$0.getConfig().getLogger().getLogLevel().getValue()) {
                    builder.addInterceptor((Interceptor)this.this$0.createLoggingInterceptor(this.this$0.getConfig().getLogFilterCredentials(), this.this$0.getConfig().getLogger(), this.this$0.getConfig().getLoggingPrefixer()));
                }
                return builder;
            }
        });
    }

    @NotNull
    protected LoggingInterceptor createLoggingInterceptor(boolean filterCredentials, @NotNull Logger logger, @NotNull LoggingPrefixer loggingPrefixer) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)loggingPrefixer, (String)"loggingPrefixer");
        return new LoggingInterceptor(filterCredentials, logger, loggingPrefixer);
    }

    private final String convertFileNameToSafeValue(String fileName) {
        String string2 = URLEncoder.encode(StringsKt.replace$default((String)fileName, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(fileName.replace(\"\\\"\", \"\\\\\\\"\"), UTF_8)");
        return string2;
    }

    private final void log(String message) {
        Logger.DefaultImpls.log$default(this.config.getLogger(), Logger.LogLevel.VERBOSE, "[SET CREDENTIALS IN API] " + ((SecureInfoStripper)this.secureInfoStripper.getValue()).strip(message), null, 4, null);
    }

    public static final /* synthetic */ void access$updateClient(OkHttpExecutor $this, VKOkHttpProvider provider) {
        $this.updateClient(provider);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor$Companion;", "", "()V", "MIME_APPLICATION", "", "UTF_8", "defaultApiEndpoint", "host", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String defaultApiEndpoint(String host) {
            return "https://" + host + "/method";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J+\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor$ExecutorResponse;", "", "responseBodyJson", "Lorg/json/JSONObject;", "headers", "Lokhttp3/Headers;", "executorRequestAccessToken", "", "(Lorg/json/JSONObject;Lokhttp3/Headers;Ljava/lang/String;)V", "getExecutorRequestAccessToken", "()Ljava/lang/String;", "getHeaders", "()Lokhttp3/Headers;", "getResponseBodyJson", "()Lorg/json/JSONObject;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core_release"})
    public static final class ExecutorResponse {
        @Nullable
        private final JSONObject responseBodyJson;
        @NotNull
        private final Headers headers;
        @Nullable
        private final String executorRequestAccessToken;

        public ExecutorResponse(@Nullable JSONObject responseBodyJson, @NotNull Headers headers, @Nullable String executorRequestAccessToken) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            this.responseBodyJson = responseBodyJson;
            this.headers = headers;
            this.executorRequestAccessToken = executorRequestAccessToken;
        }

        public /* synthetic */ ExecutorResponse(JSONObject jSONObject, Headers headers, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            this(jSONObject, headers, string2);
        }

        @Nullable
        public final JSONObject getResponseBodyJson() {
            return this.responseBodyJson;
        }

        @NotNull
        public final Headers getHeaders() {
            return this.headers;
        }

        @Nullable
        public final String getExecutorRequestAccessToken() {
            return this.executorRequestAccessToken;
        }

        @Nullable
        public final JSONObject component1() {
            return this.responseBodyJson;
        }

        @NotNull
        public final Headers component2() {
            return this.headers;
        }

        @Nullable
        public final String component3() {
            return this.executorRequestAccessToken;
        }

        @NotNull
        public final ExecutorResponse copy(@Nullable JSONObject responseBodyJson, @NotNull Headers headers, @Nullable String executorRequestAccessToken) {
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            return new ExecutorResponse(responseBodyJson, headers, executorRequestAccessToken);
        }

        public static /* synthetic */ ExecutorResponse copy$default(ExecutorResponse executorResponse, JSONObject jSONObject, Headers headers, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                jSONObject = executorResponse.responseBodyJson;
            }
            if ((n & 2) != 0) {
                headers = executorResponse.headers;
            }
            if ((n & 4) != 0) {
                string2 = executorResponse.executorRequestAccessToken;
            }
            return executorResponse.copy(jSONObject, headers, string2);
        }

        @NotNull
        public String toString() {
            return "ExecutorResponse(responseBodyJson=" + this.responseBodyJson + ", headers=" + this.headers + ", executorRequestAccessToken=" + this.executorRequestAccessToken + ')';
        }

        public int hashCode() {
            int result = this.responseBodyJson == null ? 0 : this.responseBodyJson.hashCode();
            result = result * 31 + this.headers.hashCode();
            result = result * 31 + (this.executorRequestAccessToken == null ? 0 : this.executorRequestAccessToken.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExecutorResponse)) {
                return false;
            }
            ExecutorResponse executorResponse = (ExecutorResponse)other;
            if (!Intrinsics.areEqual((Object)this.responseBodyJson, (Object)executorResponse.responseBodyJson)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headers, (Object)executorResponse.headers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.executorRequestAccessToken, (Object)executorResponse.executorRequestAccessToken);
        }
    }
}

