/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import com.vk.api.sdk.VKApiConfig;
import com.vk.api.sdk.VKApiCredentials;
import com.vk.api.sdk.VKOkHttpProvider;
import com.vk.api.sdk.internal.Validation;
import com.vk.api.sdk.okhttp.LoggingPrefixer;
import com.vk.api.sdk.response.ResponseBodyJsonConverter;
import com.vk.api.sdk.utils.VKApiCredentialsExtKt;
import com.vk.api.sdk.utils.log.Logger;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00105\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0019\u00103\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u001c8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u001e\u00a8\u00067"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "", "apiConfig", "Lcom/vk/api/sdk/VKApiConfig;", "(Lcom/vk/api/sdk/VKApiConfig;)V", "appId", "", "getAppId", "()I", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "credentials", "Lkotlin/Lazy;", "", "Lcom/vk/api/sdk/VKApiCredentials;", "getCredentials", "()Lkotlin/Lazy;", "customEndpoint", "", "getCustomEndpoint", "()Ljava/lang/String;", "expiresInReduceRatio", "", "getExpiresInReduceRatio", "()D", "hostProvider", "Lkotlin/Function0;", "getHostProvider", "()Lkotlin/jvm/functions/Function0;", "logFilterCredentials", "", "getLogFilterCredentials", "()Z", "logger", "Lcom/vk/api/sdk/utils/log/Logger;", "getLogger", "()Lcom/vk/api/sdk/utils/log/Logger;", "loggingPrefixer", "Lcom/vk/api/sdk/okhttp/LoggingPrefixer;", "getLoggingPrefixer", "()Lcom/vk/api/sdk/okhttp/LoggingPrefixer;", "okHttpProvider", "Lcom/vk/api/sdk/VKOkHttpProvider;", "getOkHttpProvider", "()Lcom/vk/api/sdk/VKOkHttpProvider;", "responseBodyJsonConverter", "Lcom/vk/api/sdk/response/ResponseBodyJsonConverter;", "getResponseBodyJsonConverter", "()Lcom/vk/api/sdk/response/ResponseBodyJsonConverter;", "xScreenProvider", "getXScreenProvider", "toString", "Companion", "core_release"})
public final class OkHttpExecutorConfig {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final VKApiConfig apiConfig;
    @Deprecated
    @NotNull
    private static final String EXPIRES_IN_REDUCE_RATIO = "reduce_ratio";

    public OkHttpExecutorConfig(@NotNull VKApiConfig apiConfig) {
        Intrinsics.checkNotNullParameter((Object)apiConfig, (String)"apiConfig");
        this.apiConfig = apiConfig;
        Validation.INSTANCE.assertContextValid(this.getContext());
    }

    @NotNull
    public final Context getContext() {
        return this.apiConfig.getContext();
    }

    public final int getAppId() {
        return this.apiConfig.getAppId();
    }

    @NotNull
    public final Function0<String> getHostProvider() {
        return this.apiConfig.getApiHostProvider();
    }

    @NotNull
    public final Lazy<List<VKApiCredentials>> getCredentials() {
        return this.apiConfig.getCredentials$core_release();
    }

    @NotNull
    public final VKOkHttpProvider getOkHttpProvider() {
        return this.apiConfig.getOkHttpProvider();
    }

    public final boolean getLogFilterCredentials() {
        return this.apiConfig.getLogFilterCredentials();
    }

    @NotNull
    public final Logger getLogger() {
        return this.apiConfig.getLogger();
    }

    @NotNull
    public final LoggingPrefixer getLoggingPrefixer() {
        return this.apiConfig.getLoggingPrefixer();
    }

    @NotNull
    public final String getCustomEndpoint() {
        return (String)this.apiConfig.getCustomApiEndpoint().invoke();
    }

    @NotNull
    public final ResponseBodyJsonConverter getResponseBodyJsonConverter() {
        return this.apiConfig.getResponseBodyJsonConverter();
    }

    public final double getExpiresInReduceRatio() {
        JSONObject jSONObject = (JSONObject)this.apiConfig.getExpiresInReduceRatioJson().invoke();
        return jSONObject != null ? RangesKt.coerceAtLeast((double)RangesKt.coerceAtMost((double)jSONObject.optDouble(EXPIRES_IN_REDUCE_RATIO, 0.95), (double)1.0), (double)0.2) : 0.95;
    }

    @Nullable
    public final Function0<String> getXScreenProvider() {
        return this.apiConfig.getXScreenProvider();
    }

    @NotNull
    public String toString() {
        return "OkHttpExecutorConfig(host='" + (String)this.getHostProvider().invoke() + "', accessToken='" + VKApiCredentialsExtKt.activeAccessToken((List)this.getCredentials().getValue()) + "', secret='" + VKApiCredentialsExtKt.activeSecret((List)this.getCredentials().getValue()) + "', logFilterCredentials=" + this.getLogFilterCredentials() + ')';
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig$Companion;", "", "()V", "EXPIRES_IN_REDUCE_RATIO", "", "core_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

