/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import com.vk.api.sdk.VKApiProgressListener;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.http2.StreamResetException;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\rH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody;", "Lokhttp3/RequestBody;", "requestBody", "progressListener", "Lcom/vk/api/sdk/VKApiProgressListener;", "(Lokhttp3/RequestBody;Lcom/vk/api/sdk/VKApiProgressListener;)V", "hasDuplexBody", "", "getHasDuplexBody", "()Z", "hasDuplexBody$delegate", "Lkotlin/Lazy;", "lastNotifyTime", "", "contentLength", "contentType", "Lokhttp3/MediaType;", "isDuplex", "notifyProgressSend", "", "progress", "maxValue", "writeTo", "sink", "Lokio/BufferedSink;", "Companion", "CountingSink", "core_release"})
public final class ProgressRequestBody
extends RequestBody {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RequestBody requestBody;
    @Nullable
    private final VKApiProgressListener progressListener;
    private long lastNotifyTime;
    @NotNull
    private final Lazy hasDuplexBody$delegate;
    private static final long NOTIFY_INTERVAL = TimeUnit.MILLISECONDS.toMillis(160L);

    public ProgressRequestBody(@NotNull RequestBody requestBody, @Nullable VKApiProgressListener progressListener) {
        Intrinsics.checkNotNullParameter((Object)requestBody, (String)"requestBody");
        this.requestBody = requestBody;
        this.progressListener = progressListener;
        this.hasDuplexBody$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ ProgressRequestBody this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                boolean bl;
                block5: {
                    if (ProgressRequestBody.access$getRequestBody$p(this.this$0) instanceof MultipartBody) {
                        Iterable $this$any$iv = ((MultipartBody)ProgressRequestBody.access$getRequestBody$p(this.this$0)).parts();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                MultipartBody.Part it = (MultipartBody.Part)element$iv;
                                boolean bl2 = false;
                                if (!it.body().isDuplex()) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    } else {
                        bl = ProgressRequestBody.access$getRequestBody$p(this.this$0).isDuplex();
                    }
                }
                return bl;
            }
        }));
    }

    private final boolean getHasDuplexBody() {
        Lazy lazy = this.hasDuplexBody$delegate;
        return (Boolean)lazy.getValue();
    }

    @Nullable
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        block2: {
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            BufferedSink bufferedSink = Okio.buffer((Sink)((Sink)new CountingSink((Sink)sink)));
            try {
                this.requestBody.writeTo(bufferedSink);
                bufferedSink.flush();
                bufferedSink.close();
            }
            catch (StreamResetException e) {
                if (this.isDuplex()) break block2;
                throw e;
            }
        }
    }

    public boolean isDuplex() {
        return this.getHasDuplexBody();
    }

    private final void notifyProgressSend(long progress, long maxValue) {
        if (this.progressListener == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.lastNotifyTime;
        if (diff >= NOTIFY_INTERVAL) {
            float scale = 1000.0f / (float)maxValue;
            int progressValue = (int)((float)progress * scale);
            int progressMaxValue = (int)((float)maxValue * scale);
            this.progressListener.onProgress(progressValue, progressMaxValue);
            this.lastNotifyTime = System.currentTimeMillis();
        }
    }

    public static final /* synthetic */ RequestBody access$getRequestBody$p(ProgressRequestBody $this) {
        return $this.requestBody;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody$Companion;", "", "()V", "NOTIFY_INTERVAL", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody$CountingSink;", "Lokio/ForwardingSink;", "delegate", "Lokio/Sink;", "(Lcom/vk/api/sdk/okhttp/ProgressRequestBody;Lokio/Sink;)V", "bytesWritten", "", "contentLength", "write", "", "source", "Lokio/Buffer;", "byteCount", "core_release"})
    private final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;
        private long contentLength;

        public CountingSink(Sink delegate2) {
            Intrinsics.checkNotNullParameter((Object)delegate2, (String)"delegate");
            super(delegate2);
            this.contentLength = -1L;
        }

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            if (this.contentLength < 0L) {
                this.contentLength = ProgressRequestBody.this.contentLength();
            }
            if (this.contentLength < 0L) {
                ProgressRequestBody.this.notifyProgressSend(0L, 1L);
            } else {
                ProgressRequestBody.this.notifyProgressSend(this.bytesWritten, this.contentLength);
            }
        }
    }
}

