/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.tokenrefresh;

import com.vk.api.sdk.AccessTokenRefresher;
import com.vk.api.sdk.ApiCredentialsChangeListener;
import com.vk.api.sdk.VKApiIllegalCredentialsListener;
import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.exceptions.RefreshFailCause;
import com.vk.api.sdk.exceptions.UnableToRefreshAccessTokenException;
import com.vk.api.sdk.utils.log.Logger;
import com.vk.dto.common.id.UserId;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ)\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/vk/api/sdk/tokenrefresh/AccessTokenRefreshActionInternal;", "", "apiManager", "Lcom/vk/api/sdk/VKApiManager;", "(Lcom/vk/api/sdk/VKApiManager;)V", "forceRefresh", "", "activateForce", "", "refresh", "T", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainCall;Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "refreshImpl", "core_release"})
@SourceDebugExtension(value={"SMAP\nAccessTokenRefreshActionInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessTokenRefreshActionInternal.kt\ncom/vk/api/sdk/tokenrefresh/AccessTokenRefreshActionInternal\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1855#2,2:69\n*S KotlinDebug\n*F\n+ 1 AccessTokenRefreshActionInternal.kt\ncom/vk/api/sdk/tokenrefresh/AccessTokenRefreshActionInternal\n*L\n63#1:69,2\n*E\n"})
public final class AccessTokenRefreshActionInternal {
    @NotNull
    private final VKApiManager apiManager;
    private volatile boolean forceRefresh;

    public AccessTokenRefreshActionInternal(@NotNull VKApiManager apiManager) {
        Intrinsics.checkNotNullParameter((Object)apiManager, (String)"apiManager");
        this.apiManager = apiManager;
    }

    public final void activateForce() {
        this.forceRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <T> T refresh(@NotNull ChainCall<? extends T> chain, @NotNull ChainArgs args) {
        T t;
        Intrinsics.checkNotNullParameter(chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            Object $i$a$-synchronized-AccessTokenRefreshActionInternal$refresh$32;
            if (this.forceRefresh) {
                AccessTokenRefreshActionInternal accessTokenRefreshActionInternal2 = this;
                synchronized (accessTokenRefreshActionInternal2) {
                    boolean $i$a$-synchronized-AccessTokenRefreshActionInternal$refresh$32 = false;
                    if (this.forceRefresh) {
                        this.refreshImpl();
                    }
                    $i$a$-synchronized-AccessTokenRefreshActionInternal$refresh$32 = Unit.INSTANCE;
                }
            }
            boolean isLoggedIn = this.apiManager.getExecutor().isLoggedIn();
            if (!this.apiManager.getExecutor().getTokenContainsAndValid() && isLoggedIn) {
                $i$a$-synchronized-AccessTokenRefreshActionInternal$refresh$32 = this;
                synchronized ($i$a$-synchronized-AccessTokenRefreshActionInternal$refresh$32) {
                    boolean bl = false;
                    if (!this.apiManager.getExecutor().getTokenContainsAndValid()) {
                        this.refreshImpl();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            t = chain.call(args);
        }
        catch (UnableToRefreshAccessTokenException e) {
            this.apiManager.getConfig().getLogger().log(Logger.LogLevel.ERROR, "An error occurred on token refresh, isCritical = " + e.isCritical(), e);
            if (e.isCritical()) {
                VKApiIllegalCredentialsListener vKApiIllegalCredentialsListener = this.apiManager.getIllegalCredentialsListener();
                if (vKApiIllegalCredentialsListener != null) {
                    vKApiIllegalCredentialsListener.onInvalidCredentials("refresh token", null, e.getUserId(), e.getCause());
                }
                return null;
            }
            throw e;
        }
        catch (Throwable other) {
            this.apiManager.getConfig().getLogger().log(Logger.LogLevel.ERROR, "An error occurred on token refresh", other);
            throw other;
        }
        return t;
    }

    private final void refreshImpl() {
        if (!this.apiManager.getExecutor().isLoggedIn()) {
            return;
        }
        Object object = (AccessTokenRefresher)this.apiManager.getConfig().getAccessTokenRefresher().getValue();
        if (object == null || (object = object.refresh()) == null) {
            throw new IllegalStateException("You must set AccessTokenRefresher for ApiConfig");
        }
        Object refreshResult = object;
        ApiCredentialsChangeListener apiCredentialsChangeListener = this.apiManager.getCredentialsChangeListener();
        if (apiCredentialsChangeListener != null) {
            apiCredentialsChangeListener.onCredentialsChanged(((AccessTokenRefresher.RefreshResult)refreshResult).getSuccessRefresh());
        }
        Iterable $this$forEach$iv = ((AccessTokenRefresher.RefreshResult)refreshResult).getErrorRefresh();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserId userId = (UserId)element$iv;
            boolean bl = false;
            VKApiIllegalCredentialsListener vKApiIllegalCredentialsListener = this.apiManager.getIllegalCredentialsListener();
            if (vKApiIllegalCredentialsListener == null) continue;
            vKApiIllegalCredentialsListener.onInvalidCredentials("refresh token", null, userId, new RefreshFailCause.InvalidToken());
        }
        this.forceRefresh = false;
    }
}

