/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.vk.api.sdk.R;
import com.vk.api.sdk.VKScheduler;
import com.vk.api.sdk.utils.VKLoader;
import com.vk.api.sdk.utils.VKUtils;
import com.vk.api.sdk.utils.VKValidationLocker;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0002J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0012\u0010\u0018\u001a\u00020\n2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/vk/api/sdk/ui/VKCaptchaActivity;", "Landroid/app/Activity;", "()V", "image", "Landroid/widget/ImageView;", "input", "Landroid/widget/EditText;", "progress", "Landroid/widget/ProgressBar;", "captchaCancelled", "", "captchaDone", "displayImage", "bitmap", "Landroid/graphics/Bitmap;", "finish", "getHeight", "", "getValidSizeFromIntent", "key", "", "defaultValue", "getWidth", "loadImage", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "Companion", "core_release"})
public final class VKCaptchaActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private EditText input;
    private ImageView image;
    private ProgressBar progress;
    @Nullable
    private static String lastKey;
    public static final float CAPTCHA_DEFAULT_HEIGHT = 50.0f;
    public static final float CAPTCHA_DEFAULT_WIDTH = 130.0f;
    @NotNull
    private static final String KEY_URL = "key_url";
    @NotNull
    private static final String KEY_HEIGHT = "key_height";
    @NotNull
    private static final String KEY_WIDTH = "key_width";

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.overridePendingTransition(0, 0);
        this.setContentView((View)new FrameLayout((Context)this));
        LinearLayout layout2 = new LinearLayout((Context)this);
        int padding = VKUtils.INSTANCE.dp(12);
        int imageWidth = (int)(this.getWidth() * Math.max(1.0f, VKUtils.INSTANCE.density()));
        int imageHeight = (int)(this.getHeight() * Math.max(1.0f, VKUtils.INSTANCE.density()));
        layout2.setPadding(padding, padding, padding, padding);
        layout2.setOrientation(1);
        layout2.setGravity(1);
        FrameLayout imgFrame = new FrameLayout((Context)this);
        LinearLayout.LayoutParams flParams = new LinearLayout.LayoutParams(imageWidth, imageHeight);
        flParams.bottomMargin = padding;
        imgFrame.setLayoutParams((ViewGroup.LayoutParams)flParams);
        this.progress = new ProgressBar((Context)this);
        FrameLayout.LayoutParams pbParams = new FrameLayout.LayoutParams(-2, -2);
        pbParams.gravity = 17;
        ProgressBar progressBar = this.progress;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            progressBar = null;
        }
        progressBar.setLayoutParams((ViewGroup.LayoutParams)pbParams);
        ProgressBar progressBar2 = this.progress;
        if (progressBar2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            progressBar2 = null;
        }
        imgFrame.addView((View)progressBar2);
        this.image = new ImageView((Context)this);
        FrameLayout.LayoutParams ivParams = new FrameLayout.LayoutParams(-1, -1);
        ivParams.gravity = 17;
        ImageView imageView = this.image;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"image");
            imageView = null;
        }
        imageView.setLayoutParams((ViewGroup.LayoutParams)ivParams);
        ImageView imageView2 = this.image;
        if (imageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"image");
            imageView2 = null;
        }
        imgFrame.addView((View)imageView2);
        layout2.addView((View)imgFrame);
        this.input = new EditText((Context)this);
        EditText editText = this.input;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText = null;
        }
        editText.setInputType(176);
        EditText editText2 = this.input;
        if (editText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText2 = null;
        }
        editText2.setSingleLine(true);
        LinearLayout.LayoutParams inParams = new LinearLayout.LayoutParams(imageWidth, -2);
        EditText editText3 = this.input;
        if (editText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText3 = null;
        }
        editText3.setLayoutParams((ViewGroup.LayoutParams)inParams);
        EditText editText4 = this.input;
        if (editText4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText4 = null;
        }
        layout2.addView((View)editText4);
        new AlertDialog.Builder((Context)this, 5).setView((View)layout2).setTitle(R.string.vk_captcha_hint).setPositiveButton(17039370, (arg_0, arg_1) -> VKCaptchaActivity.onCreate$lambda$0(this, arg_0, arg_1)).setNegativeButton(0x1040000, (arg_0, arg_1) -> VKCaptchaActivity.onCreate$lambda$1(this, arg_0, arg_1)).setOnCancelListener(arg_0 -> VKCaptchaActivity.onCreate$lambda$2(this, arg_0)).show();
        EditText editText5 = this.input;
        if (editText5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText5 = null;
        }
        editText5.requestFocus();
        this.loadImage();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(0, 0);
    }

    private final void loadImage() {
        String string2 = this.getIntent().getStringExtra(KEY_URL);
        if (string2 == null) {
            return;
        }
        String url = string2;
        VKScheduler.INSTANCE.getNetworkExecutor().submit(() -> VKCaptchaActivity.loadImage$lambda$4(url, this));
    }

    private final void displayImage(Bitmap bitmap) {
        VKScheduler.runOnMainThread$default(() -> VKCaptchaActivity.displayImage$lambda$5(this, bitmap), 0L, 2, null);
    }

    private final void captchaDone() {
        EditText editText = this.input;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            editText = null;
        }
        lastKey = editText.getText().toString();
        VKValidationLocker.INSTANCE.signal();
        this.finish();
    }

    private final void captchaCancelled() {
        lastKey = null;
        VKValidationLocker.INSTANCE.signal();
        this.setResult(0);
        this.finish();
    }

    private final float getHeight() {
        return this.getValidSizeFromIntent(KEY_HEIGHT, 50.0f);
    }

    private final float getWidth() {
        return this.getValidSizeFromIntent(KEY_WIDTH, 130.0f);
    }

    private final float getValidSizeFromIntent(String key, float defaultValue) {
        int size = this.getIntent().getIntExtra(key, -1);
        return size <= 0 ? defaultValue : (float)size;
    }

    protected void onDestroy() {
        VKValidationLocker.INSTANCE.signal();
        super.onDestroy();
    }

    private static final void onCreate$lambda$0(VKCaptchaActivity this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.captchaDone();
    }

    private static final void onCreate$lambda$1(VKCaptchaActivity this$0, DialogInterface dialogInterface, int n) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.captchaCancelled();
    }

    private static final void onCreate$lambda$2(VKCaptchaActivity this$0, DialogInterface it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.captchaCancelled();
    }

    private static final void loadImage$lambda$4(String $url, VKCaptchaActivity this$0) {
        block0: {
            byte[] data;
            Intrinsics.checkNotNullParameter((Object)$url, (String)"$url");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            if (data == null) break block0;
            byte[] it = data = VKLoader.INSTANCE.load($url);
            boolean bl = false;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"decodeByteArray(data, 0, data.size)");
            this$0.displayImage(bitmap);
        }
    }

    private static final void displayImage$lambda$5(VKCaptchaActivity this$0, Bitmap $bitmap) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        ImageView imageView = this$0.image;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"image");
            imageView = null;
        }
        imageView.setImageBitmap($bitmap);
        ProgressBar progressBar = this$0.progress;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            progressBar = null;
        }
        progressBar.setVisibility(8);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J3\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/vk/api/sdk/ui/VKCaptchaActivity$Companion;", "", "()V", "CAPTCHA_DEFAULT_HEIGHT", "", "CAPTCHA_DEFAULT_WIDTH", "KEY_HEIGHT", "", "KEY_URL", "KEY_WIDTH", "lastKey", "getLastKey", "()Ljava/lang/String;", "setLastKey", "(Ljava/lang/String;)V", "start", "", "context", "Landroid/content/Context;", "img", "height", "", "width", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)V", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getLastKey() {
            return lastKey;
        }

        public final void setLastKey(@Nullable String string2) {
            lastKey = string2;
        }

        public final void start(@NotNull Context context, @NotNull String img, @Nullable Integer height, @Nullable Integer width) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)img, (String)"img");
            VKScheduler.runOnMainThread$default(() -> Companion.start$lambda$0(context, img, height, width), 0L, 2, null);
        }

        public static /* synthetic */ void start$default(Companion companion, Context context, String string2, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 4) != 0) {
                n = null;
            }
            if ((n3 & 8) != 0) {
                n2 = null;
            }
            companion.start(context, string2, n, n2);
        }

        private static final void start$lambda$0(Context $context, String $img, Integer $height, Integer $width) {
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$img, (String)"$img");
            Intent intent = new Intent($context, VKCaptchaActivity.class).addFlags(0x10000000).putExtra(VKCaptchaActivity.KEY_URL, $img).putExtra(VKCaptchaActivity.KEY_HEIGHT, (Serializable)$height).putExtra(VKCaptchaActivity.KEY_WIDTH, (Serializable)$width);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, VKCaptch\u2026utExtra(KEY_WIDTH, width)");
            Intent intent2 = intent;
            $context.startActivity(intent2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

