/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.ui;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import androidx.annotation.RequiresApi;
import com.vk.api.sdk.R;
import com.vk.api.sdk.VK;
import com.vk.api.sdk.VKApiValidationHandler;
import com.vk.api.sdk.auth.VKAuthParams;
import com.vk.api.sdk.extensions.ContextExtKt;
import com.vk.api.sdk.utils.VKUtils;
import com.vk.api.sdk.utils.VKValidationLocker;
import com.vk.dto.common.id.UserId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0003J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0012\u0010\u0018\u001a\u00020\u000e2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u000eH\u0014J\b\u0010\u001c\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity;", "Landroid/app/Activity;", "()V", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "progress", "Landroid/widget/ProgressBar;", "redirectUrl", "", "getRedirectUrl", "()Ljava/lang/String;", "webView", "Landroid/webkit/WebView;", "configureWebView", "", "getUrlParams", "", "handleSuccess", "uri", "Landroid/net/Uri;", "loadUrl", "needValidationResult", "", "notifyLockerAndFinish", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "showWebView", "Companion", "OAuthWebViewClient", "core_release"})
@SourceDebugExtension(value={"SMAP\nVKWebViewAuthActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VKWebViewAuthActivity.kt\ncom/vk/api/sdk/ui/VKWebViewAuthActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1#2:294\n*E\n"})
public class VKWebViewAuthActivity
extends Activity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private WebView webView;
    private ProgressBar progress;
    private VKAuthParams params;
    @NotNull
    public static final String VK_EXTRA_AUTH_PARAMS = "vk_auth_params";
    @NotNull
    public static final String VK_RESULT_INTENT_NAME = "com.vk.auth-token";
    @NotNull
    private static final String LOG_TAG = "VKWebViewAuthActivity";
    @NotNull
    private static final String VK_EXTRA_VALIDATION_URL = "vk_validation_url";
    @Nullable
    private static VKApiValidationHandler.Credentials validationResult;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.vk_webview_auth_dialog);
        View view = this.findViewById(R.id.webView);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.webView)");
        this.webView = (WebView)view;
        View view2 = this.findViewById(R.id.progress);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(R.id.progress)");
        this.progress = (ProgressBar)view2;
        VKAuthParams authParams = VKAuthParams.Companion.fromBundle(this.getIntent().getBundleExtra(VK_EXTRA_AUTH_PARAMS));
        if (authParams == null) {
            if (!this.needValidationResult()) {
                this.finish();
            }
        } else {
            this.params = authParams;
        }
        this.configureWebView();
        this.loadUrl();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void configureWebView() {
        WebView webView;
        WebView webView2 = this.webView;
        if (webView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView2 = null;
        }
        WebView $this$configureWebView_u24lambda_u240 = webView = webView2;
        boolean bl = false;
        $this$configureWebView_u24lambda_u240.setWebViewClient((WebViewClient)new OAuthWebViewClient());
        $this$configureWebView_u24lambda_u240.setVerticalScrollBarEnabled(false);
        $this$configureWebView_u24lambda_u240.setVisibility(4);
        $this$configureWebView_u24lambda_u240.setOverScrollMode(2);
        WebView webView3 = this.webView;
        if (webView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView3 = null;
        }
        WebView $this$configureWebView_u24lambda_u241 = webView = webView3.getSettings();
        boolean bl2 = false;
        $this$configureWebView_u24lambda_u241.setJavaScriptEnabled(true);
    }

    @NotNull
    protected Map<String, String> getUrlParams() {
        Pair[] pairArray = new Pair[7];
        VKAuthParams vKAuthParams = this.params;
        if (vKAuthParams == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            vKAuthParams = null;
        }
        pairArray[0] = TuplesKt.to((Object)"client_id", (Object)String.valueOf(vKAuthParams.getAppId()));
        VKAuthParams vKAuthParams2 = this.params;
        if (vKAuthParams2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            vKAuthParams2 = null;
        }
        pairArray[1] = TuplesKt.to((Object)"scope", (Object)vKAuthParams2.getScopeString());
        VKAuthParams vKAuthParams3 = this.params;
        if (vKAuthParams3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"params");
            vKAuthParams3 = null;
        }
        pairArray[2] = TuplesKt.to((Object)"redirect_uri", (Object)vKAuthParams3.getRedirectUrl());
        pairArray[3] = TuplesKt.to((Object)"response_type", (Object)"token");
        pairArray[4] = TuplesKt.to((Object)"display", (Object)"mobile");
        pairArray[5] = TuplesKt.to((Object)"v", (Object)VK.getApiVersion());
        pairArray[6] = TuplesKt.to((Object)"revoke", (Object)"1");
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private final void loadUrl() {
        try {
            WebView webView;
            String urlToLoad;
            String string2;
            if (this.needValidationResult()) {
                string2 = this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL);
                if (string2 == null) {
                    throw new IllegalStateException("There is no vk_validation_url key inside");
                }
            } else {
                Uri.Builder uri = Uri.parse((String)"https://api.vk.com/oauth/authorize").buildUpon();
                Map<String, String> params = this.getUrlParams();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    String value2 = entry.getValue();
                    uri.appendQueryParameter(key, value2);
                }
                String string3 = uri.build().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                val ur\u2026.toString()\n            }");
                string2 = urlToLoad = string3;
            }
            if ((webView = this.webView) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            webView.loadUrl(urlToLoad);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setResult(0);
            this.finish();
        }
    }

    private final boolean needValidationResult() {
        return this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL) != null;
    }

    private final String getRedirectUrl() {
        String string2;
        if (this.needValidationResult()) {
            string2 = this.getIntent().getStringExtra(VK_EXTRA_VALIDATION_URL);
        } else {
            VKAuthParams vKAuthParams = this.params;
            if (vKAuthParams == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"params");
                vKAuthParams = null;
            }
            string2 = vKAuthParams.getRedirectUrl();
        }
        return string2;
    }

    private final void showWebView() {
        ProgressBar progressBar = this.progress;
        if (progressBar == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
            progressBar = null;
        }
        progressBar.setVisibility(8);
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.setVisibility(0);
    }

    protected void onDestroy() {
        WebView webView = this.webView;
        if (webView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
            webView = null;
        }
        webView.destroy();
        VKValidationLocker.INSTANCE.signal();
        super.onDestroy();
    }

    private final void notifyLockerAndFinish() {
        VKValidationLocker.INSTANCE.signal();
        this.finish();
    }

    private final void handleSuccess(Uri uri) {
        VKApiValidationHandler.Credentials credentials2;
        if (uri.getQueryParameter("access_token") != null) {
            UserId userId;
            String token = uri.getQueryParameter("access_token");
            String secret = uri.getQueryParameter("secret");
            String string2 = uri.getQueryParameter("user_id");
            if (string2 != null) {
                long p0 = Long.parseLong(string2);
                boolean bl = false;
                userId = new UserId(p0);
            } else {
                userId = null;
            }
            UserId userId2 = userId;
            Object object = uri.getQueryParameter("expires_in");
            int expiresInSec = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
            credentials2 = new VKApiValidationHandler.Credentials(secret, token, userId2, expiresInSec, System.currentTimeMillis());
        } else {
            credentials2 = VKApiValidationHandler.Credentials.Companion.getEMPTY();
        }
        validationResult = credentials2;
        this.notifyLockerAndFinish();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity$Companion;", "", "()V", "LOG_TAG", "", "VK_EXTRA_AUTH_PARAMS", "VK_EXTRA_VALIDATION_URL", "VK_RESULT_INTENT_NAME", "validationResult", "Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "getValidationResult", "()Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;", "setValidationResult", "(Lcom/vk/api/sdk/VKApiValidationHandler$Credentials;)V", "createAuthIntent", "Landroid/content/Intent;", "ctx", "Landroid/content/Context;", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "createAuthIntent$core_release", "startForAuth", "", "activity", "Landroid/app/Activity;", "code", "", "startForValidation", "context", "validationUrl", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VKApiValidationHandler.Credentials getValidationResult() {
            return validationResult;
        }

        public final void setValidationResult(@Nullable VKApiValidationHandler.Credentials credentials2) {
            validationResult = credentials2;
        }

        @NotNull
        public final Intent createAuthIntent$core_release(@NotNull Context ctx, @NotNull VKAuthParams params) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intent intent = new Intent(ctx, VKWebViewAuthActivity.class).putExtra(VKWebViewAuthActivity.VK_EXTRA_AUTH_PARAMS, params.toBundle());
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(ctx, VKWebViewAut\u2026ARAMS, params.toBundle())");
            return intent;
        }

        public final void startForAuth(@NotNull Activity activity, @NotNull VKAuthParams params, int code) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intent intent = this.createAuthIntent$core_release((Context)activity, params);
            activity.startActivityForResult(intent, code);
        }

        public final void startForValidation(@NotNull Context context, @NotNull String validationUrl) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)validationUrl, (String)"validationUrl");
            Intent intent = new Intent(context, VKWebViewAuthActivity.class).putExtra(VKWebViewAuthActivity.VK_EXTRA_VALIDATION_URL, validationUrl);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, VKWebVie\u2026ATION_URL, validationUrl)");
            Intent intent2 = intent;
            if (ContextExtKt.toActivitySafe(context) == null) {
                intent2.addFlags(0x10000000);
            }
            context.startActivity(intent2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J&\u0010\u000f\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0017J.\u0010\u0012\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J&\u0010\u0019\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u0016J\u001c\u0010\u001d\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0017J\u001c\u0010\u001d\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/vk/api/sdk/ui/VKWebViewAuthActivity$OAuthWebViewClient;", "Landroid/webkit/WebViewClient;", "(Lcom/vk/api/sdk/ui/VKWebViewAuthActivity;)V", "hasError", "", "handleUrl", "url", "", "onError", "", "errorCode", "", "onPageFinished", "view", "Landroid/webkit/WebView;", "onPageStarted", "favicon", "Landroid/graphics/Bitmap;", "onReceivedError", "request", "Landroid/webkit/WebResourceRequest;", "error", "Landroid/webkit/WebResourceError;", "description", "failingUrl", "onReceivedSslError", "handler", "Landroid/webkit/SslErrorHandler;", "Landroid/net/http/SslError;", "shouldOverrideUrlLoading", "core_release"})
    public final class OAuthWebViewClient
    extends WebViewClient {
        private boolean hasError;

        @RequiresApi(value=21)
        public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
            WebResourceRequest webResourceRequest = request;
            return this.handleUrl(String.valueOf(webResourceRequest != null ? webResourceRequest.getUrl() : null));
        }

        public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
            return this.handleUrl(url);
        }

        private final boolean handleUrl(String url) {
            if (url == null) {
                return false;
            }
            if (VKWebViewAuthActivity.this.needValidationResult()) {
                Uri uri = Uri.parse((String)StringsKt.replace$default((String)url, (String)"#", (String)"?", (boolean)false, (int)4, null));
                if (uri.getQueryParameter("success") != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
                    VKWebViewAuthActivity.this.handleSuccess(uri);
                } else if (uri.getQueryParameter("cancel") != null) {
                    VKWebViewAuthActivity.this.notifyLockerAndFinish();
                }
                return false;
            }
            String safeRedirect = VKWebViewAuthActivity.this.getRedirectUrl();
            if (safeRedirect != null && !StringsKt.startsWith$default((String)url, (String)safeRedirect, (boolean)false, (int)2, null)) {
                return false;
            }
            Intent intent = new Intent(VKWebViewAuthActivity.VK_RESULT_INTENT_NAME);
            String string2 = url.substring(StringsKt.indexOf$default((CharSequence)url, (String)"#", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String extraData = string2;
            intent.putExtra("extra-token-data", extraData);
            Map<String, String> resultParams = VKUtils.explodeQueryString(extraData);
            int resultCode = resultParams != null && (resultParams.containsKey("error") || resultParams.containsKey("cancel")) ? 0 : -1;
            VKWebViewAuthActivity.this.setResult(resultCode, intent);
            VKWebViewAuthActivity.this.notifyLockerAndFinish();
            return true;
        }

        public void onPageStarted(@Nullable WebView view, @Nullable String url, @Nullable Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            this.handleUrl(url);
        }

        public void onPageFinished(@Nullable WebView view, @Nullable String url) {
            super.onPageFinished(view, url);
            if (!this.hasError) {
                VKWebViewAuthActivity.this.showWebView();
            }
        }

        @RequiresApi(value=21)
        public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request, @Nullable WebResourceError error) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            super.onReceivedError(view, request, error);
            String string2 = request.getUrl().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toString()");
            String url = string2;
            String errorDescription2 = "no_description";
            int errorCode = -1;
            if (Build.VERSION.SDK_INT >= 23 && error != null) {
                errorDescription2 = ((Object)error.getDescription()).toString();
                errorCode = error.getErrorCode();
            }
            Log.w((String)VKWebViewAuthActivity.LOG_TAG, (String)("" + errorCode + ':' + errorDescription2 + ':' + url));
            WebView webView = VKWebViewAuthActivity.this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            if (Intrinsics.areEqual((Object)webView.getUrl(), (Object)url)) {
                this.onError(errorCode);
            }
        }

        public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            Log.w((String)VKWebViewAuthActivity.LOG_TAG, (String)("" + errorCode + ':' + description + ':' + failingUrl));
            WebView webView = VKWebViewAuthActivity.this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            if (Intrinsics.areEqual((Object)webView.getUrl(), (Object)failingUrl)) {
                this.onError(errorCode);
            }
        }

        public void onReceivedSslError(@Nullable WebView view, @Nullable SslErrorHandler handler2, @Nullable SslError error) {
            super.onReceivedSslError(view, handler2, error);
            SslError sslError = error;
            String string2 = sslError != null ? sslError.getUrl() : null;
            if (string2 == null) {
                string2 = "";
            }
            String url = string2;
            int errorCode = -11;
            Log.w((String)VKWebViewAuthActivity.LOG_TAG, (String)(errorCode + ":ssl_exception:" + url));
            WebView webView = VKWebViewAuthActivity.this.webView;
            if (webView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"webView");
                webView = null;
            }
            if (Intrinsics.areEqual((Object)webView.getUrl(), (Object)url)) {
                this.onError(errorCode);
            }
        }

        private final void onError(int errorCode) {
            Intent intent;
            this.hasError = true;
            Intent $this$onError_u24lambda_u240 = intent = new Intent();
            boolean bl = false;
            $this$onError_u24lambda_u240.putExtra("vw_login_error", errorCode);
            Intent intent2 = intent;
            VKWebViewAuthActivity.this.setResult(0, intent2);
            VKWebViewAuthActivity.this.finish();
        }
    }
}

