/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import com.vk.api.sdk.utils.ApiMethodPriorityBackoff;
import com.vk.api.sdk.utils.log.Logger;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 .2\u00020\u0001:\u0001.BM\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\tH\u0016J\b\u0010#\u001a\u00020\u0010H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\tH\u0002J\u0010\u0010(\u001a\u00020!2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0010\u0010+\u001a\u00020\t2\u0006\u0010%\u001a\u00020\u0005H\u0016J\u0014\u0010,\u001a\u00020!*\u00020\f2\u0006\u0010-\u001a\u00020\u0005H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00050\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00050\u00050\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/vk/api/sdk/utils/StartUpMethodPriorityBackoffBaseImpl;", "Lcom/vk/api/sdk/utils/ApiMethodPriorityBackoff;", "startUpPriorityMethodsProvider", "Lkotlin/Function0;", "", "", "exceptionMethods", "startUpHeavyMethods", "shouldRestrictHeavyRequestsOnStartUp", "", "shouldWaitForStartUpPriorityRequestsCompletion", "logger", "Lcom/vk/api/sdk/utils/log/Logger;", "(Lkotlin/jvm/functions/Function0;Ljava/util/Collection;Ljava/util/Collection;ZZLcom/vk/api/sdk/utils/log/Logger;)V", "heavyLocksIds", "", "", "locks", "", "Ljava/util/concurrent/locks/Condition;", "methodNames", "notifiedLocksIds", "operationsLock", "Ljava/util/concurrent/locks/ReentrantLock;", "startUpPriorityMethodsQueue", "Ljava/util/concurrent/CopyOnWriteArraySet;", "kotlin.jvm.PlatformType", "getStartUpPriorityMethodsQueue", "()Ljava/util/concurrent/CopyOnWriteArraySet;", "startUpPriorityMethodsQueue$delegate", "Lkotlin/Lazy;", "wasCleared", "clear", "", "isActive", "newId", "notifyAwaiters", "methodName", "notifyLocks", "lightOnly", "onMethodCompleted", "processMethod", "clientId", "shouldWait", "debug", "msg", "Companion", "core_release"})
public final class StartUpMethodPriorityBackoffBaseImpl
implements ApiMethodPriorityBackoff {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Collection<String>> startUpPriorityMethodsProvider;
    @NotNull
    private final Collection<String> exceptionMethods;
    @NotNull
    private final Collection<String> startUpHeavyMethods;
    private final boolean shouldRestrictHeavyRequestsOnStartUp;
    private final boolean shouldWaitForStartUpPriorityRequestsCompletion;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<Integer, Condition> locks;
    @NotNull
    private final Set<Integer> heavyLocksIds;
    @NotNull
    private final Set<Integer> notifiedLocksIds;
    @NotNull
    private final ReentrantLock operationsLock;
    @NotNull
    private final Map<Integer, String> methodNames;
    private volatile boolean wasCleared;
    @NotNull
    private final Lazy startUpPriorityMethodsQueue$delegate;
    public static final long METHOD_WAIT_TIMEOUT = 500L;
    @NotNull
    private static final AtomicInteger idGenerator = new AtomicInteger();

    public StartUpMethodPriorityBackoffBaseImpl(@NotNull Function0<? extends Collection<String>> startUpPriorityMethodsProvider, @NotNull Collection<String> exceptionMethods, @NotNull Collection<String> startUpHeavyMethods, boolean shouldRestrictHeavyRequestsOnStartUp, boolean shouldWaitForStartUpPriorityRequestsCompletion, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(startUpPriorityMethodsProvider, (String)"startUpPriorityMethodsProvider");
        Intrinsics.checkNotNullParameter(exceptionMethods, (String)"exceptionMethods");
        Intrinsics.checkNotNullParameter(startUpHeavyMethods, (String)"startUpHeavyMethods");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.startUpPriorityMethodsProvider = startUpPriorityMethodsProvider;
        this.exceptionMethods = exceptionMethods;
        this.startUpHeavyMethods = startUpHeavyMethods;
        this.shouldRestrictHeavyRequestsOnStartUp = shouldRestrictHeavyRequestsOnStartUp;
        this.shouldWaitForStartUpPriorityRequestsCompletion = shouldWaitForStartUpPriorityRequestsCompletion;
        this.logger = logger;
        this.locks = new LinkedHashMap();
        this.heavyLocksIds = new LinkedHashSet();
        this.notifiedLocksIds = new LinkedHashSet();
        this.operationsLock = new ReentrantLock();
        this.methodNames = new LinkedHashMap();
        this.startUpPriorityMethodsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CopyOnWriteArraySet<String>>(this){
            final /* synthetic */ StartUpMethodPriorityBackoffBaseImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final CopyOnWriteArraySet<String> invoke() {
                return new CopyOnWriteArraySet<String>((Collection)StartUpMethodPriorityBackoffBaseImpl.access$getStartUpPriorityMethodsProvider$p(this.this$0).invoke());
            }
        }));
    }

    private final CopyOnWriteArraySet<String> getStartUpPriorityMethodsQueue() {
        Lazy lazy = this.startUpPriorityMethodsQueue$delegate;
        return (CopyOnWriteArraySet)lazy.getValue();
    }

    @Override
    public boolean isActive() {
        return !((Collection)this.getStartUpPriorityMethodsQueue()).isEmpty() || !this.wasCleared && this.shouldRestrictHeavyRequestsOnStartUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int newId() {
        int newId = idGenerator.incrementAndGet();
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean bl = false;
            Map<Integer, Condition> map = this.locks;
            Integer n = newId;
            Condition condition = this.operationsLock.newCondition();
            Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"operationsLock.newCondition()");
            Condition condition2 = condition;
            map.put(n, condition2);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldWait(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean shouldWait;
            boolean bl = false;
            if (this.exceptionMethods.contains(methodName)) {
                this.notifyAwaiters(methodName);
                boolean bl2 = false;
                return bl2;
            }
            if (!this.wasCleared && this.shouldRestrictHeavyRequestsOnStartUp && this.startUpHeavyMethods.contains(methodName)) {
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = shouldWait = !((Collection)this.getStartUpPriorityMethodsQueue()).isEmpty() && !this.getStartUpPriorityMethodsQueue().contains(methodName);
            if (!shouldWait && !this.shouldWaitForStartUpPriorityRequestsCompletion) {
                this.notifyAwaiters(methodName);
            }
            boolean bl5 = shouldWait;
            return bl5;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMethod(int clientId, @NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            Condition condition;
            boolean bl = false;
            if (this.locks.get(clientId) == null) {
                return;
            }
            Condition condition2 = condition;
            Integer n = clientId;
            this.methodNames.put(n, methodName);
            if (this.shouldWait(methodName)) {
                this.debug(this.logger, "method " + methodName + " will wait, queue.size = " + this.getStartUpPriorityMethodsQueue().size() + ", wasCleared = " + this.wasCleared);
                if (this.shouldRestrictHeavyRequestsOnStartUp && this.startUpHeavyMethods.contains(methodName)) {
                    this.debug(this.logger, "method " + methodName + " will wait for start up completion");
                    n = clientId;
                    ((Collection)this.heavyLocksIds).add(n);
                    condition2.await();
                    this.debug(this.logger, "method " + methodName + " awoke after waiting for start up completion");
                } else if (this.shouldWaitForStartUpPriorityRequestsCompletion) {
                    this.debug(this.logger, "method " + methodName + " will wait for priority requests completion");
                    condition2.await();
                    this.debug(this.logger, "method " + methodName + " awoke after waiting for priority requests completion");
                } else {
                    this.debug(this.logger, "method " + methodName + " will wait for 500 ms");
                    condition2.await(500L, TimeUnit.MILLISECONDS);
                    this.debug(this.logger, "method " + methodName + " awoke after waiting for 500 ms");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMethodCompleted(@NotNull String methodName) {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean bl = false;
            this.notifyAwaiters(methodName);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock lock = this.operationsLock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.wasCleared) {
                return;
            }
            this.debug(this.logger, "clear started");
            this.wasCleared = true;
            this.getStartUpPriorityMethodsQueue().clear();
            this.notifyLocks(false);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void notifyLocks(boolean lightOnly) {
        this.debug(this.logger, "notifying " + (lightOnly ? "light only" : "all") + " locks");
        Iterator<Integer> iterator = this.locks.keySet().iterator();
        while (iterator.hasNext()) {
            int lockId = ((Number)iterator.next()).intValue();
            if (this.notifiedLocksIds.contains(lockId) || lightOnly && this.heavyLocksIds.contains(lockId)) continue;
            this.debug(this.logger, "notifying lock for " + this.methodNames.get(lockId));
            Condition condition = this.locks.get(lockId);
            if (condition != null) {
                condition.signalAll();
            }
            this.notifiedLocksIds.add(lockId);
        }
    }

    private final void notifyAwaiters(String methodName) {
        this.debug(this.logger, "notifyMethodCall: " + methodName);
        if (this.getStartUpPriorityMethodsQueue().remove(methodName)) {
            this.debug(this.logger, "removed method " + methodName + " from priority queue");
        }
        if (this.getStartUpPriorityMethodsQueue().isEmpty()) {
            this.debug(this.logger, "priority queue is empty, notifying");
            this.notifyLocks(true);
            return;
        }
    }

    private final void debug(Logger $this$debug, String msg) {
        Logger.DefaultImpls.log$default($this$debug, Logger.LogLevel.DEBUG, "StartUpMethodPriorityBackoffBaseImpl: " + msg, null, 4, null);
    }

    public static final /* synthetic */ Function0 access$getStartUpPriorityMethodsProvider$p(StartUpMethodPriorityBackoffBaseImpl $this) {
        return $this.startUpPriorityMethodsProvider;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vk/api/sdk/utils/StartUpMethodPriorityBackoffBaseImpl$Companion;", "", "()V", "METHOD_WAIT_TIMEOUT", "", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

