/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.webkit.CookieManager;
import androidx.annotation.RequiresApi;
import com.vk.api.sdk.utils.ThreadLocalDelegate;
import com.vk.api.sdk.utils.ThreadLocalDelegateKt;
import com.vk.api.sdk.utils.VKUtils;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okio.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ \u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0007J)\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J\u0018\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0007J*\u0010 \u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u000bH\u0007J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'H\u0002J\u0012\u0010(\u001a\u00020\u000b2\b\u0010)\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010*\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006,"}, d2={"Lcom/vk/api/sdk/utils/VKUtils;", "", "()V", "clearAllCookies", "", "density", "", "dp", "", "explodeQueryString", "", "", "queryString", "getCertificateFingerprint", "", "context", "Landroid/content/Context;", "packageName", "(Landroid/content/Context;Ljava/lang/String;)[Ljava/lang/String;", "getDisplayMetrics", "Landroid/util/DisplayMetrics;", "getDisplaySizePreV23", "display", "Landroid/view/Display;", "size", "Landroid/graphics/Point;", "getDisplaySizeV23", "getPhysicalDisplaySize", "height", "isAppEnabled", "", "isAppInstalled", "isIntentAvailable", "action", "data", "Landroid/net/Uri;", "allowedPackage", "toHex", "bytes", "", "toHumanReadableAscii", "string", "width", "MD5", "core_release"})
@SourceDebugExtension(value={"SMAP\nVKUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VKUtils.kt\ncom/vk/api/sdk/utils/VKUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,222:1\n1747#2,3:223\n13579#3,2:226\n*S KotlinDebug\n*F\n+ 1 VKUtils.kt\ncom/vk/api/sdk/utils/VKUtils\n*L\n76#1:223,3\n115#1:226,2\n*E\n"})
public final class VKUtils {
    @NotNull
    public static final VKUtils INSTANCE = new VKUtils();

    private VKUtils() {
    }

    @JvmStatic
    public static final boolean isAppInstalled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            context.getPackageManager().getPackageInfo(packageName, 1);
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isAppEnabled(@NotNull Context context, @NotNull String packageName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            bl = context.getPackageManager().getApplicationInfo((String)packageName, (int)0).enabled;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isIntentAvailable(@NotNull Context context, @NotNull String action, @Nullable Uri data, @NotNull String allowedPackage) {
        boolean bl;
        block4: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)allowedPackage, (String)"allowedPackage");
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null || (object = packageManager.queryIntentActivities(new Intent(action, data), 65536)) == null) {
                return false;
            }
            List resolveInfos = object;
            Iterable $this$any$iv = resolveInfos;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResolveInfo it = (ResolveInfo)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.activityInfo.packageName, (Object)allowedPackage)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> explodeQueryString(@Nullable String queryString) {
        if (queryString == null) {
            return null;
        }
        String[] stringArray = new String[]{"&"};
        List keyValuePairs = StringsKt.split$default((CharSequence)queryString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        HashMap parameters = new HashMap(keyValuePairs.size());
        for (String keyValueString : keyValuePairs) {
            String[] stringArray2 = new String[]{"="};
            List keyValueArray = StringsKt.split$default((CharSequence)keyValueString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            if (keyValueArray.size() <= 1) continue;
            ((Map)parameters).put(keyValueArray.get(0), keyValueArray.get(1));
        }
        return parameters;
    }

    @JvmStatic
    @SuppressLint(value={"Assert"})
    @Nullable
    public static final String[] getCertificateFingerprint(@Nullable Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            if (context == null || context.getPackageManager() == null) {
                return null;
            }
            PackageInfo info = context.getPackageManager().getPackageInfo(packageName, 64);
            if (info.signatures == null) {
                return null;
            }
            String[] result = new String[info.signatures.length];
            int i = 0;
            Intrinsics.checkNotNullExpressionValue((Object)info.signatures, (String)"info.signatures");
            Object[] $this$forEach$iv = info.signatures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Signature it = (Signature)element$iv;
                boolean bl = false;
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(it.toByteArray());
                int n = i;
                i = n + 1;
                byte[] byArray = md.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"md.digest()");
                result[n] = INSTANCE.toHex(byArray);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final void clearAllCookies() {
        CookieManager.getInstance().removeAllCookies(null);
    }

    private final String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        String string2 = "%0" + (bytes.length << 1) + 'X';
        Object[] objectArray = new Object[]{bi};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    public final int dp(int dp) {
        return (int)Math.ceil((float)dp * this.density());
    }

    public final float density() {
        return this.getDisplayMetrics().density;
    }

    @NotNull
    public final DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getSystem().displayMetrics");
        return displayMetrics;
    }

    public final int height(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public final int width(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    @NotNull
    public final Point getPhysicalDisplaySize(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point size = new Point();
        Object object = context.getSystemService("window");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.view.WindowManager");
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 23) {
            this.getDisplaySizeV23(display, size);
        } else {
            this.getDisplaySizePreV23(display, size);
        }
        return size;
    }

    private final void getDisplaySizePreV23(Display display, Point size) {
        block0: {
            Display display2 = display;
            if (display2 == null) break block0;
            display2.getRealSize(size);
        }
    }

    @RequiresApi(value=23)
    private final void getDisplaySizeV23(Display display, Point size) {
        Display.Mode mode;
        Display display2 = display;
        Display.Mode mode2 = mode = display2 != null ? display2.getMode() : null;
        size.x = mode2 != null ? mode2.getPhysicalWidth() : 0;
        Display.Mode mode3 = mode;
        size.y = mode3 != null ? mode3.getPhysicalHeight() : 0;
    }

    @JvmStatic
    @NotNull
    public static final String toHumanReadableAscii(@Nullable String string2) {
        int c;
        if (string2 == null) {
            return "";
        }
        for (int i = 0; i < string2.length(); i += Character.charCount(c)) {
            c = string2.codePointAt(i);
            boolean bl = 32 <= c ? c < 127 : false;
            if (bl) {
                continue;
            }
            Buffer buffer = new Buffer();
            buffer.writeUtf8(string2, 0, i);
            while (i < string2.length()) {
                c = string2.codePointAt(i);
                buffer.writeUtf8CodePoint((32 <= c ? c < 127 : false) ? c : 63);
                i += Character.charCount(c);
            }
            return buffer.readUtf8();
        }
        return string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0010\u0010\u0003\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0005\u001a\u00060\u0006j\u0002`\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/vk/api/sdk/utils/VKUtils$MD5;", "", "()V", "hex", "", "tmpBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getTmpBuilder", "()Ljava/lang/StringBuilder;", "tmpBuilder$delegate", "Lcom/vk/api/sdk/utils/ThreadLocalDelegate;", "convert", "", "h", "", "b", "", "core_release"})
    public static final class MD5 {
        @NotNull
        public static final MD5 INSTANCE;
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private static final char[] hex;
        @NotNull
        private static final ThreadLocalDelegate tmpBuilder$delegate;

        private MD5() {
        }

        private final StringBuilder getTmpBuilder() {
            return (StringBuilder)tmpBuilder$delegate.getValue(this, $$delegatedProperties[0]);
        }

        @JvmStatic
        @NotNull
        public static final String convert(@NotNull String h) {
            Intrinsics.checkNotNullParameter((Object)h, (String)"h");
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                byte[] byArray = h.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                byte[] md5 = md.digest(byArray);
                INSTANCE.getTmpBuilder().setLength(0);
                Intrinsics.checkNotNullExpressionValue((Object)md5, (String)"md5");
                MD5.hex(md5);
                String string2 = INSTANCE.getTmpBuilder().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tmpBuilder.toString()");
                return string2;
            }
            catch (Exception exception) {
                return "";
            }
        }

        @JvmStatic
        private static final void hex(byte[] b) {
            for (byte aB : b) {
                INSTANCE.getTmpBuilder().append(hex[(aB & 0xF0) >> 4]);
                INSTANCE.getTmpBuilder().append(hex[aB & 0xF]);
            }
        }

        static {
            Object[] objectArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MD5.class, "tmpBuilder", "getTmpBuilder()Ljava/lang/StringBuilder;", 0)))};
            $$delegatedProperties = objectArray;
            INSTANCE = new MD5();
            objectArray = new char[16];
            objectArray[0] = (KProperty)48;
            objectArray[1] = (KProperty)49;
            objectArray[2] = (KProperty)50;
            objectArray[3] = (KProperty)51;
            objectArray[4] = (KProperty)52;
            objectArray[5] = (KProperty)53;
            objectArray[6] = (KProperty)54;
            objectArray[7] = (KProperty)55;
            objectArray[8] = (KProperty)56;
            objectArray[9] = (KProperty)57;
            objectArray[10] = (KProperty)97;
            objectArray[11] = (KProperty)98;
            objectArray[12] = (KProperty)99;
            objectArray[13] = (KProperty)100;
            objectArray[14] = (KProperty)101;
            objectArray[15] = (KProperty)102;
            hex = (char[])objectArray;
            tmpBuilder$delegate = ThreadLocalDelegateKt.threadLocal(tmpBuilder.2.INSTANCE);
        }
    }
}

