//
//  Copyright (c) 2014 VK.com
//
//  Permission is hereby granted, free of charge, to any person obtaining a copy of
//  this software and associated documentation files (the "Software"), to deal in
//  the Software without restriction, including without limitation the rights to
//  use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
//  the Software, and to permit persons to whom the Software is furnished to do so,
//  subject to the following conditions:
//
//  The above copyright notice and this permission notice shall be included in all
//  copies or substantial portions of the Software.
//
//  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
//  FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
//  COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
//  IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

package com.vk.sdk.api.model;

import android.os.Parcel;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Array of API docs objects
*/
public class VKDocsArray extends VKList<VKApiDocument> {
    @Override
    public VKApiModel parse(JSONObject response) throws JSONException {
        fill(response, VKApiDocument.class);
        return this;
    }

    @SuppressWarnings("unused")
    public VKDocsArray() {
    }

    public VKDocsArray(Parcel in) {
        super(in);
    }

    public static Creator<VKDocsArray> CREATOR = new Creator<VKDocsArray>() {
        public VKDocsArray createFromParcel(Parcel source) {
            return new VKDocsArray(source);
        }

        public VKDocsArray[] newArray(int size) {
            return new VKDocsArray[size];
        }
    };
}
