/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.vk.sdk.VKUIHelper;
import com.vk.sdk.util.VKStringJoiner;
import com.vk.sdk.util.VKUtil;
import java.util.HashMap;
import java.util.Map;

public class VKAccessToken {
    public static final String ACCESS_TOKEN = "access_token";
    public static final String EXPIRES_IN = "expires_in";
    public static final String USER_ID = "user_id";
    public static final String SECRET = "secret";
    public static final String HTTPS_REQUIRED = "https_required";
    public static final String CREATED = "created";
    public static final String SUCCESS = "success";
    public static final String EMAIL = "email";
    public static final String SCOPE = "scope";
    public String accessToken = null;
    public int expiresIn = 0;
    public String userId = null;
    public String secret = null;
    public boolean httpsRequired = false;
    public long created = 0L;
    public String email = null;
    private Map<String, Boolean> scope = null;
    private static final String VK_SDK_ACCESS_TOKEN_PREF_KEY = "VK_SDK_ACCESS_TOKEN_PLEASE_DONT_TOUCH";
    private static volatile VKAccessToken sCurrentToken;

    public void saveTokenToFile(String filePath) {
        VKUtil.stringToFile(filePath, this.serialize());
    }

    public void saveTokenToSharedPreferences(Context ctx, String tokenKey) {
        if (ctx == null) {
            return;
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString(tokenKey, this.serialize());
        edit.apply();
    }

    public static void removeTokenAtKey(Context ctx, String tokenKey) {
        if (ctx == null) {
            return;
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        SharedPreferences.Editor edit = prefs.edit();
        edit.remove(tokenKey);
        edit.apply();
    }

    private VKAccessToken() {
    }

    protected Map<String, String> tokenParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(ACCESS_TOKEN, this.accessToken);
        params.put(EXPIRES_IN, "" + this.expiresIn);
        params.put(USER_ID, this.userId);
        params.put(CREATED, "" + this.created);
        if (this.scope != null) {
            params.put(SCOPE, TextUtils.join((CharSequence)",", this.scope.keySet()));
        }
        if (this.secret != null) {
            params.put(SECRET, this.secret);
        }
        if (this.httpsRequired) {
            params.put(HTTPS_REQUIRED, "1");
        }
        if (this.email != null) {
            params.put(EMAIL, this.email);
        }
        return params;
    }

    protected String serialize() {
        return VKStringJoiner.joinParams(this.tokenParams());
    }

    public static VKAccessToken tokenFromUrlString(String urlString) {
        if (urlString == null) {
            return null;
        }
        Map<String, String> parameters = VKUtil.explodeQueryString(urlString);
        return VKAccessToken.tokenFromParameters(parameters);
    }

    public static VKAccessToken tokenFromParameters(@Nullable Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        VKAccessToken token = new VKAccessToken();
        try {
            String scope;
            token.accessToken = parameters.get(ACCESS_TOKEN);
            token.userId = parameters.get(USER_ID);
            token.secret = parameters.get(SECRET);
            token.email = parameters.get(EMAIL);
            token.httpsRequired = false;
            if (parameters.get(EXPIRES_IN) != null) {
                token.expiresIn = Integer.parseInt(parameters.get(EXPIRES_IN));
            }
            if ((scope = parameters.get(SCOPE)) != null) {
                HashMap<String, Boolean> scopeMap = new HashMap<String, Boolean>();
                for (String s : scope.split(",")) {
                    scopeMap.put(s, true);
                }
                token.scope = scopeMap;
            }
            if (parameters.containsKey(HTTPS_REQUIRED)) {
                token.httpsRequired = parameters.get(HTTPS_REQUIRED).equals("1");
            } else if (token.secret == null) {
                token.httpsRequired = true;
            }
            token.created = parameters.containsKey(CREATED) ? Long.parseLong(parameters.get(CREATED)) : System.currentTimeMillis();
            return token.accessToken != null ? token : null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static VKAccessToken tokenFromSharedPreferences(Context ctx, String key) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        return VKAccessToken.tokenFromUrlString(prefs.getString(key, null));
    }

    public static VKAccessToken tokenFromFile(String filePath) {
        try {
            String data = VKUtil.fileToString(filePath);
            return VKAccessToken.tokenFromUrlString(data);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isExpired() {
        return this.expiresIn > 0 && (long)(this.expiresIn * 1000) + this.created < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VKAccessToken currentToken() {
        if (sCurrentToken != null) return sCurrentToken;
        Class<VKAccessToken> clazz = VKAccessToken.class;
        synchronized (VKAccessToken.class) {
            if (sCurrentToken != null) return sCurrentToken;
            sCurrentToken = VKAccessToken.tokenFromSharedPreferences(VKUIHelper.getApplicationContext(), VK_SDK_ACCESS_TOKEN_PREF_KEY);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sCurrentToken;
        }
    }

    static VKAccessToken replaceToken(@NonNull Context ctx, @Nullable VKAccessToken newToken) {
        VKAccessToken oldToken = sCurrentToken;
        sCurrentToken = newToken;
        if (sCurrentToken != null) {
            sCurrentToken.save();
        } else {
            VKAccessToken.removeTokenAtKey(ctx, VK_SDK_ACCESS_TOKEN_PREF_KEY);
        }
        return oldToken;
    }

    public void save() {
        this.saveTokenToSharedPreferences(VKUIHelper.getApplicationContext(), VK_SDK_ACCESS_TOKEN_PREF_KEY);
    }

    public boolean hasScope(String ... scopes) {
        boolean allScope = true;
        for (String scopeStr : scopes) {
            if (this.scope.get(scopeStr) != null) continue;
            allScope = false;
            break;
        }
        return allScope;
    }

    public VKAccessToken copyWithToken(@NonNull VKAccessToken token) {
        Map<String, String> newTokenParams = this.tokenParams();
        newTokenParams.putAll(token.tokenParams());
        return VKAccessToken.tokenFromParameters(newTokenParams);
    }
}

