/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.vk.sdk.VKAccessToken;
import com.vk.sdk.VKAccessTokenTracker;
import com.vk.sdk.VKCallback;
import com.vk.sdk.VKObject;
import com.vk.sdk.VKServiceActivity;
import com.vk.sdk.VKUIHelper;
import com.vk.sdk.api.VKError;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.VKResponse;
import com.vk.sdk.util.VKUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class VKSdk {
    private static Handler handler = new Handler(Looper.getMainLooper());
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_API_ERRORS = false;
    public static final String SDK_TAG = "VK SDK";
    public static final String SDK_APP_ID = "com_vk_sdk_AppId";
    public static final String SDK_API_VERSION = "com_vk_sdk_ApiVersion";
    private static final String VK_SDK_APP_ID_PREF_KEY = "VK_SDK_APP_ID_PLEASE_DONT_TOUCH";
    private static final String VK_SDK_APP_VERSION_PREF_KEY = "VK_SDK_APP_VERSION_PLEASE_DONT_TOUCH";
    static final int RESULT_OK = -1;
    static final int RESULT_ERROR = 0;
    static final String EXTRA_ERROR_ID = "vk_extra_error_id";
    private static int sCurrentAppId = 0;
    private final Context applicationContext;
    private static VKSdk vkSdk = null;
    private static boolean sIsCustomInitialize = false;
    private static String sCurrentApiVersion;
    private static volatile LoginState sCurrentLoginState;
    private static ArrayList<String> requestedPermissions;
    private static final List<VKAccessTokenTracker> sVKTokenListeners;

    private VKSdk(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    static void addVKTokenTracker(VKAccessTokenTracker vkAccessTokenTracker) {
        sVKTokenListeners.add(vkAccessTokenTracker);
    }

    static void removeVKTokenTracker(VKAccessTokenTracker vkAccessTokenTracker) {
        sVKTokenListeners.remove(vkAccessTokenTracker);
    }

    static void notifyVKTokenChanged(final VKAccessToken oldToken, final VKAccessToken newToken) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                for (VKAccessTokenTracker listener : sVKTokenListeners) {
                    listener.onVKAccessTokenChanged(oldToken, newToken);
                }
            }
        });
    }

    public static VKSdk customInitialize(Context ctx, int appId, String apiVer) {
        if (appId == 0) {
            appId = VKSdk.getIntFromPref(ctx, VK_SDK_APP_ID_PREF_KEY);
        }
        if (TextUtils.isEmpty((CharSequence)apiVer)) {
            apiVer = VKSdk.getStringFromPref(ctx, VK_SDK_APP_VERSION_PREF_KEY, "5.21");
        }
        if (appId == 0) {
            throw new RuntimeException("your_app_id is 0");
        }
        sIsCustomInitialize = true;
        VKSdk vkSdk = VKSdk.initialize(ctx, appId, apiVer);
        if (sCurrentAppId != 0) {
            VKSdk.storeIntToPref(ctx, VK_SDK_APP_ID_PREF_KEY, sCurrentAppId);
        }
        if (sCurrentApiVersion != null) {
            VKSdk.storeStringToPref(ctx, VK_SDK_APP_VERSION_PREF_KEY, sCurrentApiVersion);
        }
        return vkSdk;
    }

    public static boolean isCustomInitialize() {
        return sIsCustomInitialize;
    }

    public static VKSdk initialize(Context ctx) {
        if (sCurrentAppId != 0) {
            return vkSdk;
        }
        if (!(ctx instanceof Application)) {
            if (ctx == null) {
                throw new NullPointerException("Application context cannot be null");
            }
            throw new RuntimeException("VKSdk.initialize(Context) must be call from Application#onCreate()");
        }
        if (!VKSdk.hasInStack(Application.class, "onCreate")) {
            throw new RuntimeException("VKSdk.initialize(Context) must be call from Application#onCreate()");
        }
        int appId = VKSdk.getIntResByName(ctx, SDK_APP_ID);
        if (appId == 0) {
            throw new RuntimeException("String <integer name=\"com_vk_sdk_AppId\">your_app_id</integer> did not find in your resources.xml");
        }
        return VKSdk.initialize(ctx, appId, VKSdk.getStringResByName(ctx, SDK_API_VERSION, "5.21"));
    }

    private static synchronized VKSdk initialize(Context applicationContext, int appId, String appVer) {
        if (sCurrentAppId == 0) {
            vkSdk = new VKSdk(applicationContext);
            sCurrentAppId = appId;
            sCurrentApiVersion = TextUtils.isEmpty((CharSequence)appVer) ? "5.21" : appVer;
            sCurrentLoginState = LoginState.Unknown;
            VKSdk.wakeUpSession(applicationContext);
        }
        return vkSdk;
    }

    private static String getStringResByName(Context ctx, String aString, String def) {
        int resId = ctx.getResources().getIdentifier(aString, "string", ctx.getPackageName());
        try {
            String ret = ctx.getString(resId);
            return TextUtils.isEmpty((CharSequence)ret) ? def : ret;
        }
        catch (Exception e) {
            return def;
        }
    }

    private static Integer getIntResByName(Context ctx, String aString) {
        int resId = ctx.getResources().getIdentifier(aString, "integer", ctx.getPackageName());
        try {
            return ctx.getResources().getInteger(resId);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void login(@NonNull Activity activity, String ... scope) {
        requestedPermissions = VKSdk.preparingScopeList(scope);
        VKServiceActivity.startLoginActivity(activity, requestedPermissions);
    }

    public static void login(@NonNull Fragment fragment, String ... scope) {
        requestedPermissions = VKSdk.preparingScopeList(scope);
        VKServiceActivity.startLoginActivity(fragment, requestedPermissions);
    }

    public static boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data, @NonNull VKCallback<VKAccessToken> vkCallback) {
        if (requestCode == VKServiceActivity.VKServiceType.Authorization.getOuterCode()) {
            if (resultCode == -1) {
                vkCallback.onResult(VKAccessToken.currentToken());
            } else if (resultCode == 0) {
                vkCallback.onError((VKError)VKObject.getRegisteredObject(data == null ? 0L : data.getLongExtra(EXTRA_ERROR_ID, 0L)));
            }
            return true;
        }
        return false;
    }

    @NonNull
    private static ArrayList<String> preparingScopeList(String ... scope) {
        ArrayList<String> scopeList;
        if (scope == null) {
            scope = new String[]{};
        }
        if (!(scopeList = new ArrayList<String>(Arrays.asList(scope))).contains("offline")) {
            scopeList.add("offline");
        }
        return scopeList;
    }

    static int getsCurrentAppId() {
        return sCurrentAppId;
    }

    static boolean processActivityResult(@NonNull Context ctx, int resultCode, @Nullable Intent result, @Nullable VKCallback<VKAccessToken> callback) {
        if (resultCode != -1 || result == null) {
            if (callback != null) {
                callback.onError(new VKError(-102));
            }
            VKSdk.updateLoginState(ctx);
            return false;
        }
        Map<String, String> tokenParams = null;
        if (result.hasExtra("extra-token-data")) {
            String tokenInfo = result.getStringExtra("extra-token-data");
            tokenParams = VKUtil.explodeQueryString(tokenInfo);
        } else if (result.getExtras() != null) {
            tokenParams = new HashMap<String, String>();
            for (String key : result.getExtras().keySet()) {
                tokenParams.put(key, String.valueOf(result.getExtras().get(key)));
            }
        }
        CheckTokenResult tokenResult = VKSdk.checkAndSetToken(ctx, tokenParams);
        if (tokenResult.error != null && callback != null) {
            callback.onError(tokenResult.error);
        } else if (tokenResult.token != null) {
            if (tokenResult.oldToken != null) {
                VKRequest validationRequest = VKRequest.getRegisteredRequest(result.getLongExtra("extra-validation-request", 0L));
                if (validationRequest != null) {
                    validationRequest.unregisterObject();
                    validationRequest.repeat();
                }
            } else {
                VKSdk.trackVisitor(null);
            }
            if (callback != null) {
                callback.onResult(tokenResult.token);
            }
        }
        requestedPermissions = null;
        VKSdk.updateLoginState(ctx);
        return true;
    }

    private static CheckTokenResult checkAndSetToken(@NonNull Context ctx, @Nullable Map<String, String> tokenParams) {
        VKAccessToken token;
        if (tokenParams != null && requestedPermissions != null) {
            tokenParams.put("scope", TextUtils.join((CharSequence)",", requestedPermissions));
        }
        if ((token = VKAccessToken.tokenFromParameters(tokenParams)) == null || token.accessToken == null) {
            if (tokenParams != null && tokenParams.containsKey("success")) {
                return new CheckTokenResult(VKAccessToken.currentToken(), token != null ? token : VKAccessToken.currentToken());
            }
            VKError error = new VKError(tokenParams);
            if (error.errorMessage != null || error.errorReason != null) {
                error = new VKError(-102);
            }
            return new CheckTokenResult(error);
        }
        VKAccessToken old = VKAccessToken.currentToken();
        if (old != null) {
            VKAccessToken newToken = old.copyWithToken(token);
            VKAccessToken.replaceToken(ctx, old.copyWithToken(token));
            VKSdk.notifyVKTokenChanged(old, newToken);
            return new CheckTokenResult(old, token);
        }
        VKAccessToken.replaceToken(ctx, token);
        VKSdk.notifyVKTokenChanged(old, token);
        return new CheckTokenResult(token);
    }

    public static VKAccessToken getAccessToken() {
        return VKAccessToken.currentToken();
    }

    public static boolean wakeUpSession(@NonNull Context context) {
        return VKSdk.wakeUpSession(context, null);
    }

    public static boolean wakeUpSession(final @NonNull Context context, final VKCallback<LoginState> loginStateCallback) {
        final Context appContext = context.getApplicationContext();
        VKUIHelper.setApplicationContext(appContext);
        VKAccessToken token = VKAccessToken.currentToken();
        if (token != null && token.accessToken != null && !token.isExpired()) {
            VKSdk.forceLoginState(LoginState.Pending, loginStateCallback);
            VKSdk.trackVisitor(new VKRequest.VKRequestListener(){

                @Override
                public void onComplete(VKResponse response) {
                    VKSdk.updateLoginState(context, loginStateCallback);
                }

                @Override
                public void onError(VKError error) {
                    if (error != null && error.apiError != null && error.apiError.errorCode == 5) {
                        VKSdk.onAccessTokenIsInvalid(appContext);
                    }
                    VKSdk.updateLoginState(context, loginStateCallback);
                }
            });
            return true;
        }
        VKSdk.updateLoginState(context, loginStateCallback);
        return false;
    }

    private static void onAccessTokenIsInvalid(@NonNull Context ctx) {
        VKAccessToken old = VKAccessToken.replaceToken(ctx, null);
        if (old != null) {
            VKSdk.notifyVKTokenChanged(old, null);
        }
    }

    public static void notifySdkAboutApiError(VKError apiError) {
        if (apiError.errorCode == 5) {
            VKSdk.onAccessTokenIsInvalid(VKUIHelper.getApplicationContext());
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void logout() {
        Context context = VKUIHelper.getApplicationContext();
        if (Build.VERSION.SDK_INT < 21) {
            CookieSyncManager.createInstance((Context)context);
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
        } else {
            CookieManager.getInstance().removeAllCookies(null);
        }
        VKAccessToken.replaceToken(VKUIHelper.getApplicationContext(), null);
        VKSdk.updateLoginState(context);
    }

    public static boolean isLoggedIn() {
        VKAccessToken token = VKAccessToken.currentToken();
        return token != null && !token.isExpired();
    }

    private static void trackVisitor(VKRequest.VKRequestListener l) {
        VKRequest r = new VKRequest("stats.trackVisitor");
        r.attempts = 0;
        r.executeWithListener(l);
    }

    private static void updateLoginState(Context context) {
        VKSdk.updateLoginState(context, null);
    }

    private static void updateLoginState(Context context, VKCallback<LoginState> callback) {
        VKUIHelper.setApplicationContext(context);
        if (VKAccessToken.currentToken() != null) {
            VKSdk.forceLoginState(LoginState.LoggedIn, callback);
        } else {
            VKSdk.forceLoginState(LoginState.LoggedOut, callback);
        }
    }

    private static void forceLoginState(LoginState newState, VKCallback<LoginState> callback) {
        sCurrentLoginState = newState;
        if (callback != null) {
            callback.onResult(sCurrentLoginState);
        }
    }

    public static String getApiVersion() {
        return sCurrentApiVersion;
    }

    private static boolean hasInStack(@NonNull Class<?> clazz, @NonNull String method) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = stackTrace.length - 2; i >= 0; --i) {
            StackTraceElement element = stackTrace[i];
            try {
                Class<?> aClass = Class.forName(element.getClassName());
                aClass.asSubclass(clazz);
                if (!method.equals(element.getMethodName())) continue;
                return true;
            }
            catch (ClassCastException | ClassNotFoundException exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static int getIntFromPref(@NonNull Context ctx, @NonNull String key) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        return prefs.getInt(key, 0);
    }

    private static void storeIntToPref(@NonNull Context ctx, @NonNull String key, int value) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putInt(key, value);
        edit.apply();
    }

    private static String getStringFromPref(@NonNull Context ctx, @NonNull String key, String def) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        return prefs.getString(key, def);
    }

    private static void storeStringToPref(@NonNull Context ctx, @NonNull String key, String value) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putString(key, value);
        edit.apply();
    }

    static {
        sVKTokenListeners = new CopyOnWriteArrayList<VKAccessTokenTracker>();
    }

    private static class CheckTokenResult {
        public VKAccessToken token;
        public VKAccessToken oldToken;
        public VKError error;

        public CheckTokenResult(VKAccessToken token) {
            this.token = token;
        }

        public CheckTokenResult(VKAccessToken oldToken, VKAccessToken newToken) {
            this.token = newToken;
            this.oldToken = oldToken;
        }

        public CheckTokenResult(VKError err) {
            this.error = err;
        }
    }

    public static enum LoginState {
        Unknown,
        LoggedOut,
        Pending,
        LoggedIn;

    }
}

