/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.vk.sdk.VKAccessToken;
import com.vk.sdk.VKCallback;
import com.vk.sdk.VKObject;
import com.vk.sdk.VKSdk;
import com.vk.sdk.api.VKError;
import com.vk.sdk.dialogs.VKCaptchaDialog;
import com.vk.sdk.dialogs.VKOpenAuthDialog;
import com.vk.sdk.util.VKStringJoiner;
import com.vk.sdk.util.VKUtil;
import java.util.ArrayList;

public class VKServiceActivity
extends Activity
implements DialogInterface.OnDismissListener {
    private static final String VK_APP_FINGERPRINT = "48761EEF50EE53AFC4CC9C5F10E6BDE7F8F5B82F";
    private static final String VK_APP_PACKAGE_ID = "com.vkontakte.android";
    private static final String VK_APP_AUTH_ACTION = "com.vkontakte.android.action.SDK_AUTH";
    private static final String KEY_TYPE = "arg1";
    private static final String KEY_SCOPE_LIST = "arg2";
    private static final String KEY_REQUEST = "arg3";
    private static final String KEY_SDK_CUSTOM_INITIALIZE = "arg4";

    public static void interruptWithError(Context ctx, VKError apiError, VKServiceType type) {
        Intent intent = VKServiceActivity.createIntent(ctx, type);
        intent.setFlags(0x10000000);
        intent.putExtra(KEY_REQUEST, apiError.registerObject());
        if (ctx != null) {
            ctx.startActivity(intent);
        }
    }

    static void startLoginActivity(@NonNull Activity act, @NonNull ArrayList<String> scopeList) {
        Intent intent = VKServiceActivity.createIntent(act.getApplicationContext(), VKServiceType.Authorization);
        intent.putStringArrayListExtra(KEY_SCOPE_LIST, scopeList);
        act.startActivityForResult(intent, VKServiceType.Authorization.getOuterCode());
    }

    @TargetApi(value=11)
    static void startLoginActivity(@NonNull Fragment fr, ArrayList<String> scopeList) {
        Intent intent = VKServiceActivity.createIntent((Context)fr.getActivity().getApplication(), VKServiceType.Authorization);
        intent.putStringArrayListExtra(KEY_SCOPE_LIST, scopeList);
        fr.startActivityForResult(intent, VKServiceType.Authorization.getOuterCode());
    }

    @NonNull
    private static Intent createIntent(Context appCtx, VKServiceType type) {
        Intent intent = new Intent(appCtx, VKServiceActivity.class);
        intent.putExtra(KEY_TYPE, type.name());
        intent.putExtra(KEY_SDK_CUSTOM_INITIALIZE, VKSdk.isCustomInitialize());
        return intent;
    }

    @NonNull
    private VKServiceType getType() {
        return VKServiceType.valueOf(this.getIntent().getStringExtra(KEY_TYPE));
    }

    @Nullable
    private ArrayList<String> getScopeList() {
        return this.getIntent().getStringArrayListExtra(KEY_SCOPE_LIST);
    }

    private long getRequestId() {
        return this.getIntent().getLongExtra(KEY_REQUEST, 0L);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getIntent().getBooleanExtra(KEY_SDK_CUSTOM_INITIALIZE, false)) {
            VKSdk.customInitialize((Context)this, 0, null);
        }
        VKSdk.wakeUpSession(this.getApplicationContext());
        switch (this.getType()) {
            case Authorization: {
                Context ctx = this.getApplicationContext();
                Bundle bundle = new Bundle();
                bundle.putString("version", VKSdk.getApiVersion());
                bundle.putInt("client_id", VKSdk.getsCurrentAppId());
                bundle.putBoolean("revoke", true);
                bundle.putString("scope", VKStringJoiner.join(this.getScopeList(), ","));
                String[] fingerprints = VKUtil.getCertificateFingerprint(ctx, VK_APP_PACKAGE_ID);
                if (VKUtil.isAppInstalled(ctx, VK_APP_PACKAGE_ID) && VKUtil.isIntentAvailable(ctx, VK_APP_AUTH_ACTION) && fingerprints.length > 0 && fingerprints[0].equals(VK_APP_FINGERPRINT)) {
                    if (savedInstanceState != null) break;
                    Intent intent = new Intent(VK_APP_AUTH_ACTION, null);
                    intent.setPackage(VK_APP_PACKAGE_ID);
                    intent.putExtras(bundle);
                    this.startActivityForResult(intent, VKServiceType.Authorization.getOuterCode());
                    break;
                }
                new VKOpenAuthDialog().show(this, bundle, VKServiceType.Authorization.getOuterCode(), null);
                break;
            }
            case Captcha: {
                VKError vkError = (VKError)VKObject.getRegisteredObject(this.getRequestId());
                if (vkError != null) {
                    new VKCaptchaDialog(vkError).show((Context)this, this);
                    break;
                }
                this.finish();
                break;
            }
            case Validation: {
                VKError vkError = (VKError)VKObject.getRegisteredObject(this.getRequestId());
                if (vkError != null) {
                    if (!(TextUtils.isEmpty((CharSequence)vkError.redirectUri) || vkError.redirectUri.contains("&ui=vk_sdk") || vkError.redirectUri.contains("?ui=vk_sdk"))) {
                        vkError.redirectUri = vkError.redirectUri.indexOf(63) > 0 ? vkError.redirectUri + "&ui=vk_sdk" : vkError.redirectUri + "?ui=vk_sdk";
                    }
                    new VKOpenAuthDialog().show(this, new Bundle(), VKServiceType.Validation.getOuterCode(), vkError);
                    break;
                }
                this.finish();
            }
        }
    }

    public void onActivityResultPublic(int requestCode, int resultCode, Intent data) {
        this.onActivityResult(requestCode, resultCode, data);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == VKServiceType.Authorization.getOuterCode() || requestCode == VKServiceType.Validation.getOuterCode()) {
            VKSdk.processActivityResult((Context)this, resultCode, data, new VKCallback<VKAccessToken>(){

                @Override
                public void onResult(VKAccessToken res) {
                    VKServiceActivity.this.setResult(-1);
                    VKServiceActivity.this.finish();
                }

                @Override
                public void onError(VKError error) {
                    VKObject o = VKObject.getRegisteredObject(VKServiceActivity.this.getRequestId());
                    if (o instanceof VKError) {
                        VKError vkError = (VKError)o;
                        if (vkError.request != null) {
                            vkError.request.cancel();
                            if (vkError.request.requestListener != null) {
                                vkError.request.requestListener.onError(error);
                            }
                        }
                    }
                    if (error != null) {
                        VKServiceActivity.this.setResult(0, VKServiceActivity.this.getIntent().putExtra("vk_extra_error_id", error.registerObject()));
                    } else {
                        VKServiceActivity.this.setResult(0);
                    }
                    VKServiceActivity.this.finish();
                }
            });
        }
    }

    public void onDismiss(DialogInterface dialog) {
        this.finish();
    }

    public static enum VKServiceType {
        Authorization(10485),
        Captcha(14079),
        Validation(11477);

        private int outerCode;

        private VKServiceType(int outerCode) {
            this.outerCode = outerCode;
        }

        public int getOuterCode() {
            return this.outerCode;
        }
    }
}

