/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api;

import android.os.Handler;
import android.os.Looper;
import com.vk.sdk.VKObject;
import com.vk.sdk.api.VKError;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.VKResponse;
import com.vk.sdk.api.httpClient.VKHttpClient;

public class VKBatchRequest
extends VKObject {
    private final VKRequest[] mRequests;
    private final VKResponse[] mResponses;
    private final VKRequest.VKRequestListener[] mOriginalListeners;
    private boolean mCanceled = false;
    public VKBatchRequestListener requestListener;

    public VKBatchRequest(VKRequest ... requests) {
        this.mRequests = requests;
        this.mResponses = new VKResponse[this.mRequests.length];
        this.mOriginalListeners = new VKRequest.VKRequestListener[this.mRequests.length];
        for (int i = 0; i < this.mRequests.length; ++i) {
            this.mOriginalListeners[i] = this.mRequests[i].requestListener;
        }
    }

    public void executeWithListener(VKBatchRequestListener listener) {
        if (this.mRequests == null) {
            this.provideError(new VKError(-103));
            return;
        }
        this.requestListener = listener;
        Handler intervalHandler = new Handler(Looper.myLooper());
        int nextInterval = 0;
        for (final VKRequest request : this.mRequests) {
            intervalHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    final VKRequest.VKRequestListener originalListener = request.requestListener;
                    request.setRequestListener(new VKRequest.VKRequestListener(){

                        @Override
                        public void onComplete(VKResponse response) {
                            VKBatchRequest.this.provideResponse(response);
                        }

                        @Override
                        public void onError(VKError error) {
                            VKBatchRequest.this.provideError(error);
                        }

                        @Override
                        public void onProgress(VKRequest.VKProgressType progressType, long bytesLoaded, long bytesTotal) {
                            if (originalListener != null) {
                                originalListener.onProgress(progressType, bytesLoaded, bytesTotal);
                            }
                        }
                    });
                    VKHttpClient.enqueueOperation(request.getOperation());
                }
            }, (long)nextInterval);
            nextInterval += 333;
        }
    }

    public void cancel() {
        if (this.mCanceled) {
            return;
        }
        this.mCanceled = true;
        for (VKRequest request : this.mRequests) {
            request.cancel();
        }
    }

    protected void provideResponse(VKResponse response) {
        this.mResponses[this.indexOfRequest((VKRequest)response.request)] = response;
        for (VKResponse resp : this.mResponses) {
            if (resp != null) continue;
            return;
        }
        for (int i = 0; i < this.mRequests.length; ++i) {
            VKRequest.VKRequestListener l = this.mOriginalListeners[i];
            if (l == null) continue;
            l.onComplete(this.mResponses[i]);
        }
        if (this.requestListener != null) {
            this.requestListener.onComplete(this.mResponses);
        }
    }

    private int indexOfRequest(VKRequest request) {
        for (int i = 0; i < this.mRequests.length; ++i) {
            if (!this.mRequests[i].equals(request)) continue;
            return i;
        }
        return -1;
    }

    protected void provideError(VKError error) {
        if (this.mCanceled) {
            return;
        }
        for (int i = 0; i < this.mRequests.length; ++i) {
            VKRequest.VKRequestListener l = this.mOriginalListeners[i];
            if (l == null) continue;
            l.onError(error);
        }
        if (this.requestListener != null) {
            this.requestListener.onError(error);
        }
        this.cancel();
    }

    public static abstract class VKBatchRequestListener {
        public void onComplete(VKResponse[] responses) {
        }

        public void onError(VKError error) {
        }
    }
}

