/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api;

import android.net.Uri;
import com.vk.sdk.VKObject;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.util.VKJsonHelper;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class VKError
extends VKObject {
    public static final int VK_API_ERROR = -101;
    public static final int VK_CANCELED = -102;
    public static final int VK_REQUEST_NOT_PREPARED = -103;
    public static final int VK_JSON_FAILED = -104;
    public static final int VK_REQUEST_HTTP_FAILED = -105;
    public Exception httpError;
    public VKError apiError;
    public VKRequest request;
    public int errorCode;
    public String errorMessage;
    public String errorReason;
    public ArrayList<Map<String, String>> requestParams;
    public String captchaSid;
    public String captchaImg;
    public String redirectUri;
    private static final String FAIL = "fail";
    private static final String ERROR_REASON = "error_reason";
    private static final String ERROR_DESCRIPTION = "error_description";

    public VKError(int errorCode) {
        this.errorCode = errorCode;
    }

    public VKError(JSONObject json) throws JSONException {
        VKError internalError = new VKError(json.getInt("error_code"));
        internalError.errorMessage = json.getString("error_msg");
        internalError.requestParams = (ArrayList)VKJsonHelper.toList(json.getJSONArray("request_params"));
        if (internalError.errorCode == 14) {
            internalError.captchaImg = json.getString("captcha_img");
            internalError.captchaSid = json.getString("captcha_sid");
        }
        if (internalError.errorCode == 17) {
            internalError.redirectUri = json.getString("redirect_uri");
        }
        this.errorCode = -101;
        this.apiError = internalError;
    }

    public VKError(Map<String, String> queryParams) {
        this.errorCode = -101;
        this.errorReason = queryParams.get(ERROR_REASON);
        this.errorMessage = Uri.decode((String)queryParams.get(ERROR_DESCRIPTION));
        if (queryParams.containsKey(FAIL)) {
            this.errorReason = "Action failed";
        }
        if (queryParams.containsKey("cancel")) {
            this.errorCode = -102;
            this.errorReason = "User canceled request";
        }
    }

    public void answerCaptcha(String userEnteredCode) {
        VKParameters params = new VKParameters();
        params.put("captcha_sid", this.captchaSid);
        params.put("captcha_key", userEnteredCode);
        this.request.addExtraParameters(params);
        this.request.repeat();
    }

    public static VKError getRegisteredError(long requestId) {
        return (VKError)VKError.getRegisteredObject(requestId);
    }

    private void appendFields(StringBuilder builder) {
        if (this.errorReason != null) {
            builder.append(String.format("; %s", this.errorReason));
        }
        if (this.errorMessage != null) {
            builder.append(String.format("; %s", this.errorMessage));
        }
    }

    public String toString() {
        StringBuilder errorString = new StringBuilder("VKError (");
        switch (this.errorCode) {
            case -101: {
                errorString.append("API error");
                if (this.apiError == null) break;
                errorString.append(this.apiError.toString());
                break;
            }
            case -102: {
                errorString.append("Canceled");
                break;
            }
            case -103: {
                errorString.append("Request wasn't prepared");
                break;
            }
            case -104: {
                errorString.append("JSON failed");
                break;
            }
            case -105: {
                errorString.append("HTTP failed");
                break;
            }
            default: {
                errorString.append(String.format("code: %d; ", this.errorCode));
            }
        }
        this.appendFields(errorString);
        errorString.append(")");
        return errorString.toString();
    }
}

