/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api;

import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.vk.sdk.VKAccessToken;
import com.vk.sdk.VKObject;
import com.vk.sdk.VKSdk;
import com.vk.sdk.VKServiceActivity;
import com.vk.sdk.VKUIHelper;
import com.vk.sdk.api.VKError;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKParser;
import com.vk.sdk.api.VKResponse;
import com.vk.sdk.api.VKSyncRequestUtil;
import com.vk.sdk.api.httpClient.VKAbstractOperation;
import com.vk.sdk.api.httpClient.VKHttpClient;
import com.vk.sdk.api.httpClient.VKHttpOperation;
import com.vk.sdk.api.httpClient.VKJsonOperation;
import com.vk.sdk.api.httpClient.VKModelOperation;
import com.vk.sdk.api.model.VKApiModel;
import com.vk.sdk.util.VKStringJoiner;
import com.vk.sdk.util.VKUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class VKRequest
extends VKObject {
    public final Context context = VKUIHelper.getApplicationContext();
    public final String methodName;
    private final VKParameters mMethodParameters;
    private VKParameters mPreparedParameters;
    private VKAbstractOperation mLoadingOperation;
    private int mAttemptsUsed;
    private ArrayList<VKRequest> mPostRequestsQueue;
    private Class<? extends VKApiModel> mModelClass;
    private VKParser mModelParser;
    private String mPreferredLang;
    private boolean mUseLooperForCallListener = true;
    private Looper mLooper;
    @Nullable
    public VKRequestListener requestListener;
    public boolean shouldInterruptUI;
    public int attempts;
    public boolean secure;
    public boolean useSystemLanguage;
    public boolean parseModel;
    public WeakReference<VKResponse> response;

    public VKParameters getMethodParameters() {
        return this.mMethodParameters;
    }

    public VKRequest(String method) {
        this(method, null);
    }

    public VKRequest(String method, VKParameters parameters) {
        this(method, parameters, null);
    }

    @Deprecated
    public VKRequest(String method, VKParameters parameters, HttpMethod httpMethod, Class<? extends VKApiModel> modelClass) {
        this(method, parameters, modelClass);
    }

    public VKRequest(String method, VKParameters parameters, Class<? extends VKApiModel> modelClass) {
        this.methodName = method;
        if (parameters == null) {
            parameters = new VKParameters();
        }
        this.mMethodParameters = new VKParameters(parameters);
        this.mAttemptsUsed = 0;
        this.secure = true;
        this.attempts = 1;
        this.mPreferredLang = "en";
        this.useSystemLanguage = true;
        this.shouldInterruptUI = true;
        this.setModelClass(modelClass);
    }

    public void setUseLooperForCallListener(boolean useLooperForCallListener) {
        this.mUseLooperForCallListener = useLooperForCallListener;
    }

    public void executeWithListener(VKRequestListener listener) {
        this.requestListener = listener;
        this.start();
    }

    public void executeSyncWithListener(VKRequestListener listener) {
        VKSyncRequestUtil.executeSyncWithListener(this, listener);
    }

    public void setRequestListener(@Nullable VKRequestListener listener) {
        this.requestListener = listener;
    }

    public void executeAfterRequest(VKRequest request, VKRequestListener listener) {
        this.requestListener = listener;
        request.addPostRequest(this);
    }

    private void addPostRequest(VKRequest postRequest) {
        if (this.mPostRequestsQueue == null) {
            this.mPostRequestsQueue = new ArrayList();
        }
        this.mPostRequestsQueue.add(postRequest);
    }

    public VKParameters getPreparedParameters() {
        if (this.mPreparedParameters == null) {
            this.mPreparedParameters = new VKParameters(this.mMethodParameters);
            VKAccessToken token = VKAccessToken.currentToken();
            if (token != null) {
                this.mPreparedParameters.put("access_token", token.accessToken);
                if (token.httpsRequired) {
                    this.secure = true;
                }
            }
            this.mPreparedParameters.put("v", VKSdk.getApiVersion());
            this.mPreparedParameters.put("lang", this.getLang());
            if (this.secure) {
                this.mPreparedParameters.put("https", "1");
            }
            if (token != null && token.secret != null) {
                String sig = this.generateSig(token);
                this.mPreparedParameters.put("sig", sig);
            }
        }
        return this.mPreparedParameters;
    }

    public VKHttpClient.VKHTTPRequest getPreparedRequest() {
        VKHttpClient.VKHTTPRequest request = VKHttpClient.requestWithVkRequest(this);
        if (request == null) {
            VKError error = new VKError(-103);
            this.provideError(error);
            return null;
        }
        return request;
    }

    VKAbstractOperation getOperation() {
        if (this.parseModel) {
            if (this.mModelClass != null) {
                this.mLoadingOperation = new VKModelOperation(this.getPreparedRequest(), this.mModelClass);
            } else if (this.mModelParser != null) {
                this.mLoadingOperation = new VKModelOperation(this.getPreparedRequest(), this.mModelParser);
            }
        }
        if (this.mLoadingOperation == null) {
            this.mLoadingOperation = new VKJsonOperation(this.getPreparedRequest());
        }
        if (this.mLoadingOperation instanceof VKHttpOperation) {
            ((VKHttpOperation)this.mLoadingOperation).setHttpOperationListener(this.getHttpListener());
        }
        return this.mLoadingOperation;
    }

    private VKJsonOperation.VKJSONOperationCompleteListener getHttpListener() {
        return new VKJsonOperation.VKJSONOperationCompleteListener(){

            @Override
            public void onComplete(VKJsonOperation operation, JSONObject response) {
                if (response.has("error")) {
                    try {
                        VKError error = new VKError(response.getJSONObject("error"));
                        if (VKRequest.this.processCommonError(error)) {
                            return;
                        }
                        VKRequest.this.provideError(error);
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    return;
                }
                VKRequest.this.provideResponse(response, VKRequest.this.mLoadingOperation instanceof VKModelOperation ? ((VKModelOperation)((VKRequest)VKRequest.this).mLoadingOperation).parsedModel : null);
            }

            @Override
            public void onError(VKJsonOperation operation, VKError error) {
                if (error.errorCode != -102 && error.errorCode != -101 && operation != null && operation.response != null && operation.response.statusCode == 200) {
                    VKRequest.this.provideResponse(operation.getResponseJson(), null);
                    return;
                }
                if (VKRequest.this.attempts == 0 || ++VKRequest.this.mAttemptsUsed < VKRequest.this.attempts) {
                    if (VKRequest.this.requestListener != null) {
                        VKRequest.this.requestListener.attemptFailed(VKRequest.this, VKRequest.this.mAttemptsUsed, VKRequest.this.attempts);
                    }
                    VKRequest.this.runOnLooper(new Runnable(){

                        @Override
                        public void run() {
                            VKRequest.this.start();
                        }
                    }, 300);
                    return;
                }
                VKRequest.this.provideError(error);
            }
        };
    }

    public void start() {
        this.mLoadingOperation = this.getOperation();
        if (this.mLoadingOperation == null) {
            return;
        }
        if (this.mLooper == null) {
            this.mLooper = Looper.myLooper();
        }
        VKHttpClient.enqueueOperation(this.mLoadingOperation);
    }

    public void repeat() {
        this.mAttemptsUsed = 0;
        this.mPreparedParameters = null;
        this.mLoadingOperation = null;
        this.start();
    }

    public void cancel() {
        if (this.mLoadingOperation != null) {
            this.mLoadingOperation.cancel();
        } else {
            this.provideError(new VKError(-102));
        }
    }

    private void provideError(final VKError error) {
        error.request = this;
        final boolean useLooperForCallListener = this.mUseLooperForCallListener;
        if (!useLooperForCallListener && this.requestListener != null) {
            this.requestListener.onError(error);
        }
        this.runOnLooper(new Runnable(){

            @Override
            public void run() {
                if (useLooperForCallListener && VKRequest.this.requestListener != null) {
                    VKRequest.this.requestListener.onError(error);
                }
                if (VKRequest.this.mPostRequestsQueue != null && VKRequest.this.mPostRequestsQueue.size() > 0) {
                    for (VKRequest postRequest : VKRequest.this.mPostRequestsQueue) {
                        if (postRequest.requestListener == null) continue;
                        postRequest.requestListener.onError(error);
                    }
                }
            }
        });
    }

    private void provideResponse(JSONObject jsonResponse, Object parsedModel) {
        final VKResponse response = new VKResponse();
        response.request = this;
        response.json = jsonResponse;
        response.parsedModel = parsedModel;
        this.response = new WeakReference<VKResponse>(response);
        if (this.mLoadingOperation instanceof VKHttpOperation) {
            response.responseString = ((VKHttpOperation)this.mLoadingOperation).getResponseString();
        }
        final boolean useLooperForCallListener = this.mUseLooperForCallListener;
        this.runOnLooper(new Runnable(){

            @Override
            public void run() {
                if (VKRequest.this.mPostRequestsQueue != null && VKRequest.this.mPostRequestsQueue.size() > 0) {
                    for (VKRequest request : VKRequest.this.mPostRequestsQueue) {
                        request.start();
                    }
                }
                if (useLooperForCallListener && VKRequest.this.requestListener != null) {
                    VKRequest.this.requestListener.onComplete(response);
                }
            }
        });
        if (!useLooperForCallListener && this.requestListener != null) {
            this.requestListener.onComplete(response);
        }
    }

    public void addExtraParameter(String key, Object value) {
        this.mMethodParameters.put(key, value);
    }

    public void addExtraParameters(VKParameters extraParameters) {
        this.mMethodParameters.putAll(extraParameters);
    }

    private String generateSig(VKAccessToken token) {
        String queryString = VKStringJoiner.joinParams(this.mPreparedParameters);
        queryString = String.format(Locale.US, "/method/%s?%s", this.methodName, queryString);
        return VKUtil.md5(queryString + token.secret);
    }

    private boolean processCommonError(VKError error) {
        if (error.errorCode == -101) {
            VKError apiError = error.apiError;
            VKSdk.notifySdkAboutApiError(apiError);
            if (apiError.errorCode == 16) {
                VKAccessToken token = VKAccessToken.currentToken();
                if (token != null) {
                    token.httpsRequired = true;
                    token.save();
                }
                this.repeat();
                return true;
            }
            if (this.shouldInterruptUI) {
                apiError.request = this;
                if (error.apiError.errorCode == 14) {
                    this.mLoadingOperation = null;
                    VKServiceActivity.interruptWithError(this.context, apiError, VKServiceActivity.VKServiceType.Captcha);
                    return true;
                }
                if (apiError.errorCode == 17) {
                    VKServiceActivity.interruptWithError(this.context, apiError, VKServiceActivity.VKServiceType.Validation);
                    return true;
                }
            }
        }
        return false;
    }

    private String getLang() {
        String result = this.mPreferredLang;
        Resources res = Resources.getSystem();
        if (this.useSystemLanguage && res != null) {
            result = res.getConfiguration().locale.getLanguage();
            if (result.equals("uk")) {
                result = "ua";
            }
            if (!Arrays.asList("ru", "en", "ua", "es", "fi", "de", "it").contains(result)) {
                result = this.mPreferredLang;
            }
        }
        return result;
    }

    public void setPreferredLang(String lang) {
        this.useSystemLanguage = false;
        this.mPreferredLang = lang;
    }

    public void setModelClass(Class<? extends VKApiModel> modelClass) {
        this.mModelClass = modelClass;
        if (this.mModelClass != null) {
            this.parseModel = true;
        }
    }

    public void setResponseParser(VKParser parser) {
        this.mModelParser = parser;
        if (this.mModelParser != null) {
            this.parseModel = true;
        }
    }

    private void runOnLooper(Runnable block) {
        this.runOnLooper(block, 0);
    }

    private void runOnLooper(Runnable block, int delay) {
        if (this.mLooper == null) {
            this.mLooper = Looper.getMainLooper();
        }
        if (delay > 0) {
            new Handler(this.mLooper).postDelayed(block, (long)delay);
        } else {
            new Handler(this.mLooper).post(block);
        }
    }

    private void runOnMainLooper(Runnable block) {
        new Handler(Looper.getMainLooper()).post(block);
    }

    public static VKRequest getRegisteredRequest(long requestId) {
        return (VKRequest)VKRequest.getRegisteredObject(requestId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("{").append(this.methodName).append(" ");
        VKParameters parameters = this.getMethodParameters();
        for (String key : parameters.keySet()) {
            builder.append(key).append("=").append(parameters.get(key)).append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public static abstract class VKRequestListener {
        public void onComplete(VKResponse response) {
        }

        public void attemptFailed(VKRequest request, int attemptNumber, int totalAttempts) {
        }

        public void onError(VKError error) {
        }

        public void onProgress(VKProgressType progressType, long bytesLoaded, long bytesTotal) {
        }
    }

    @Deprecated
    public static enum HttpMethod {
        GET,
        POST;

    }

    public static enum VKProgressType {
        Download,
        Upload;

    }
}

