/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api;

import com.vk.sdk.api.VKError;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.VKResponse;
import com.vk.sdk.api.httpClient.VKAbstractOperation;
import com.vk.sdk.api.httpClient.VKHttpClient;
import com.vk.sdk.api.httpClient.VKJsonOperation;
import java.util.concurrent.ExecutorService;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class VKUploadBase
extends VKRequest {
    protected abstract VKRequest getServerRequest();

    protected abstract VKRequest getSaveRequest(JSONObject var1);

    protected abstract VKJsonOperation getUploadOperation(String var1);

    public VKUploadBase() {
        super(null);
    }

    @Override
    public VKAbstractOperation getOperation() {
        return new VKUploadOperation();
    }

    private class VKUploadOperation
    extends VKAbstractOperation {
        protected VKAbstractOperation lastOperation;

        private VKUploadOperation() {
        }

        @Override
        public void start(ExecutorService s) {
            super.start(s);
            final VKRequest.VKRequestListener originalListener = VKUploadBase.this.requestListener;
            VKUploadBase.this.requestListener = new VKRequest.VKRequestListener(){

                @Override
                public void onComplete(VKResponse response) {
                    VKUploadOperation.this.setState(VKAbstractOperation.VKOperationState.Finished);
                    response.request = VKUploadBase.this;
                    if (originalListener != null) {
                        originalListener.onComplete(response);
                    }
                }

                @Override
                public void onError(VKError error) {
                    VKUploadOperation.this.setState(VKAbstractOperation.VKOperationState.Finished);
                    error.request = VKUploadBase.this;
                    if (originalListener != null) {
                        originalListener.onError(error);
                    }
                }

                @Override
                public void onProgress(VKRequest.VKProgressType progressType, long bytesLoaded, long bytesTotal) {
                    if (originalListener != null) {
                        originalListener.onProgress(progressType, bytesLoaded, bytesTotal);
                    }
                }
            };
            this.setState(VKAbstractOperation.VKOperationState.Executing);
            VKRequest serverRequest = VKUploadBase.this.getServerRequest();
            serverRequest.setRequestListener(new VKUploadRequestListener());
            this.lastOperation = serverRequest.getOperation();
            VKHttpClient.enqueueOperation(this.lastOperation);
        }

        @Override
        public void cancel() {
            if (this.lastOperation != null) {
                this.lastOperation.cancel();
            }
            super.cancel();
        }

        @Override
        public void finish() {
            super.finish();
            this.lastOperation = null;
        }

        @Override
        public Object getResultObject() {
            return null;
        }

        private class VKUploadRequestListener
        extends VKRequest.VKRequestListener {
            private VKUploadRequestListener() {
            }

            @Override
            public void onComplete(VKResponse response) {
                block2: {
                    try {
                        String uploadUrl = response.json.getJSONObject("response").getString("upload_url");
                        VKJsonOperation postFileRequest = VKUploadBase.this.getUploadOperation(uploadUrl);
                        postFileRequest.setHttpOperationListener(new VKJsonOperation.VKJSONOperationCompleteListener(){

                            @Override
                            public void onComplete(VKJsonOperation operation, JSONObject response) {
                                VKRequest saveRequest = VKUploadBase.this.getSaveRequest(response);
                                saveRequest.setRequestListener(new VKRequest.VKRequestListener(){

                                    @Override
                                    public void onComplete(VKResponse response) {
                                        if (VKUploadBase.this.requestListener != null) {
                                            VKUploadBase.this.requestListener.onComplete(response);
                                        }
                                        VKUploadOperation.this.setState(VKAbstractOperation.VKOperationState.Finished);
                                    }

                                    @Override
                                    public void onError(VKError error) {
                                        if (VKUploadBase.this.requestListener != null) {
                                            VKUploadBase.this.requestListener.onError(error);
                                        }
                                    }
                                });
                                VKUploadOperation.this.lastOperation = saveRequest.getOperation();
                                VKHttpClient.enqueueOperation(VKUploadOperation.this.lastOperation);
                            }

                            @Override
                            public void onError(VKJsonOperation operation, VKError error) {
                                if (VKUploadBase.this.requestListener != null) {
                                    VKUploadBase.this.requestListener.onError(error);
                                }
                            }
                        });
                        VKUploadOperation.this.lastOperation = postFileRequest;
                        VKHttpClient.enqueueOperation(VKUploadOperation.this.lastOperation);
                    }
                    catch (JSONException e) {
                        VKError error = new VKError(-104);
                        error.httpError = e;
                        error.errorMessage = e.getMessage();
                        if (VKUploadBase.this.requestListener == null) break block2;
                        VKUploadBase.this.requestListener.onError(error);
                    }
                }
            }

            @Override
            public void onError(VKError error) {
                if (VKUploadBase.this.requestListener != null) {
                    VKUploadBase.this.requestListener.onError(error);
                }
            }
        }
    }
}

