/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.httpClient;

import android.support.annotation.Nullable;
import com.vk.sdk.api.VKError;
import java.util.concurrent.ExecutorService;

public abstract class VKAbstractOperation {
    private VKOperationCompleteListener mCompleteListener;
    private VKOperationState mState = VKOperationState.Created;
    private boolean mCanceled = false;
    @Nullable
    private ExecutorService mResponseQueue;

    public VKAbstractOperation() {
        this.setState(VKOperationState.Ready);
    }

    public void start(ExecutorService responseQueue) {
        this.mResponseQueue = responseQueue;
    }

    public void cancel() {
        this.mCanceled = true;
        this.setState(VKOperationState.Canceled);
    }

    public void finish() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (VKAbstractOperation.this.mCompleteListener != null) {
                    VKAbstractOperation.this.mCompleteListener.onComplete();
                }
            }
        };
        if (this.mResponseQueue != null) {
            this.mResponseQueue.submit(r);
        } else {
            r.run();
        }
    }

    public abstract Object getResultObject();

    protected void setCompleteListener(VKOperationCompleteListener listener) {
        this.mCompleteListener = listener;
    }

    protected VKOperationState state() {
        return this.mState;
    }

    protected void setState(VKOperationState state) {
        if (this.isStateTransitionInvalid(this.mState, state, this.mCanceled)) {
            return;
        }
        this.mState = state;
        if (this.mState == VKOperationState.Finished || this.mState == VKOperationState.Canceled) {
            this.finish();
        }
    }

    private boolean isStateTransitionInvalid(VKOperationState fromState, VKOperationState toState, boolean isCancelled) {
        switch (fromState) {
            case Ready: {
                switch (toState) {
                    case Paused: 
                    case Executing: 
                    case Canceled: {
                        return false;
                    }
                    case Finished: {
                        return !isCancelled;
                    }
                }
                return true;
            }
            case Executing: {
                switch (toState) {
                    case Paused: 
                    case Canceled: 
                    case Finished: {
                        return false;
                    }
                }
                return true;
            }
            case Canceled: 
            case Finished: {
                return true;
            }
            case Paused: {
                switch (toState) {
                    case Canceled: {
                        return false;
                    }
                }
                return toState != VKOperationState.Ready;
            }
        }
        return false;
    }

    public static abstract class VKAbstractCompleteListener<OperationType extends VKAbstractOperation, ResponseType> {
        public abstract void onComplete(OperationType var1, ResponseType var2);

        public abstract void onError(OperationType var1, VKError var2);
    }

    public static interface VKOperationCompleteListener {
        public void onComplete();
    }

    public static enum VKOperationState {
        Created,
        Ready,
        Executing,
        Paused,
        Finished,
        Canceled;

    }
}

