/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.httpClient;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.vk.sdk.VKAccessToken;
import com.vk.sdk.VKUIHelper;
import com.vk.sdk.api.VKParameters;
import com.vk.sdk.api.VKRequest;
import com.vk.sdk.api.httpClient.VKAbstractOperation;
import com.vk.sdk.api.httpClient.VKHttpOperation;
import com.vk.sdk.api.httpClient.VKMultipartEntity;
import com.vk.sdk.api.model.VKAttachments;
import com.vk.sdk.util.VKUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;

public class VKHttpClient {
    public static final String sDefaultStringEncoding = "UTF-8";
    private static final ExecutorService mBackgroundExecutor = Executors.newFixedThreadPool(3);
    private static final ExecutorService mResponseService = Executors.newSingleThreadExecutor();

    public static VKHTTPRequest requestWithVkRequest(@NonNull VKRequest vkRequest) {
        VKAccessToken token = VKAccessToken.currentToken();
        VKHTTPRequest result = new VKHTTPRequest(String.format(Locale.US, "http%s://api.vk.com/method/%s", vkRequest.secure || token != null && token.httpsRequired ? "s" : "", vkRequest.methodName));
        result.headers = VKHttpClient.getDefaultHeaders();
        result.setVkParameters(vkRequest.getPreparedParameters());
        return result;
    }

    public static VKHTTPRequest fileUploadRequest(@NonNull String uploadUrl, File ... files) {
        VKHTTPRequest request = new VKHTTPRequest(uploadUrl);
        request.entity = new VKMultipartEntity(files);
        return request;
    }

    public static VKHTTPRequest docUploadRequest(@NonNull String uploadUrl, File file) {
        VKHTTPRequest request = new VKHTTPRequest(uploadUrl);
        request.entity = new VKMultipartEntity(new File[]{file}, "doc");
        return request;
    }

    private static Map<String, String> getDefaultHeaders() {
        return new HashMap<String, String>(){
            private static final long serialVersionUID = 200199014417610665L;
            {
                this.put("Accept-Encoding", "gzip");
            }
        };
    }

    public static void enqueueOperation(final VKAbstractOperation operation) {
        mBackgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                operation.start(mResponseService);
            }
        });
    }

    public static void cancelHttpOperation(final VKHttpOperation operation) {
        mBackgroundExecutor.execute(new Runnable(){

            @Override
            public void run() {
                operation.getUriRequest().abort();
            }
        });
    }

    public static VKHttpResponse execute(VKHTTPRequest request) throws IOException {
        VKHttpResponse response = new VKHttpResponse(request.createConnection(), null);
        if (request.isAborted) {
            return null;
        }
        return response;
    }

    public static interface VKHttpProgressCallback {
        public void onProgress(long var1, long var3);
    }

    public static class VKHttpResponse {
        public final int statusCode;
        public final long contentLength;
        public Map<String, String> responseHeaders = null;
        public final byte[] responseBytes;

        public VKHttpResponse(HttpURLConnection connection, VKHttpProgressCallback progress) throws IOException {
            int bytesRead;
            String contentEncoding;
            this.statusCode = connection.getResponseCode();
            this.contentLength = connection.getContentLength();
            if (connection.getHeaderFields() != null) {
                this.responseHeaders = new HashMap<String, String>();
                for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                    this.responseHeaders.put(header.getKey(), TextUtils.join((CharSequence)",", (Iterable)header.getValue()));
                }
            }
            InputStream inputStream = connection.getInputStream();
            if (this.responseHeaders != null && (contentEncoding = this.responseHeaders.get("Content-Encoding")) != null && contentEncoding.equalsIgnoreCase("gzip")) {
                inputStream = new GZIPInputStream(inputStream);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            long totalBytesRead = 0L;
            if (this.contentLength <= 0L) {
                progress = null;
            }
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
                totalBytesRead += (long)bytesRead;
                if (progress == null) continue;
                progress.onProgress(totalBytesRead, this.contentLength);
            }
            inputStream.close();
            outputStream.flush();
            this.responseBytes = outputStream.toByteArray();
            outputStream.close();
        }
    }

    public static class VKHTTPRequest {
        public URL methodUrl = null;
        public int timeout = 20000;
        public List<Pair<String, String>> parameters = null;
        public VKMultipartEntity entity = null;
        public Map<String, String> headers = null;
        public boolean isAborted = false;
        public HttpURLConnection connection;

        public VKHTTPRequest(@Nullable String url) {
            if (url != null) {
                try {
                    this.methodUrl = new URL(url);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        void writeParams(@NonNull OutputStream os) throws IOException {
            if (this.entity != null) {
                this.entity.writeTo(os);
            } else {
                String query = this.getQuery();
                if (query != null && query.length() > 0) {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os, VKHttpClient.sDefaultStringEncoding));
                    writer.write(query);
                    writer.flush();
                    writer.close();
                }
            }
        }

        void setVkParameters(VKParameters params) {
            ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>(params.size());
            for (Map.Entry entry : params.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof VKAttachments) {
                    pairs.add((Pair<String, String>)new Pair(entry.getKey(), (Object)((VKAttachments)value).toAttachmentsString()));
                    continue;
                }
                if (value instanceof Collection) {
                    Collection values = (Collection)value;
                    pairs.add((Pair<String, String>)new Pair(entry.getKey(), (Object)TextUtils.join((CharSequence)",", (Iterable)values)));
                    continue;
                }
                pairs.add((Pair<String, String>)new Pair(entry.getKey(), (Object)(value == null ? null : String.valueOf(value))));
            }
            this.parameters = pairs;
        }

        public String getQuery() throws UnsupportedEncodingException {
            if (this.parameters == null) {
                return null;
            }
            ArrayList<String> params = new ArrayList<String>(this.parameters.size());
            for (Pair<String, String> pair : this.parameters) {
                if (pair.first == null || pair.second == null) continue;
                params.add(String.format("%s=%s", URLEncoder.encode((String)pair.first, VKHttpClient.sDefaultStringEncoding), URLEncoder.encode((String)pair.second, VKHttpClient.sDefaultStringEncoding)));
            }
            return TextUtils.join((CharSequence)"&", params);
        }

        public void abort() {
            if (this.connection != null) {
                this.connection.disconnect();
            }
            this.isAborted = true;
        }

        HttpURLConnection createConnection() throws IOException {
            URL url = this.methodUrl;
            this.connection = (HttpURLConnection)url.openConnection();
            this.connection.setReadTimeout(this.timeout);
            this.connection.setConnectTimeout(this.timeout + 5000);
            this.connection.setRequestMethod("POST");
            this.connection.setUseCaches(false);
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            try {
                PackageManager packageManager;
                Context ctx = VKUIHelper.getApplicationContext();
                if (ctx != null && (packageManager = ctx.getPackageManager()) != null) {
                    PackageInfo info = packageManager.getPackageInfo(ctx.getPackageName(), 0);
                    this.connection.setRequestProperty("User-Agent", String.format(Locale.US, "%s/%s (%s; Android %d; Scale/%.2f; VK SDK %s; %s)", VKUtil.getApplicationName(ctx), info.versionName, Build.MODEL, Build.VERSION.SDK_INT, Float.valueOf(ctx.getResources().getDisplayMetrics().density), "1.6.9", info.packageName));
                }
            }
            catch (Exception ctx) {
                // empty catch block
            }
            this.connection.setRequestProperty("Connection", "Keep-Alive");
            if (this.headers != null) {
                for (Map.Entry entry : this.headers.entrySet()) {
                    this.connection.addRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if (this.entity != null) {
                this.connection.addRequestProperty("Content-length", this.entity.getContentLength() + "");
                Pair<String, String> contentType = this.entity.getContentType();
                this.connection.addRequestProperty((String)contentType.first, (String)contentType.second);
            }
            OutputStream os = this.connection.getOutputStream();
            this.writeParams(os);
            os.close();
            this.connection.connect();
            return this.connection;
        }
    }
}

