/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.httpClient;

import android.support.annotation.Nullable;
import com.vk.sdk.api.VKError;
import com.vk.sdk.api.httpClient.VKAbstractOperation;
import com.vk.sdk.api.httpClient.VKHttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;

public class VKHttpOperation<ResponseType>
extends VKAbstractOperation {
    private final VKHttpClient.VKHTTPRequest mUriRequest;
    protected Exception mLastException;
    @Nullable
    public VKHttpClient.VKHttpResponse response;
    private String mResponseString;

    public VKHttpOperation(VKHttpClient.VKHTTPRequest uriRequest) {
        this.mUriRequest = uriRequest;
    }

    @Override
    public void start(ExecutorService s) {
        super.start(s);
        this.setState(VKAbstractOperation.VKOperationState.Executing);
        try {
            if (this.mUriRequest.isAborted) {
                return;
            }
            this.response = VKHttpClient.execute(this.mUriRequest);
        }
        catch (IOException e) {
            this.mLastException = e;
        }
        this.setState(VKAbstractOperation.VKOperationState.Finished);
    }

    @Override
    public void finish() {
        this.postExecution();
        super.finish();
    }

    public ResponseType getResultObject() {
        return (ResponseType)(this.response != null ? this.response.responseBytes : null);
    }

    protected boolean postExecution() {
        return true;
    }

    @Override
    public void cancel() {
        VKHttpClient.cancelHttpOperation(this);
        super.cancel();
    }

    public VKHttpClient.VKHTTPRequest getUriRequest() {
        return this.mUriRequest;
    }

    public byte[] getResponseData() {
        return this.response != null ? this.response.responseBytes : null;
    }

    public String getResponseString() {
        if (this.response == null || this.response.responseBytes == null) {
            return null;
        }
        if (this.mResponseString == null) {
            try {
                this.mResponseString = new String(this.response.responseBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.mLastException = e;
            }
        }
        return this.mResponseString;
    }

    protected VKError generateError(Exception e) {
        VKError error = this.state() == VKAbstractOperation.VKOperationState.Canceled ? new VKError(-102) : new VKError(-105);
        if (e != null) {
            error.errorMessage = e.getMessage();
            if (error.errorMessage == null) {
                error.errorMessage = e.toString();
            }
            error.httpError = e;
        }
        return error;
    }

    public <OperationType extends VKHttpOperation> void setHttpOperationListener(final VKAbstractOperation.VKAbstractCompleteListener<OperationType, ResponseType> listener) {
        this.setCompleteListener(new VKAbstractOperation.VKOperationCompleteListener(){

            @Override
            public void onComplete() {
                if (VKHttpOperation.this.state() != VKAbstractOperation.VKOperationState.Finished || VKHttpOperation.this.mLastException != null) {
                    listener.onError(VKHttpOperation.this, VKHttpOperation.this.generateError(VKHttpOperation.this.mLastException));
                } else {
                    listener.onComplete(VKHttpOperation.this, VKHttpOperation.this.getResultObject());
                }
            }
        });
    }
}

