/*
 * Decompiled with CFR 0.152.
 */
package com.vk.sdk.api.httpClient;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Looper;
import com.vk.sdk.api.httpClient.VKAbstractOperation;
import com.vk.sdk.api.httpClient.VKHttpClient;
import com.vk.sdk.api.httpClient.VKHttpOperation;

public class VKImageOperation
extends VKHttpOperation<Bitmap> {
    public float imageDensity;

    public VKImageOperation(String imageUrl) {
        super(new VKHttpClient.VKHTTPRequest(imageUrl));
    }

    @Override
    public Bitmap getResultObject() {
        byte[] response = this.getResponseData();
        Bitmap image = BitmapFactory.decodeByteArray((byte[])response, (int)0, (int)response.length);
        if (this.imageDensity > 0.0f) {
            image = Bitmap.createScaledBitmap((Bitmap)image, (int)((int)((float)image.getWidth() * this.imageDensity)), (int)((int)((float)image.getHeight() * this.imageDensity)), (boolean)true);
        }
        return image;
    }

    public void setImageOperationListener(final VKImageOperationListener listener) {
        this.setCompleteListener(new VKAbstractOperation.VKOperationCompleteListener(){

            @Override
            public void onComplete() {
                if (VKImageOperation.this.state() != VKAbstractOperation.VKOperationState.Finished || VKImageOperation.this.mLastException != null) {
                    listener.onError(VKImageOperation.this, VKImageOperation.this.generateError(VKImageOperation.this.mLastException));
                } else {
                    final Bitmap result = VKImageOperation.this.getResultObject();
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            listener.onComplete(VKImageOperation.this, result);
                        }
                    });
                }
            }
        });
    }

    public static abstract class VKImageOperationListener
    extends VKAbstractOperation.VKAbstractCompleteListener<VKImageOperation, Bitmap> {
    }
}

